/*
 * Decompiled with CFR 0.152.
 */
package io.github.eealba.jasoner.internal;

import io.github.eealba.jasoner.JasonerException;
import io.github.eealba.jasoner.internal.Token;
import io.github.eealba.jasoner.internal.TokenImpl;
import io.github.eealba.jasoner.internal.TokenType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class Tokenizer {
    private static final String ERROR_UNEXPECTED_CHARACTER = "Unexpected token '%c' at position %d";
    private static final int EOF = -1;
    private static final int LIMIT_CONTROL = 31;
    private static final String ERROR_UNEXPECTED_TOKEN = "Unexpected token '%s'";
    private static final String ERROR_EXPECTED_TOKEN = "Expected token '%s'";
    private final String data;
    private final int len;
    private int pos = -1;
    private int ch = -1;
    private int countObjectToken;
    private int countArrayToken;
    private final List<Token> res = new ArrayList<Token>();

    Tokenizer(String data) {
        this.data = Objects.requireNonNull(data);
        this.len = this.data.length();
    }

    List<Token> tokens() {
        this.clear();
        try {
            Token token;
            while ((token = this.nextToken()) != null) {
                if (!this.res.isEmpty()) {
                    this.validateTokenWithPrevious(token, this.res.get(this.res.size() - 1));
                } else if (token.type() != TokenType.ARRAY_START && token.type() != TokenType.OBJECT_START) {
                    throw new JasonerException(String.format(ERROR_UNEXPECTED_TOKEN, token));
                }
                this.res.add(token);
            }
        }
        catch (IOException e) {
            throw new JasonerException(e);
        }
        if (this.countObjectToken > 0) {
            throw new JasonerException(String.format(ERROR_EXPECTED_TOKEN, "}"));
        }
        if (this.countObjectToken < 0) {
            throw new JasonerException(String.format(ERROR_UNEXPECTED_TOKEN, "}"));
        }
        return Collections.unmodifiableList(this.res);
    }

    private void clear() {
        this.res.clear();
        this.countArrayToken = 0;
        this.countObjectToken = 0;
        this.pos = -1;
        this.ch = -1;
    }

    private void validateTokenWithPrevious(Token token, Token previous) {
        switch (token.type()) {
            case ARRAY_START: {
                if (previous.type() == TokenType.COLON || previous.type() == TokenType.COMMA) break;
                throw new JasonerException(String.format(ERROR_UNEXPECTED_TOKEN, token));
            }
            case OBJECT_START: {
                if (previous.type() == TokenType.COLON || previous.type() == TokenType.COMMA || previous.type() == TokenType.ARRAY_START) break;
                throw new JasonerException(String.format(ERROR_UNEXPECTED_TOKEN, token));
            }
            case COMMA: {
                if (previous.type() != TokenType.OBJECT_START && token.type() != TokenType.ARRAY_START) break;
                throw new JasonerException(String.format(ERROR_UNEXPECTED_TOKEN, token));
            }
            case COLON: {
                if (previous.type() == TokenType.TEXT) break;
                throw new JasonerException(String.format(ERROR_UNEXPECTED_TOKEN, token));
            }
        }
    }

    private Token nextToken() throws IOException {
        this.whitespaces();
        if (this.ch == -1) {
            return null;
        }
        this.unRead();
        char _ch = this.readChar();
        if (this.res.isEmpty() && _ch != '{' && _ch != '[') {
            throw new JasonerException(String.format(ERROR_UNEXPECTED_TOKEN, Character.valueOf(_ch)));
        }
        switch (_ch) {
            case '{': {
                ++this.countObjectToken;
                return TokenImpl.OBJECT_START;
            }
            case '}': {
                --this.countObjectToken;
                if (this.countObjectToken < 0) {
                    throw new JasonerException(String.format(ERROR_UNEXPECTED_CHARACTER, Character.valueOf(_ch), this.pos));
                }
                return TokenImpl.OBJECT_END;
            }
            case '[': {
                ++this.countArrayToken;
                return TokenImpl.ARRAY_START;
            }
            case ']': {
                --this.countArrayToken;
                if (this.countArrayToken < 0) {
                    throw new JasonerException(String.format(ERROR_UNEXPECTED_CHARACTER, Character.valueOf(_ch), this.pos));
                }
                return TokenImpl.ARRAY_END;
            }
            case ',': {
                return TokenImpl.COMMA;
            }
            case ':': {
                return TokenImpl.COLON;
            }
            case 't': {
                this.unRead();
                return this.readExpected("true", TokenImpl.TRUE);
            }
            case 'f': {
                this.unRead();
                return this.readExpected("false", TokenImpl.FALSE);
            }
            case 'n': {
                this.unRead();
                return this.readExpected("null", TokenImpl.NULL);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.unRead();
                return this.numberToken();
            }
            case '\"': {
                return this.stringToken();
            }
        }
        throw new JasonerException(String.format(ERROR_UNEXPECTED_CHARACTER, Character.valueOf(_ch), this.pos));
    }

    private void whitespaces() {
        block3: while (true) {
            this.read();
            switch (this.ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
            }
            break;
        }
    }

    private void read() {
        ++this.pos;
        this.ch = this.pos < this.len ? (int)this.data.charAt(this.pos) : -1;
    }

    private char readChar() {
        this.read();
        if (this.ch == -1) {
            throw new JasonerException("Unexpected end of file");
        }
        return (char)this.ch;
    }

    private void unRead() {
        --this.pos;
    }

    private Token readExpected(String val, Token token) {
        StringBuilder buff = new StringBuilder();
        int vlen = val.length();
        for (int i = 0; i < vlen; ++i) {
            buff.append(this.readChar());
        }
        if (val.contentEquals(buff)) {
            return token;
        }
        throw new JasonerException("Error, Expected token " + val + " but got " + val);
    }

    private Token numberToken() {
        StringBuilder buff = new StringBuilder();
        boolean exp = false;
        boolean execute = true;
        block6: while (execute) {
            char ch = this.readChar();
            switch (ch) {
                case '+': {
                    if (buff.isEmpty()) continue block6;
                    throw new JasonerException(String.format(ERROR_UNEXPECTED_CHARACTER, Character.valueOf(ch), this.pos));
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (!buff.isEmpty() && ch == '-' && !buff.substring(buff.length() - 1).equalsIgnoreCase("e")) {
                        throw new JasonerException(String.format(ERROR_UNEXPECTED_CHARACTER, Character.valueOf(ch), this.pos));
                    }
                    buff.append(ch);
                    continue block6;
                }
                case '.': {
                    if (exp || buff.indexOf(".") != -1) {
                        throw new JasonerException(String.format(ERROR_UNEXPECTED_CHARACTER, Character.valueOf(ch), this.pos));
                    }
                    buff.append(ch);
                    continue block6;
                }
                case 'E': 
                case 'e': {
                    buff.append(ch);
                    exp = true;
                    continue block6;
                }
            }
            execute = false;
            this.unRead();
        }
        return TokenImpl.createNumberToken(buff.toString());
    }

    private Token stringToken() {
        StringBuilder buff = new StringBuilder();
        boolean esc = false;
        while (true) {
            char ch = this.readChar();
            if (esc) {
                if (ch <= '\u001f') {
                    buff.append(ch);
                    esc = false;
                }
                switch (ch) {
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case '\"': 
                    case '\\': {
                        buff.append(ch);
                        esc = false;
                        break;
                    }
                    case 'u': {
                        ch = this.readUnicodeSequence();
                        buff.append(ch);
                        esc = false;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                esc = true;
                continue;
            }
            if (ch == '\"') break;
            buff.append(ch);
        }
        return TokenImpl.createTextToken(buff.toString());
    }

    private char readUnicodeSequence() {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            buff.append(this.readChar());
        }
        return (char)Integer.parseInt(buff.toString(), 16);
    }
}

