package org.checkerframework.common.initializedfields.qual;

import org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import org.checkerframework.framework.qual.SubtypeOf;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates which fields have definitely been initialized.
 *
 * @checker_framework.manual #initialized-fields-checker Initialized Fields Checker
 */
@Retention(RetentionPolicy.CLASS)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@SubtypeOf({})
@DefaultQualifierInHierarchy
public @interface InitializedFields {
    /**
     * Fields that have been initialized.
     *
     * @return the initialized fields
     */
    public String[] value() default {};
}
