/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.checkerframework.framework.test.CompilationResult;
import org.checkerframework.framework.test.TestConfiguration;
import org.checkerframework.framework.test.TestUtilities;
import org.checkerframework.framework.test.TypecheckResult;
import org.checkerframework.framework.test.diagnostics.JavaDiagnosticReader;
import org.checkerframework.framework.test.diagnostics.TestDiagnostic;
import org.plumelib.util.StringsPlume;

public class TypecheckExecutor {
    public TypecheckResult runTest(TestConfiguration configuration) {
        try {
            CompilationResult result = this.compile(configuration);
            return this.interpretResults(configuration, result);
        }
        catch (OutOfMemoryError e) {
            String message = String.format("Max memory = %d, total memory = %d, free memory = %d.", Runtime.getRuntime().maxMemory(), Runtime.getRuntime().totalMemory(), Runtime.getRuntime().freeMemory());
            System.out.println(message);
            System.err.println(message);
            throw new Error(message, e);
        }
    }

    public CompilationResult compile(TestConfiguration configuration) {
        CompilationResult compilationResult;
        block11: {
            String dOption = configuration.getOptions().get("-d");
            if (dOption == null) {
                throw new Error("-d not supplied");
            }
            TestUtilities.ensureDirectoryExists(dOption);
            StringWriter javacOutput = new StringWriter();
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            try {
                Iterable<? extends JavaFileObject> javaFiles = fileManager.getJavaFileObjects(configuration.getTestSourceFiles().toArray(new File[0]));
                ArrayList<String> options = new ArrayList<String>();
                options.add("-processor");
                options.add(String.join((CharSequence)",", configuration.getProcessors()));
                ArrayList<String> nonJvmOptions = new ArrayList<String>();
                for (String option : configuration.getFlatOptions()) {
                    if (option.startsWith("-J-")) continue;
                    nonJvmOptions.add(option);
                }
                nonJvmOptions.add("-Xmaxerrs");
                nonJvmOptions.add("100000");
                nonJvmOptions.add("-Xmaxwarns");
                nonJvmOptions.add("100000");
                nonJvmOptions.add("-Xlint:deprecation");
                nonJvmOptions.add("-ApermitMissingJdk");
                nonJvmOptions.add("-Anocheckjdk");
                nonJvmOptions.add("-AnoJreVersionCheck");
                nonJvmOptions.add("-Anomsgtext");
                options.addAll(nonJvmOptions);
                if (configuration.shouldEmitDebugInfo()) {
                    System.out.println("Running test using the following invocation:");
                    System.out.println("javac " + String.join((CharSequence)" ", options) + " " + StringsPlume.join((CharSequence)" ", configuration.getTestSourceFiles()));
                }
                JavaCompiler.CompilationTask task = compiler.getTask(javacOutput, fileManager, diagnostics, options, new ArrayList<String>(), javaFiles);
                Boolean compiledWithoutError = task.call();
                javacOutput.flush();
                compilationResult = new CompilationResult(compiledWithoutError, javacOutput.toString(), javaFiles, diagnostics.getDiagnostics());
                if (fileManager == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (fileManager != null) {
                        try {
                            fileManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
            fileManager.close();
        }
        return compilationResult;
    }

    public TypecheckResult interpretResults(TestConfiguration config, CompilationResult compilationResult) {
        List<TestDiagnostic> expectedDiagnostics = this.readDiagnostics(config, compilationResult);
        return TypecheckResult.fromCompilationResults(config, compilationResult, expectedDiagnostics);
    }

    protected List<TestDiagnostic> readDiagnostics(TestConfiguration config, CompilationResult compilationResult) {
        List<TestDiagnostic> expectedDiagnostics = config.getDiagnosticFiles() == null || config.getDiagnosticFiles().isEmpty() ? JavaDiagnosticReader.readJavaSourceFiles(compilationResult.getJavaFileObjects()) : JavaDiagnosticReader.readDiagnosticFiles(config.getDiagnosticFiles());
        return expectedDiagnostics;
    }
}

