/*
 * Decompiled with CFR 0.152.
 */
package com.raylib;

import com.raylib.MaterialMap;
import com.raylib.Shader;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;
import java.lang.foreign.ValueLayout;

public class Material {
    public final MemorySegment memorySegment;

    public Material() {
        this.memorySegment = com.raylib.jextract.Material.allocate(Arena.ofAuto());
    }

    public Material(SegmentAllocator arena) {
        this.memorySegment = com.raylib.jextract.Material.allocate(arena);
    }

    public Material(MemorySegment memorySegment) {
        this.memorySegment = memorySegment;
    }

    public Material(Shader shader, MaterialMap maps, float[] params) {
        this.memorySegment = com.raylib.jextract.Material.allocate(Arena.ofAuto());
        this.setShader(shader);
        this.setMaps(maps);
        this.setParams(params);
    }

    public Material(SegmentAllocator arena, Shader shader, MaterialMap maps, float[] params) {
        this.memorySegment = com.raylib.jextract.Material.allocate(arena);
        this.setShader(shader);
        this.setMaps(maps);
        this.setParams(params);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Material)) {
            return false;
        }
        Material other = (Material)o;
        return this.memorySegment.equals(other.memorySegment);
    }

    public int hashCode() {
        return this.memorySegment.hashCode();
    }

    public Material getArrayElement(int index) {
        return new Material(com.raylib.jextract.Material.asSlice(this.memorySegment, index));
    }

    public static Material allocateArray(long elementCount, SegmentAllocator allocator) {
        return new Material(com.raylib.jextract.Material.allocateArray(elementCount, allocator));
    }

    public static Material allocateArray(long elementCount) {
        return new Material(com.raylib.jextract.Material.allocateArray(elementCount, Arena.ofAuto()));
    }

    public Shader getShader() {
        return new Shader(com.raylib.jextract.Material.shader(this.memorySegment));
    }

    public void setShader(Shader value) {
        com.raylib.jextract.Material.shader(this.memorySegment, value.memorySegment);
    }

    public Shader shader() {
        return new Shader(com.raylib.jextract.Material.shader(this.memorySegment));
    }

    public Material shader(Shader value) {
        com.raylib.jextract.Material.shader(this.memorySegment, value.memorySegment);
        return this;
    }

    public MaterialMap getMaps() {
        return new MaterialMap(com.raylib.jextract.Material.maps(this.memorySegment));
    }

    public void setMaps(MaterialMap value) {
        com.raylib.jextract.Material.maps(this.memorySegment, value.memorySegment);
    }

    public MaterialMap maps() {
        return new MaterialMap(com.raylib.jextract.Material.maps(this.memorySegment));
    }

    public Material maps(MaterialMap value) {
        com.raylib.jextract.Material.maps(this.memorySegment, value.memorySegment);
        return this;
    }

    public float[] getParams() {
        return com.raylib.jextract.Material.params(this.memorySegment).toArray(ValueLayout.JAVA_FLOAT);
    }

    public void setParams(float[] value) {
        com.raylib.jextract.Material.params(this.memorySegment, Arena.ofAuto().allocateFrom(ValueLayout.JAVA_FLOAT, value));
    }

    public float[] params() {
        return com.raylib.jextract.Material.params(this.memorySegment).toArray(ValueLayout.JAVA_FLOAT);
    }

    public Material params(float[] value) {
        com.raylib.jextract.Material.params(this.memorySegment, Arena.ofAuto().allocateFrom(ValueLayout.JAVA_FLOAT, value));
        return this;
    }
}

