/*
 * Decompiled with CFR 0.152.
 */
package com.raylib;

import com.raylib.BoneInfo;
import com.raylib.Material;
import com.raylib.Matrix;
import com.raylib.Mesh;
import com.raylib.Transform;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SegmentAllocator;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class Model {
    public final MemorySegment memorySegment;

    public Model() {
        this.memorySegment = com.raylib.jextract.Model.allocate(Arena.ofAuto());
    }

    public Model(SegmentAllocator arena) {
        this.memorySegment = com.raylib.jextract.Model.allocate(arena);
    }

    public Model(MemorySegment memorySegment) {
        this.memorySegment = memorySegment;
    }

    public Model(Matrix transform, int meshCount, int materialCount, Mesh meshes, Material materials, IntBuffer meshMaterial, int boneCount, BoneInfo bones, Transform bindPose) {
        this.memorySegment = com.raylib.jextract.Model.allocate(Arena.ofAuto());
        this.setTransform(transform);
        this.setMeshCount(meshCount);
        this.setMaterialCount(materialCount);
        this.setMeshes(meshes);
        this.setMaterials(materials);
        this.setMeshMaterial(meshMaterial);
        this.setBoneCount(boneCount);
        this.setBones(bones);
        this.setBindPose(bindPose);
    }

    public Model(SegmentAllocator arena, Matrix transform, int meshCount, int materialCount, Mesh meshes, Material materials, IntBuffer meshMaterial, int boneCount, BoneInfo bones, Transform bindPose) {
        this.memorySegment = com.raylib.jextract.Model.allocate(arena);
        this.setTransform(transform);
        this.setMeshCount(meshCount);
        this.setMaterialCount(materialCount);
        this.setMeshes(meshes);
        this.setMaterials(materials);
        this.setMeshMaterial(meshMaterial);
        this.setBoneCount(boneCount);
        this.setBones(bones);
        this.setBindPose(bindPose);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Model)) {
            return false;
        }
        Model other = (Model)o;
        return this.memorySegment.equals(other.memorySegment);
    }

    public int hashCode() {
        return this.memorySegment.hashCode();
    }

    public Model getArrayElement(int index) {
        return new Model(com.raylib.jextract.Model.asSlice(this.memorySegment, index));
    }

    public static Model allocateArray(long elementCount, SegmentAllocator allocator) {
        return new Model(com.raylib.jextract.Model.allocateArray(elementCount, allocator));
    }

    public static Model allocateArray(long elementCount) {
        return new Model(com.raylib.jextract.Model.allocateArray(elementCount, Arena.ofAuto()));
    }

    public Matrix getTransform() {
        return new Matrix(com.raylib.jextract.Model.transform(this.memorySegment));
    }

    public void setTransform(Matrix value) {
        com.raylib.jextract.Model.transform(this.memorySegment, value.memorySegment);
    }

    public Matrix transform() {
        return new Matrix(com.raylib.jextract.Model.transform(this.memorySegment));
    }

    public Model transform(Matrix value) {
        com.raylib.jextract.Model.transform(this.memorySegment, value.memorySegment);
        return this;
    }

    public int getMeshCount() {
        return com.raylib.jextract.Model.meshCount(this.memorySegment);
    }

    public void setMeshCount(int value) {
        com.raylib.jextract.Model.meshCount(this.memorySegment, value);
    }

    public int meshCount() {
        return com.raylib.jextract.Model.meshCount(this.memorySegment);
    }

    public Model meshCount(int value) {
        com.raylib.jextract.Model.meshCount(this.memorySegment, value);
        return this;
    }

    public int getMaterialCount() {
        return com.raylib.jextract.Model.materialCount(this.memorySegment);
    }

    public void setMaterialCount(int value) {
        com.raylib.jextract.Model.materialCount(this.memorySegment, value);
    }

    public int materialCount() {
        return com.raylib.jextract.Model.materialCount(this.memorySegment);
    }

    public Model materialCount(int value) {
        com.raylib.jextract.Model.materialCount(this.memorySegment, value);
        return this;
    }

    public Mesh getMeshes() {
        return new Mesh(com.raylib.jextract.Model.meshes(this.memorySegment));
    }

    public void setMeshes(Mesh value) {
        com.raylib.jextract.Model.meshes(this.memorySegment, value.memorySegment);
    }

    public Mesh meshes() {
        return new Mesh(com.raylib.jextract.Model.meshes(this.memorySegment));
    }

    public Model meshes(Mesh value) {
        com.raylib.jextract.Model.meshes(this.memorySegment, value.memorySegment);
        return this;
    }

    public Material getMaterials() {
        return new Material(com.raylib.jextract.Model.materials(this.memorySegment));
    }

    public void setMaterials(Material value) {
        com.raylib.jextract.Model.materials(this.memorySegment, value.memorySegment);
    }

    public Material materials() {
        return new Material(com.raylib.jextract.Model.materials(this.memorySegment));
    }

    public Model materials(Material value) {
        com.raylib.jextract.Model.materials(this.memorySegment, value.memorySegment);
        return this;
    }

    public IntBuffer getMeshMaterial() {
        return com.raylib.jextract.Model.meshMaterial(this.memorySegment).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public void setMeshMaterial(IntBuffer value) {
        com.raylib.jextract.Model.meshMaterial(this.memorySegment, MemorySegment.ofBuffer(value));
    }

    public IntBuffer meshMaterial() {
        return com.raylib.jextract.Model.meshMaterial(this.memorySegment).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public Model meshMaterial(IntBuffer value) {
        com.raylib.jextract.Model.meshMaterial(this.memorySegment, MemorySegment.ofBuffer(value));
        return this;
    }

    public int getBoneCount() {
        return com.raylib.jextract.Model.boneCount(this.memorySegment);
    }

    public void setBoneCount(int value) {
        com.raylib.jextract.Model.boneCount(this.memorySegment, value);
    }

    public int boneCount() {
        return com.raylib.jextract.Model.boneCount(this.memorySegment);
    }

    public Model boneCount(int value) {
        com.raylib.jextract.Model.boneCount(this.memorySegment, value);
        return this;
    }

    public BoneInfo getBones() {
        return new BoneInfo(com.raylib.jextract.Model.bones(this.memorySegment));
    }

    public void setBones(BoneInfo value) {
        com.raylib.jextract.Model.bones(this.memorySegment, value.memorySegment);
    }

    public BoneInfo bones() {
        return new BoneInfo(com.raylib.jextract.Model.bones(this.memorySegment));
    }

    public Model bones(BoneInfo value) {
        com.raylib.jextract.Model.bones(this.memorySegment, value.memorySegment);
        return this;
    }

    public Transform getBindPose() {
        return new Transform(com.raylib.jextract.Model.bindPose(this.memorySegment));
    }

    public void setBindPose(Transform value) {
        com.raylib.jextract.Model.bindPose(this.memorySegment, value.memorySegment);
    }

    public Transform bindPose() {
        return new Transform(com.raylib.jextract.Model.bindPose(this.memorySegment));
    }

    public Model bindPose(Transform value) {
        com.raylib.jextract.Model.bindPose(this.memorySegment, value.memorySegment);
        return this;
    }
}

