/*
 * Decompiled with CFR 0.152.
 */
package com.raylib;

import com.raylib.AudioStream;
import com.raylib.AutomationEvent;
import com.raylib.AutomationEventList;
import com.raylib.BoundingBox;
import com.raylib.Camera2D;
import com.raylib.Camera3D;
import com.raylib.Color;
import com.raylib.FilePathList;
import com.raylib.Font;
import com.raylib.GlyphInfo;
import com.raylib.Image;
import com.raylib.Material;
import com.raylib.Matrix;
import com.raylib.Mesh;
import com.raylib.Model;
import com.raylib.ModelAnimation;
import com.raylib.Music;
import com.raylib.NPatchInfo;
import com.raylib.Ray;
import com.raylib.RayCollision;
import com.raylib.Rectangle;
import com.raylib.RenderTexture;
import com.raylib.Shader;
import com.raylib.Sound;
import com.raylib.Texture;
import com.raylib.Vector2;
import com.raylib.Vector3;
import com.raylib.Vector4;
import com.raylib.VrDeviceInfo;
import com.raylib.VrStereoConfig;
import com.raylib.Wave;
import com.raylib.jextract.raylib_h;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class Raylib {
    public static Color LIGHTGRAY = Raylib.c(200, 200, 200, 255);
    public static Color GRAY = Raylib.c(130, 130, 130, 255);
    public static Color DARKGRAY = Raylib.c(80, 80, 80, 255);
    public static Color YELLOW = Raylib.c(253, 249, 0, 255);
    public static Color GOLD = Raylib.c(255, 203, 0, 255);
    public static Color ORANGE = Raylib.c(255, 161, 0, 255);
    public static Color PINK = Raylib.c(255, 109, 194, 255);
    public static Color RED = Raylib.c(230, 41, 55, 255);
    public static Color MAROON = Raylib.c(190, 33, 55, 255);
    public static Color GREEN = Raylib.c(0, 228, 48, 255);
    public static Color LIME = Raylib.c(0, 158, 47, 255);
    public static Color DARKGREEN = Raylib.c(0, 117, 44, 255);
    public static Color SKYBLUE = Raylib.c(102, 191, 255, 255);
    public static Color BLUE = Raylib.c(0, 121, 241, 255);
    public static Color DARKBLUE = Raylib.c(0, 82, 172, 255);
    public static Color PURPLE = Raylib.c(200, 122, 255, 255);
    public static Color VIOLET = Raylib.c(135, 60, 190, 255);
    public static Color DARKPURPLE = Raylib.c(112, 31, 126, 255);
    public static Color BEIGE = Raylib.c(211, 176, 131, 255);
    public static Color BROWN = Raylib.c(127, 106, 79, 255);
    public static Color DARKBROWN = Raylib.c(76, 63, 47, 255);
    public static Color WHITE = Raylib.c(255, 255, 255, 255);
    public static Color BLACK = Raylib.c(0, 0, 0, 255);
    public static Color BLANK = Raylib.c(0, 0, 0, 0);
    public static Color MAGENTA = Raylib.c(255, 0, 255, 255);
    public static Color RAYWHITE = Raylib.c(245, 245, 245, 255);

    public static IntBuffer createIntBuffer(int size) {
        return ByteBuffer.allocateDirect((int)ValueLayout.JAVA_INT.byteSize() * size).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public static FloatBuffer createFloatBuffer(int size) {
        return ByteBuffer.allocateDirect((int)ValueLayout.JAVA_FLOAT.byteSize() * size).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    public static ByteBuffer createByteBuffer(int size) {
        return ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
    }

    public static void initWindow(int width, int height, String title) {
        try (Arena localArena = Arena.ofConfined();){
            raylib_h.InitWindow(width, height, localArena.allocateFrom(title));
        }
    }

    public static void closeWindow() {
        raylib_h.CloseWindow();
    }

    public static boolean windowShouldClose() {
        return raylib_h.WindowShouldClose();
    }

    public static boolean isWindowReady() {
        return raylib_h.IsWindowReady();
    }

    public static boolean isWindowFullscreen() {
        return raylib_h.IsWindowFullscreen();
    }

    public static boolean isWindowHidden() {
        return raylib_h.IsWindowHidden();
    }

    public static boolean isWindowMinimized() {
        return raylib_h.IsWindowMinimized();
    }

    public static boolean isWindowMaximized() {
        return raylib_h.IsWindowMaximized();
    }

    public static boolean isWindowFocused() {
        return raylib_h.IsWindowFocused();
    }

    public static boolean isWindowResized() {
        return raylib_h.IsWindowResized();
    }

    public static boolean isWindowState(int flag) {
        return raylib_h.IsWindowState(flag);
    }

    public static void setWindowState(int flags) {
        raylib_h.SetWindowState(flags);
    }

    public static void clearWindowState(int flags) {
        raylib_h.ClearWindowState(flags);
    }

    public static void toggleFullscreen() {
        raylib_h.ToggleFullscreen();
    }

    public static void toggleBorderlessWindowed() {
        raylib_h.ToggleBorderlessWindowed();
    }

    public static void maximizeWindow() {
        raylib_h.MaximizeWindow();
    }

    public static void minimizeWindow() {
        raylib_h.MinimizeWindow();
    }

    public static void restoreWindow() {
        raylib_h.RestoreWindow();
    }

    public static void setWindowIcon(Image image) {
        raylib_h.SetWindowIcon(image.memorySegment);
    }

    public static void setWindowIcons(Image images, int count) {
        raylib_h.SetWindowIcons(images.memorySegment, count);
    }

    public static void setWindowTitle(String title) {
        try (Arena localArena = Arena.ofConfined();){
            raylib_h.SetWindowTitle(localArena.allocateFrom(title));
        }
    }

    public static void setWindowPosition(int x, int y) {
        raylib_h.SetWindowPosition(x, y);
    }

    public static void setWindowMonitor(int monitor) {
        raylib_h.SetWindowMonitor(monitor);
    }

    public static void setWindowMinSize(int width, int height) {
        raylib_h.SetWindowMinSize(width, height);
    }

    public static void setWindowMaxSize(int width, int height) {
        raylib_h.SetWindowMaxSize(width, height);
    }

    public static void setWindowSize(int width, int height) {
        raylib_h.SetWindowSize(width, height);
    }

    public static void setWindowOpacity(float opacity) {
        raylib_h.SetWindowOpacity(opacity);
    }

    public static void setWindowFocused() {
        raylib_h.SetWindowFocused();
    }

    public static MemorySegment getWindowHandle() {
        return raylib_h.GetWindowHandle();
    }

    public static int getScreenWidth() {
        return raylib_h.GetScreenWidth();
    }

    public static int getScreenHeight() {
        return raylib_h.GetScreenHeight();
    }

    public static int getRenderWidth() {
        return raylib_h.GetRenderWidth();
    }

    public static int getRenderHeight() {
        return raylib_h.GetRenderHeight();
    }

    public static int getMonitorCount() {
        return raylib_h.GetMonitorCount();
    }

    public static int getCurrentMonitor() {
        return raylib_h.GetCurrentMonitor();
    }

    public static Vector2 getMonitorPosition(int monitor) {
        return new Vector2(raylib_h.GetMonitorPosition(Arena.ofAuto(), monitor));
    }

    public static Vector2 getMonitorPosition(Arena arena, int monitor) {
        return new Vector2(raylib_h.GetMonitorPosition(arena, monitor));
    }

    public static int getMonitorWidth(int monitor) {
        return raylib_h.GetMonitorWidth(monitor);
    }

    public static int getMonitorHeight(int monitor) {
        return raylib_h.GetMonitorHeight(monitor);
    }

    public static int getMonitorPhysicalWidth(int monitor) {
        return raylib_h.GetMonitorPhysicalWidth(monitor);
    }

    public static int getMonitorPhysicalHeight(int monitor) {
        return raylib_h.GetMonitorPhysicalHeight(monitor);
    }

    public static int getMonitorRefreshRate(int monitor) {
        return raylib_h.GetMonitorRefreshRate(monitor);
    }

    public static Vector2 getWindowPosition() {
        return new Vector2(raylib_h.GetWindowPosition(Arena.ofAuto()));
    }

    public static Vector2 getWindowPosition(Arena arena) {
        return new Vector2(raylib_h.GetWindowPosition(arena));
    }

    public static Vector2 getWindowScaleDPI() {
        return new Vector2(raylib_h.GetWindowScaleDPI(Arena.ofAuto()));
    }

    public static Vector2 getWindowScaleDPI(Arena arena) {
        return new Vector2(raylib_h.GetWindowScaleDPI(arena));
    }

    public static String getMonitorName(int monitor) {
        return raylib_h.GetMonitorName(monitor).getString(0L);
    }

    public static void setClipboardText(String text) {
        try (Arena localArena = Arena.ofConfined();){
            raylib_h.SetClipboardText(localArena.allocateFrom(text));
        }
    }

    public static String getClipboardText() {
        return raylib_h.GetClipboardText().getString(0L);
    }

    public static Image getClipboardImage() {
        return new Image(raylib_h.GetClipboardImage(Arena.ofAuto()));
    }

    public static Image getClipboardImage(Arena arena) {
        return new Image(raylib_h.GetClipboardImage(arena));
    }

    public static void enableEventWaiting() {
        raylib_h.EnableEventWaiting();
    }

    public static void disableEventWaiting() {
        raylib_h.DisableEventWaiting();
    }

    public static void showCursor() {
        raylib_h.ShowCursor();
    }

    public static void hideCursor() {
        raylib_h.HideCursor();
    }

    public static boolean isCursorHidden() {
        return raylib_h.IsCursorHidden();
    }

    public static void enableCursor() {
        raylib_h.EnableCursor();
    }

    public static void disableCursor() {
        raylib_h.DisableCursor();
    }

    public static boolean isCursorOnScreen() {
        return raylib_h.IsCursorOnScreen();
    }

    public static void clearBackground(Color color) {
        raylib_h.ClearBackground(color.memorySegment);
    }

    public static void beginDrawing() {
        raylib_h.BeginDrawing();
    }

    public static void endDrawing() {
        raylib_h.EndDrawing();
    }

    public static void beginMode2D(Camera2D camera) {
        raylib_h.BeginMode2D(camera.memorySegment);
    }

    public static void endMode2D() {
        raylib_h.EndMode2D();
    }

    public static void beginMode3D(Camera3D camera) {
        raylib_h.BeginMode3D(camera.memorySegment);
    }

    public static void endMode3D() {
        raylib_h.EndMode3D();
    }

    public static void beginTextureMode(RenderTexture target) {
        raylib_h.BeginTextureMode(target.memorySegment);
    }

    public static void endTextureMode() {
        raylib_h.EndTextureMode();
    }

    public static void beginShaderMode(Shader shader) {
        raylib_h.BeginShaderMode(shader.memorySegment);
    }

    public static void endShaderMode() {
        raylib_h.EndShaderMode();
    }

    public static void beginBlendMode(int mode) {
        raylib_h.BeginBlendMode(mode);
    }

    public static void endBlendMode() {
        raylib_h.EndBlendMode();
    }

    public static void beginScissorMode(int x, int y, int width, int height) {
        raylib_h.BeginScissorMode(x, y, width, height);
    }

    public static void endScissorMode() {
        raylib_h.EndScissorMode();
    }

    public static void beginVrStereoMode(VrStereoConfig config) {
        raylib_h.BeginVrStereoMode(config.memorySegment);
    }

    public static void endVrStereoMode() {
        raylib_h.EndVrStereoMode();
    }

    public static VrStereoConfig loadVrStereoConfig(VrDeviceInfo device) {
        return new VrStereoConfig(raylib_h.LoadVrStereoConfig(Arena.ofAuto(), device.memorySegment));
    }

    public static VrStereoConfig loadVrStereoConfig(Arena arena, VrDeviceInfo device) {
        return new VrStereoConfig(raylib_h.LoadVrStereoConfig(arena, device.memorySegment));
    }

    public static void unloadVrStereoConfig(VrStereoConfig config) {
        raylib_h.UnloadVrStereoConfig(config.memorySegment);
    }

    public static Shader loadShader(String vsFileName, String fsFileName) {
        try (Arena localArena = Arena.ofConfined();){
            Shader shader = new Shader(raylib_h.LoadShader(Arena.ofAuto(), localArena.allocateFrom(vsFileName), localArena.allocateFrom(fsFileName)));
            return shader;
        }
    }

    public static Shader loadShader(Arena arena, String vsFileName, String fsFileName) {
        try (Arena localArena = Arena.ofConfined();){
            Shader shader = new Shader(raylib_h.LoadShader(arena, localArena.allocateFrom(vsFileName), localArena.allocateFrom(fsFileName)));
            return shader;
        }
    }

    public static Shader loadShaderFromMemory(String vsCode, String fsCode) {
        try (Arena localArena = Arena.ofConfined();){
            Shader shader = new Shader(raylib_h.LoadShaderFromMemory(Arena.ofAuto(), localArena.allocateFrom(vsCode), localArena.allocateFrom(fsCode)));
            return shader;
        }
    }

    public static Shader loadShaderFromMemory(Arena arena, String vsCode, String fsCode) {
        try (Arena localArena = Arena.ofConfined();){
            Shader shader = new Shader(raylib_h.LoadShaderFromMemory(arena, localArena.allocateFrom(vsCode), localArena.allocateFrom(fsCode)));
            return shader;
        }
    }

    public static boolean isShaderValid(Shader shader) {
        return raylib_h.IsShaderValid(shader.memorySegment);
    }

    public static int getShaderLocation(Shader shader, String uniformName) {
        try (Arena localArena = Arena.ofConfined();){
            int n = raylib_h.GetShaderLocation(shader.memorySegment, localArena.allocateFrom(uniformName));
            return n;
        }
    }

    public static int getShaderLocationAttrib(Shader shader, String attribName) {
        try (Arena localArena = Arena.ofConfined();){
            int n = raylib_h.GetShaderLocationAttrib(shader.memorySegment, localArena.allocateFrom(attribName));
            return n;
        }
    }

    public static void setShaderValue(Shader shader, int locIndex, MemorySegment value, int uniformType) {
        raylib_h.SetShaderValue(shader.memorySegment, locIndex, value, uniformType);
    }

    public static void setShaderValueV(Shader shader, int locIndex, MemorySegment value, int uniformType, int count) {
        raylib_h.SetShaderValueV(shader.memorySegment, locIndex, value, uniformType, count);
    }

    public static void setShaderValueMatrix(Shader shader, int locIndex, Matrix mat) {
        raylib_h.SetShaderValueMatrix(shader.memorySegment, locIndex, mat.memorySegment);
    }

    public static void setShaderValueTexture(Shader shader, int locIndex, Texture texture) {
        raylib_h.SetShaderValueTexture(shader.memorySegment, locIndex, texture.memorySegment);
    }

    public static void unloadShader(Shader shader) {
        raylib_h.UnloadShader(shader.memorySegment);
    }

    public static Ray getScreenToWorldRay(Vector2 position, Camera3D camera) {
        return new Ray(raylib_h.GetScreenToWorldRay(Arena.ofAuto(), position.memorySegment, camera.memorySegment));
    }

    public static Ray getScreenToWorldRay(Arena arena, Vector2 position, Camera3D camera) {
        return new Ray(raylib_h.GetScreenToWorldRay(arena, position.memorySegment, camera.memorySegment));
    }

    public static Ray getScreenToWorldRayEx(Vector2 position, Camera3D camera, int width, int height) {
        return new Ray(raylib_h.GetScreenToWorldRayEx(Arena.ofAuto(), position.memorySegment, camera.memorySegment, width, height));
    }

    public static Ray getScreenToWorldRayEx(Arena arena, Vector2 position, Camera3D camera, int width, int height) {
        return new Ray(raylib_h.GetScreenToWorldRayEx(arena, position.memorySegment, camera.memorySegment, width, height));
    }

    public static Vector2 getWorldToScreen(Vector3 position, Camera3D camera) {
        return new Vector2(raylib_h.GetWorldToScreen(Arena.ofAuto(), position.memorySegment, camera.memorySegment));
    }

    public static Vector2 getWorldToScreen(Arena arena, Vector3 position, Camera3D camera) {
        return new Vector2(raylib_h.GetWorldToScreen(arena, position.memorySegment, camera.memorySegment));
    }

    public static Vector2 getWorldToScreenEx(Vector3 position, Camera3D camera, int width, int height) {
        return new Vector2(raylib_h.GetWorldToScreenEx(Arena.ofAuto(), position.memorySegment, camera.memorySegment, width, height));
    }

    public static Vector2 getWorldToScreenEx(Arena arena, Vector3 position, Camera3D camera, int width, int height) {
        return new Vector2(raylib_h.GetWorldToScreenEx(arena, position.memorySegment, camera.memorySegment, width, height));
    }

    public static Vector2 getWorldToScreen2D(Vector2 position, Camera2D camera) {
        return new Vector2(raylib_h.GetWorldToScreen2D(Arena.ofAuto(), position.memorySegment, camera.memorySegment));
    }

    public static Vector2 getWorldToScreen2D(Arena arena, Vector2 position, Camera2D camera) {
        return new Vector2(raylib_h.GetWorldToScreen2D(arena, position.memorySegment, camera.memorySegment));
    }

    public static Vector2 getScreenToWorld2D(Vector2 position, Camera2D camera) {
        return new Vector2(raylib_h.GetScreenToWorld2D(Arena.ofAuto(), position.memorySegment, camera.memorySegment));
    }

    public static Vector2 getScreenToWorld2D(Arena arena, Vector2 position, Camera2D camera) {
        return new Vector2(raylib_h.GetScreenToWorld2D(arena, position.memorySegment, camera.memorySegment));
    }

    public static Matrix getCameraMatrix(Camera3D camera) {
        return new Matrix(raylib_h.GetCameraMatrix(Arena.ofAuto(), camera.memorySegment));
    }

    public static Matrix getCameraMatrix(Arena arena, Camera3D camera) {
        return new Matrix(raylib_h.GetCameraMatrix(arena, camera.memorySegment));
    }

    public static Matrix getCameraMatrix2D(Camera2D camera) {
        return new Matrix(raylib_h.GetCameraMatrix2D(Arena.ofAuto(), camera.memorySegment));
    }

    public static Matrix getCameraMatrix2D(Arena arena, Camera2D camera) {
        return new Matrix(raylib_h.GetCameraMatrix2D(arena, camera.memorySegment));
    }

    public static void setTargetFPS(int fps) {
        raylib_h.SetTargetFPS(fps);
    }

    public static float getFrameTime() {
        return raylib_h.GetFrameTime();
    }

    public static double getTime() {
        return raylib_h.GetTime();
    }

    public static int getFPS() {
        return raylib_h.GetFPS();
    }

    public static void swapScreenBuffer() {
        raylib_h.SwapScreenBuffer();
    }

    public static void pollInputEvents() {
        raylib_h.PollInputEvents();
    }

    public static void waitTime(double seconds) {
        raylib_h.WaitTime(seconds);
    }

    public static void setRandomSeed(int seed) {
        raylib_h.SetRandomSeed(seed);
    }

    public static int getRandomValue(int min, int max) {
        return raylib_h.GetRandomValue(min, max);
    }

    public static IntBuffer loadRandomSequence(int count, int min, int max) {
        return raylib_h.LoadRandomSequence(count, min, max).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    public static void unloadRandomSequence(IntBuffer sequence) {
        raylib_h.UnloadRandomSequence(MemorySegment.ofBuffer(sequence));
    }

    public static void takeScreenshot(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            raylib_h.TakeScreenshot(localArena.allocateFrom(fileName));
        }
    }

    public static void setConfigFlags(int flags) {
        raylib_h.SetConfigFlags(flags);
    }

    public static void openURL(String url) {
        try (Arena localArena = Arena.ofConfined();){
            raylib_h.OpenURL(localArena.allocateFrom(url));
        }
    }

    public static void setTraceLogLevel(int logLevel) {
        raylib_h.SetTraceLogLevel(logLevel);
    }

    public static MemorySegment memAlloc(int size) {
        return raylib_h.MemAlloc(size);
    }

    public static MemorySegment memRealloc(MemorySegment ptr, int size) {
        return raylib_h.MemRealloc(ptr, size);
    }

    public static void memFree(MemorySegment ptr) {
        raylib_h.MemFree(ptr);
    }

    public static void setTraceLogCallback(MemorySegment callback) {
        raylib_h.SetTraceLogCallback(callback);
    }

    public static void setLoadFileDataCallback(MemorySegment callback) {
        raylib_h.SetLoadFileDataCallback(callback);
    }

    public static void setSaveFileDataCallback(MemorySegment callback) {
        raylib_h.SetSaveFileDataCallback(callback);
    }

    public static void setLoadFileTextCallback(MemorySegment callback) {
        raylib_h.SetLoadFileTextCallback(callback);
    }

    public static void setSaveFileTextCallback(MemorySegment callback) {
        raylib_h.SetSaveFileTextCallback(callback);
    }

    public static ByteBuffer loadFileData(String fileName, IntBuffer dataSize) {
        try (Arena localArena = Arena.ofConfined();){
            ByteBuffer byteBuffer = raylib_h.LoadFileData(localArena.allocateFrom(fileName), MemorySegment.ofBuffer(dataSize)).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder());
            return byteBuffer;
        }
    }

    public static void unloadFileData(ByteBuffer data) {
        raylib_h.UnloadFileData(MemorySegment.ofBuffer(data));
    }

    public static boolean saveFileData(String fileName, MemorySegment data, int dataSize) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.SaveFileData(localArena.allocateFrom(fileName), data, dataSize);
            return bl;
        }
    }

    public static boolean exportDataAsCode(ByteBuffer data, int dataSize, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.ExportDataAsCode(MemorySegment.ofBuffer(data), dataSize, localArena.allocateFrom(fileName));
            return bl;
        }
    }

    public static ByteBuffer loadFileText(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            ByteBuffer byteBuffer = raylib_h.LoadFileText(localArena.allocateFrom(fileName)).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder());
            return byteBuffer;
        }
    }

    public static void unloadFileText(ByteBuffer text) {
        raylib_h.UnloadFileText(MemorySegment.ofBuffer(text));
    }

    public static boolean saveFileText(String fileName, ByteBuffer text) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.SaveFileText(localArena.allocateFrom(fileName), MemorySegment.ofBuffer(text));
            return bl;
        }
    }

    public static boolean fileExists(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.FileExists(localArena.allocateFrom(fileName));
            return bl;
        }
    }

    public static boolean directoryExists(String dirPath) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.DirectoryExists(localArena.allocateFrom(dirPath));
            return bl;
        }
    }

    public static boolean isFileExtension(String fileName, String ext) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.IsFileExtension(localArena.allocateFrom(fileName), localArena.allocateFrom(ext));
            return bl;
        }
    }

    public static int getFileLength(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            int n = raylib_h.GetFileLength(localArena.allocateFrom(fileName));
            return n;
        }
    }

    public static String getFileExtension(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            String string = raylib_h.GetFileExtension(localArena.allocateFrom(fileName)).getString(0L);
            return string;
        }
    }

    public static String getFileName(String filePath) {
        try (Arena localArena = Arena.ofConfined();){
            String string = raylib_h.GetFileName(localArena.allocateFrom(filePath)).getString(0L);
            return string;
        }
    }

    public static String getFileNameWithoutExt(String filePath) {
        try (Arena localArena = Arena.ofConfined();){
            String string = raylib_h.GetFileNameWithoutExt(localArena.allocateFrom(filePath)).getString(0L);
            return string;
        }
    }

    public static String getDirectoryPath(String filePath) {
        try (Arena localArena = Arena.ofConfined();){
            String string = raylib_h.GetDirectoryPath(localArena.allocateFrom(filePath)).getString(0L);
            return string;
        }
    }

    public static String getPrevDirectoryPath(String dirPath) {
        try (Arena localArena = Arena.ofConfined();){
            String string = raylib_h.GetPrevDirectoryPath(localArena.allocateFrom(dirPath)).getString(0L);
            return string;
        }
    }

    public static String getWorkingDirectory() {
        return raylib_h.GetWorkingDirectory().getString(0L);
    }

    public static String getApplicationDirectory() {
        return raylib_h.GetApplicationDirectory().getString(0L);
    }

    public static int makeDirectory(String dirPath) {
        try (Arena localArena = Arena.ofConfined();){
            int n = raylib_h.MakeDirectory(localArena.allocateFrom(dirPath));
            return n;
        }
    }

    public static boolean changeDirectory(String dir) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.ChangeDirectory(localArena.allocateFrom(dir));
            return bl;
        }
    }

    public static boolean isPathFile(String path) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.IsPathFile(localArena.allocateFrom(path));
            return bl;
        }
    }

    public static boolean isFileNameValid(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.IsFileNameValid(localArena.allocateFrom(fileName));
            return bl;
        }
    }

    public static FilePathList loadDirectoryFiles(String dirPath) {
        try (Arena localArena = Arena.ofConfined();){
            FilePathList filePathList = new FilePathList(raylib_h.LoadDirectoryFiles(Arena.ofAuto(), localArena.allocateFrom(dirPath)));
            return filePathList;
        }
    }

    public static FilePathList loadDirectoryFiles(Arena arena, String dirPath) {
        try (Arena localArena = Arena.ofConfined();){
            FilePathList filePathList = new FilePathList(raylib_h.LoadDirectoryFiles(arena, localArena.allocateFrom(dirPath)));
            return filePathList;
        }
    }

    public static FilePathList loadDirectoryFilesEx(String basePath, String filter, boolean scanSubdirs) {
        try (Arena localArena = Arena.ofConfined();){
            FilePathList filePathList = new FilePathList(raylib_h.LoadDirectoryFilesEx(Arena.ofAuto(), localArena.allocateFrom(basePath), localArena.allocateFrom(filter), scanSubdirs));
            return filePathList;
        }
    }

    public static FilePathList loadDirectoryFilesEx(Arena arena, String basePath, String filter, boolean scanSubdirs) {
        try (Arena localArena = Arena.ofConfined();){
            FilePathList filePathList = new FilePathList(raylib_h.LoadDirectoryFilesEx(arena, localArena.allocateFrom(basePath), localArena.allocateFrom(filter), scanSubdirs));
            return filePathList;
        }
    }

    public static void unloadDirectoryFiles(FilePathList files) {
        raylib_h.UnloadDirectoryFiles(files.memorySegment);
    }

    public static boolean isFileDropped() {
        return raylib_h.IsFileDropped();
    }

    public static FilePathList loadDroppedFiles() {
        return new FilePathList(raylib_h.LoadDroppedFiles(Arena.ofAuto()));
    }

    public static FilePathList loadDroppedFiles(Arena arena) {
        return new FilePathList(raylib_h.LoadDroppedFiles(arena));
    }

    public static void unloadDroppedFiles(FilePathList files) {
        raylib_h.UnloadDroppedFiles(files.memorySegment);
    }

    public static long getFileModTime(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            long l = raylib_h.GetFileModTime(localArena.allocateFrom(fileName));
            return l;
        }
    }

    public static ByteBuffer compressData(ByteBuffer data, int dataSize, IntBuffer compDataSize) {
        return raylib_h.CompressData(MemorySegment.ofBuffer(data), dataSize, MemorySegment.ofBuffer(compDataSize)).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer decompressData(ByteBuffer compData, int compDataSize, IntBuffer dataSize) {
        return raylib_h.DecompressData(MemorySegment.ofBuffer(compData), compDataSize, MemorySegment.ofBuffer(dataSize)).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer encodeDataBase64(ByteBuffer data, int dataSize, IntBuffer outputSize) {
        return raylib_h.EncodeDataBase64(MemorySegment.ofBuffer(data), dataSize, MemorySegment.ofBuffer(outputSize)).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer decodeDataBase64(ByteBuffer data, IntBuffer outputSize) {
        return raylib_h.DecodeDataBase64(MemorySegment.ofBuffer(data), MemorySegment.ofBuffer(outputSize)).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder());
    }

    public static int computeCRC32(ByteBuffer data, int dataSize) {
        return raylib_h.ComputeCRC32(MemorySegment.ofBuffer(data), dataSize);
    }

    public static MemorySegment computeMD5(ByteBuffer data, int dataSize) {
        return raylib_h.ComputeMD5(MemorySegment.ofBuffer(data), dataSize);
    }

    public static MemorySegment computeSHA1(ByteBuffer data, int dataSize) {
        return raylib_h.ComputeSHA1(MemorySegment.ofBuffer(data), dataSize);
    }

    public static AutomationEventList loadAutomationEventList(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            AutomationEventList automationEventList = new AutomationEventList(raylib_h.LoadAutomationEventList(Arena.ofAuto(), localArena.allocateFrom(fileName)));
            return automationEventList;
        }
    }

    public static AutomationEventList loadAutomationEventList(Arena arena, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            AutomationEventList automationEventList = new AutomationEventList(raylib_h.LoadAutomationEventList(arena, localArena.allocateFrom(fileName)));
            return automationEventList;
        }
    }

    public static void unloadAutomationEventList(AutomationEventList list) {
        raylib_h.UnloadAutomationEventList(list.memorySegment);
    }

    public static boolean exportAutomationEventList(AutomationEventList list, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.ExportAutomationEventList(list.memorySegment, localArena.allocateFrom(fileName));
            return bl;
        }
    }

    public static void setAutomationEventList(AutomationEventList list) {
        raylib_h.SetAutomationEventList(list.memorySegment);
    }

    public static void setAutomationEventBaseFrame(int frame) {
        raylib_h.SetAutomationEventBaseFrame(frame);
    }

    public static void startAutomationEventRecording() {
        raylib_h.StartAutomationEventRecording();
    }

    public static void stopAutomationEventRecording() {
        raylib_h.StopAutomationEventRecording();
    }

    public static void playAutomationEvent(AutomationEvent event) {
        raylib_h.PlayAutomationEvent(event.memorySegment);
    }

    public static boolean isKeyPressed(int key) {
        return raylib_h.IsKeyPressed(key);
    }

    public static boolean isKeyPressedRepeat(int key) {
        return raylib_h.IsKeyPressedRepeat(key);
    }

    public static boolean isKeyDown(int key) {
        return raylib_h.IsKeyDown(key);
    }

    public static boolean isKeyReleased(int key) {
        return raylib_h.IsKeyReleased(key);
    }

    public static boolean isKeyUp(int key) {
        return raylib_h.IsKeyUp(key);
    }

    public static int getKeyPressed() {
        return raylib_h.GetKeyPressed();
    }

    public static int getCharPressed() {
        return raylib_h.GetCharPressed();
    }

    public static void setExitKey(int key) {
        raylib_h.SetExitKey(key);
    }

    public static boolean isGamepadAvailable(int gamepad) {
        return raylib_h.IsGamepadAvailable(gamepad);
    }

    public static String getGamepadName(int gamepad) {
        return raylib_h.GetGamepadName(gamepad).getString(0L);
    }

    public static boolean isGamepadButtonPressed(int gamepad, int button) {
        return raylib_h.IsGamepadButtonPressed(gamepad, button);
    }

    public static boolean isGamepadButtonDown(int gamepad, int button) {
        return raylib_h.IsGamepadButtonDown(gamepad, button);
    }

    public static boolean isGamepadButtonReleased(int gamepad, int button) {
        return raylib_h.IsGamepadButtonReleased(gamepad, button);
    }

    public static boolean isGamepadButtonUp(int gamepad, int button) {
        return raylib_h.IsGamepadButtonUp(gamepad, button);
    }

    public static int getGamepadButtonPressed() {
        return raylib_h.GetGamepadButtonPressed();
    }

    public static int getGamepadAxisCount(int gamepad) {
        return raylib_h.GetGamepadAxisCount(gamepad);
    }

    public static float getGamepadAxisMovement(int gamepad, int axis) {
        return raylib_h.GetGamepadAxisMovement(gamepad, axis);
    }

    public static int setGamepadMappings(String mappings) {
        try (Arena localArena = Arena.ofConfined();){
            int n = raylib_h.SetGamepadMappings(localArena.allocateFrom(mappings));
            return n;
        }
    }

    public static void setGamepadVibration(int gamepad, float leftMotor, float rightMotor, float duration) {
        raylib_h.SetGamepadVibration(gamepad, leftMotor, rightMotor, duration);
    }

    public static boolean isMouseButtonPressed(int button) {
        return raylib_h.IsMouseButtonPressed(button);
    }

    public static boolean isMouseButtonDown(int button) {
        return raylib_h.IsMouseButtonDown(button);
    }

    public static boolean isMouseButtonReleased(int button) {
        return raylib_h.IsMouseButtonReleased(button);
    }

    public static boolean isMouseButtonUp(int button) {
        return raylib_h.IsMouseButtonUp(button);
    }

    public static int getMouseX() {
        return raylib_h.GetMouseX();
    }

    public static int getMouseY() {
        return raylib_h.GetMouseY();
    }

    public static Vector2 getMousePosition() {
        return new Vector2(raylib_h.GetMousePosition(Arena.ofAuto()));
    }

    public static Vector2 getMousePosition(Arena arena) {
        return new Vector2(raylib_h.GetMousePosition(arena));
    }

    public static Vector2 getMouseDelta() {
        return new Vector2(raylib_h.GetMouseDelta(Arena.ofAuto()));
    }

    public static Vector2 getMouseDelta(Arena arena) {
        return new Vector2(raylib_h.GetMouseDelta(arena));
    }

    public static void setMousePosition(int x, int y) {
        raylib_h.SetMousePosition(x, y);
    }

    public static void setMouseOffset(int offsetX, int offsetY) {
        raylib_h.SetMouseOffset(offsetX, offsetY);
    }

    public static void setMouseScale(float scaleX, float scaleY) {
        raylib_h.SetMouseScale(scaleX, scaleY);
    }

    public static float getMouseWheelMove() {
        return raylib_h.GetMouseWheelMove();
    }

    public static Vector2 getMouseWheelMoveV() {
        return new Vector2(raylib_h.GetMouseWheelMoveV(Arena.ofAuto()));
    }

    public static Vector2 getMouseWheelMoveV(Arena arena) {
        return new Vector2(raylib_h.GetMouseWheelMoveV(arena));
    }

    public static void setMouseCursor(int cursor) {
        raylib_h.SetMouseCursor(cursor);
    }

    public static int getTouchX() {
        return raylib_h.GetTouchX();
    }

    public static int getTouchY() {
        return raylib_h.GetTouchY();
    }

    public static Vector2 getTouchPosition(int index) {
        return new Vector2(raylib_h.GetTouchPosition(Arena.ofAuto(), index));
    }

    public static Vector2 getTouchPosition(Arena arena, int index) {
        return new Vector2(raylib_h.GetTouchPosition(arena, index));
    }

    public static int getTouchPointId(int index) {
        return raylib_h.GetTouchPointId(index);
    }

    public static int getTouchPointCount() {
        return raylib_h.GetTouchPointCount();
    }

    public static void setGesturesEnabled(int flags) {
        raylib_h.SetGesturesEnabled(flags);
    }

    public static boolean isGestureDetected(int gesture) {
        return raylib_h.IsGestureDetected(gesture);
    }

    public static int getGestureDetected() {
        return raylib_h.GetGestureDetected();
    }

    public static float getGestureHoldDuration() {
        return raylib_h.GetGestureHoldDuration();
    }

    public static Vector2 getGestureDragVector() {
        return new Vector2(raylib_h.GetGestureDragVector(Arena.ofAuto()));
    }

    public static Vector2 getGestureDragVector(Arena arena) {
        return new Vector2(raylib_h.GetGestureDragVector(arena));
    }

    public static float getGestureDragAngle() {
        return raylib_h.GetGestureDragAngle();
    }

    public static Vector2 getGesturePinchVector() {
        return new Vector2(raylib_h.GetGesturePinchVector(Arena.ofAuto()));
    }

    public static Vector2 getGesturePinchVector(Arena arena) {
        return new Vector2(raylib_h.GetGesturePinchVector(arena));
    }

    public static float getGesturePinchAngle() {
        return raylib_h.GetGesturePinchAngle();
    }

    public static void updateCamera(Camera3D camera, int mode) {
        raylib_h.UpdateCamera(camera.memorySegment, mode);
    }

    public static void updateCameraPro(Camera3D camera, Vector3 movement, Vector3 rotation, float zoom) {
        raylib_h.UpdateCameraPro(camera.memorySegment, movement.memorySegment, rotation.memorySegment, zoom);
    }

    public static void setShapesTexture(Texture texture, Rectangle source) {
        raylib_h.SetShapesTexture(texture.memorySegment, source.memorySegment);
    }

    public static Texture getShapesTexture() {
        return new Texture(raylib_h.GetShapesTexture(Arena.ofAuto()));
    }

    public static Texture getShapesTexture(Arena arena) {
        return new Texture(raylib_h.GetShapesTexture(arena));
    }

    public static Rectangle getShapesTextureRectangle() {
        return new Rectangle(raylib_h.GetShapesTextureRectangle(Arena.ofAuto()));
    }

    public static Rectangle getShapesTextureRectangle(Arena arena) {
        return new Rectangle(raylib_h.GetShapesTextureRectangle(arena));
    }

    public static void drawPixel(int posX, int posY, Color color) {
        raylib_h.DrawPixel(posX, posY, color.memorySegment);
    }

    public static void drawPixelV(Vector2 position, Color color) {
        raylib_h.DrawPixelV(position.memorySegment, color.memorySegment);
    }

    public static void drawLine(int startPosX, int startPosY, int endPosX, int endPosY, Color color) {
        raylib_h.DrawLine(startPosX, startPosY, endPosX, endPosY, color.memorySegment);
    }

    public static void drawLineV(Vector2 startPos, Vector2 endPos, Color color) {
        raylib_h.DrawLineV(startPos.memorySegment, endPos.memorySegment, color.memorySegment);
    }

    public static void drawLineEx(Vector2 startPos, Vector2 endPos, float thick, Color color) {
        raylib_h.DrawLineEx(startPos.memorySegment, endPos.memorySegment, thick, color.memorySegment);
    }

    public static void drawLineStrip(MemorySegment points, int pointCount, Color color) {
        raylib_h.DrawLineStrip(points, pointCount, color.memorySegment);
    }

    public static void drawLineBezier(Vector2 startPos, Vector2 endPos, float thick, Color color) {
        raylib_h.DrawLineBezier(startPos.memorySegment, endPos.memorySegment, thick, color.memorySegment);
    }

    public static void drawCircle(int centerX, int centerY, float radius, Color color) {
        raylib_h.DrawCircle(centerX, centerY, radius, color.memorySegment);
    }

    public static void drawCircleSector(Vector2 center, float radius, float startAngle, float endAngle, int segments, Color color) {
        raylib_h.DrawCircleSector(center.memorySegment, radius, startAngle, endAngle, segments, color.memorySegment);
    }

    public static void drawCircleSectorLines(Vector2 center, float radius, float startAngle, float endAngle, int segments, Color color) {
        raylib_h.DrawCircleSectorLines(center.memorySegment, radius, startAngle, endAngle, segments, color.memorySegment);
    }

    public static void drawCircleGradient(int centerX, int centerY, float radius, Color inner, Color outer) {
        raylib_h.DrawCircleGradient(centerX, centerY, radius, inner.memorySegment, outer.memorySegment);
    }

    public static void drawCircleV(Vector2 center, float radius, Color color) {
        raylib_h.DrawCircleV(center.memorySegment, radius, color.memorySegment);
    }

    public static void drawCircleLines(int centerX, int centerY, float radius, Color color) {
        raylib_h.DrawCircleLines(centerX, centerY, radius, color.memorySegment);
    }

    public static void drawCircleLinesV(Vector2 center, float radius, Color color) {
        raylib_h.DrawCircleLinesV(center.memorySegment, radius, color.memorySegment);
    }

    public static void drawEllipse(int centerX, int centerY, float radiusH, float radiusV, Color color) {
        raylib_h.DrawEllipse(centerX, centerY, radiusH, radiusV, color.memorySegment);
    }

    public static void drawEllipseLines(int centerX, int centerY, float radiusH, float radiusV, Color color) {
        raylib_h.DrawEllipseLines(centerX, centerY, radiusH, radiusV, color.memorySegment);
    }

    public static void drawRing(Vector2 center, float innerRadius, float outerRadius, float startAngle, float endAngle, int segments, Color color) {
        raylib_h.DrawRing(center.memorySegment, innerRadius, outerRadius, startAngle, endAngle, segments, color.memorySegment);
    }

    public static void drawRingLines(Vector2 center, float innerRadius, float outerRadius, float startAngle, float endAngle, int segments, Color color) {
        raylib_h.DrawRingLines(center.memorySegment, innerRadius, outerRadius, startAngle, endAngle, segments, color.memorySegment);
    }

    public static void drawRectangle(int posX, int posY, int width, int height, Color color) {
        raylib_h.DrawRectangle(posX, posY, width, height, color.memorySegment);
    }

    public static void drawRectangleV(Vector2 position, Vector2 size, Color color) {
        raylib_h.DrawRectangleV(position.memorySegment, size.memorySegment, color.memorySegment);
    }

    public static void drawRectangleRec(Rectangle rec, Color color) {
        raylib_h.DrawRectangleRec(rec.memorySegment, color.memorySegment);
    }

    public static void drawRectanglePro(Rectangle rec, Vector2 origin, float rotation, Color color) {
        raylib_h.DrawRectanglePro(rec.memorySegment, origin.memorySegment, rotation, color.memorySegment);
    }

    public static void drawRectangleGradientV(int posX, int posY, int width, int height, Color top, Color bottom) {
        raylib_h.DrawRectangleGradientV(posX, posY, width, height, top.memorySegment, bottom.memorySegment);
    }

    public static void drawRectangleGradientH(int posX, int posY, int width, int height, Color left, Color right) {
        raylib_h.DrawRectangleGradientH(posX, posY, width, height, left.memorySegment, right.memorySegment);
    }

    public static void drawRectangleGradientEx(Rectangle rec, Color topLeft, Color bottomLeft, Color topRight, Color bottomRight) {
        raylib_h.DrawRectangleGradientEx(rec.memorySegment, topLeft.memorySegment, bottomLeft.memorySegment, topRight.memorySegment, bottomRight.memorySegment);
    }

    public static void drawRectangleLines(int posX, int posY, int width, int height, Color color) {
        raylib_h.DrawRectangleLines(posX, posY, width, height, color.memorySegment);
    }

    public static void drawRectangleLinesEx(Rectangle rec, float lineThick, Color color) {
        raylib_h.DrawRectangleLinesEx(rec.memorySegment, lineThick, color.memorySegment);
    }

    public static void drawRectangleRounded(Rectangle rec, float roundness, int segments, Color color) {
        raylib_h.DrawRectangleRounded(rec.memorySegment, roundness, segments, color.memorySegment);
    }

    public static void drawRectangleRoundedLines(Rectangle rec, float roundness, int segments, Color color) {
        raylib_h.DrawRectangleRoundedLines(rec.memorySegment, roundness, segments, color.memorySegment);
    }

    public static void drawRectangleRoundedLinesEx(Rectangle rec, float roundness, int segments, float lineThick, Color color) {
        raylib_h.DrawRectangleRoundedLinesEx(rec.memorySegment, roundness, segments, lineThick, color.memorySegment);
    }

    public static void drawTriangle(Vector2 v1, Vector2 v2, Vector2 v3, Color color) {
        raylib_h.DrawTriangle(v1.memorySegment, v2.memorySegment, v3.memorySegment, color.memorySegment);
    }

    public static void drawTriangleLines(Vector2 v1, Vector2 v2, Vector2 v3, Color color) {
        raylib_h.DrawTriangleLines(v1.memorySegment, v2.memorySegment, v3.memorySegment, color.memorySegment);
    }

    public static void drawTriangleFan(MemorySegment points, int pointCount, Color color) {
        raylib_h.DrawTriangleFan(points, pointCount, color.memorySegment);
    }

    public static void drawTriangleStrip(MemorySegment points, int pointCount, Color color) {
        raylib_h.DrawTriangleStrip(points, pointCount, color.memorySegment);
    }

    public static void drawPoly(Vector2 center, int sides, float radius, float rotation, Color color) {
        raylib_h.DrawPoly(center.memorySegment, sides, radius, rotation, color.memorySegment);
    }

    public static void drawPolyLines(Vector2 center, int sides, float radius, float rotation, Color color) {
        raylib_h.DrawPolyLines(center.memorySegment, sides, radius, rotation, color.memorySegment);
    }

    public static void drawPolyLinesEx(Vector2 center, int sides, float radius, float rotation, float lineThick, Color color) {
        raylib_h.DrawPolyLinesEx(center.memorySegment, sides, radius, rotation, lineThick, color.memorySegment);
    }

    public static void drawSplineLinear(MemorySegment points, int pointCount, float thick, Color color) {
        raylib_h.DrawSplineLinear(points, pointCount, thick, color.memorySegment);
    }

    public static void drawSplineBasis(MemorySegment points, int pointCount, float thick, Color color) {
        raylib_h.DrawSplineBasis(points, pointCount, thick, color.memorySegment);
    }

    public static void drawSplineCatmullRom(MemorySegment points, int pointCount, float thick, Color color) {
        raylib_h.DrawSplineCatmullRom(points, pointCount, thick, color.memorySegment);
    }

    public static void drawSplineBezierQuadratic(MemorySegment points, int pointCount, float thick, Color color) {
        raylib_h.DrawSplineBezierQuadratic(points, pointCount, thick, color.memorySegment);
    }

    public static void drawSplineBezierCubic(MemorySegment points, int pointCount, float thick, Color color) {
        raylib_h.DrawSplineBezierCubic(points, pointCount, thick, color.memorySegment);
    }

    public static void drawSplineSegmentLinear(Vector2 p1, Vector2 p2, float thick, Color color) {
        raylib_h.DrawSplineSegmentLinear(p1.memorySegment, p2.memorySegment, thick, color.memorySegment);
    }

    public static void drawSplineSegmentBasis(Vector2 p1, Vector2 p2, Vector2 p3, Vector2 p4, float thick, Color color) {
        raylib_h.DrawSplineSegmentBasis(p1.memorySegment, p2.memorySegment, p3.memorySegment, p4.memorySegment, thick, color.memorySegment);
    }

    public static void drawSplineSegmentCatmullRom(Vector2 p1, Vector2 p2, Vector2 p3, Vector2 p4, float thick, Color color) {
        raylib_h.DrawSplineSegmentCatmullRom(p1.memorySegment, p2.memorySegment, p3.memorySegment, p4.memorySegment, thick, color.memorySegment);
    }

    public static void drawSplineSegmentBezierQuadratic(Vector2 p1, Vector2 c2, Vector2 p3, float thick, Color color) {
        raylib_h.DrawSplineSegmentBezierQuadratic(p1.memorySegment, c2.memorySegment, p3.memorySegment, thick, color.memorySegment);
    }

    public static void drawSplineSegmentBezierCubic(Vector2 p1, Vector2 c2, Vector2 c3, Vector2 p4, float thick, Color color) {
        raylib_h.DrawSplineSegmentBezierCubic(p1.memorySegment, c2.memorySegment, c3.memorySegment, p4.memorySegment, thick, color.memorySegment);
    }

    public static Vector2 getSplinePointLinear(Vector2 startPos, Vector2 endPos, float t) {
        return new Vector2(raylib_h.GetSplinePointLinear(Arena.ofAuto(), startPos.memorySegment, endPos.memorySegment, t));
    }

    public static Vector2 getSplinePointLinear(Arena arena, Vector2 startPos, Vector2 endPos, float t) {
        return new Vector2(raylib_h.GetSplinePointLinear(arena, startPos.memorySegment, endPos.memorySegment, t));
    }

    public static Vector2 getSplinePointBasis(Vector2 p1, Vector2 p2, Vector2 p3, Vector2 p4, float t) {
        return new Vector2(raylib_h.GetSplinePointBasis(Arena.ofAuto(), p1.memorySegment, p2.memorySegment, p3.memorySegment, p4.memorySegment, t));
    }

    public static Vector2 getSplinePointBasis(Arena arena, Vector2 p1, Vector2 p2, Vector2 p3, Vector2 p4, float t) {
        return new Vector2(raylib_h.GetSplinePointBasis(arena, p1.memorySegment, p2.memorySegment, p3.memorySegment, p4.memorySegment, t));
    }

    public static Vector2 getSplinePointCatmullRom(Vector2 p1, Vector2 p2, Vector2 p3, Vector2 p4, float t) {
        return new Vector2(raylib_h.GetSplinePointCatmullRom(Arena.ofAuto(), p1.memorySegment, p2.memorySegment, p3.memorySegment, p4.memorySegment, t));
    }

    public static Vector2 getSplinePointCatmullRom(Arena arena, Vector2 p1, Vector2 p2, Vector2 p3, Vector2 p4, float t) {
        return new Vector2(raylib_h.GetSplinePointCatmullRom(arena, p1.memorySegment, p2.memorySegment, p3.memorySegment, p4.memorySegment, t));
    }

    public static Vector2 getSplinePointBezierQuad(Vector2 p1, Vector2 c2, Vector2 p3, float t) {
        return new Vector2(raylib_h.GetSplinePointBezierQuad(Arena.ofAuto(), p1.memorySegment, c2.memorySegment, p3.memorySegment, t));
    }

    public static Vector2 getSplinePointBezierQuad(Arena arena, Vector2 p1, Vector2 c2, Vector2 p3, float t) {
        return new Vector2(raylib_h.GetSplinePointBezierQuad(arena, p1.memorySegment, c2.memorySegment, p3.memorySegment, t));
    }

    public static Vector2 getSplinePointBezierCubic(Vector2 p1, Vector2 c2, Vector2 c3, Vector2 p4, float t) {
        return new Vector2(raylib_h.GetSplinePointBezierCubic(Arena.ofAuto(), p1.memorySegment, c2.memorySegment, c3.memorySegment, p4.memorySegment, t));
    }

    public static Vector2 getSplinePointBezierCubic(Arena arena, Vector2 p1, Vector2 c2, Vector2 c3, Vector2 p4, float t) {
        return new Vector2(raylib_h.GetSplinePointBezierCubic(arena, p1.memorySegment, c2.memorySegment, c3.memorySegment, p4.memorySegment, t));
    }

    public static boolean checkCollisionRecs(Rectangle rec1, Rectangle rec2) {
        return raylib_h.CheckCollisionRecs(rec1.memorySegment, rec2.memorySegment);
    }

    public static boolean checkCollisionCircles(Vector2 center1, float radius1, Vector2 center2, float radius2) {
        return raylib_h.CheckCollisionCircles(center1.memorySegment, radius1, center2.memorySegment, radius2);
    }

    public static boolean checkCollisionCircleRec(Vector2 center, float radius, Rectangle rec) {
        return raylib_h.CheckCollisionCircleRec(center.memorySegment, radius, rec.memorySegment);
    }

    public static boolean checkCollisionCircleLine(Vector2 center, float radius, Vector2 p1, Vector2 p2) {
        return raylib_h.CheckCollisionCircleLine(center.memorySegment, radius, p1.memorySegment, p2.memorySegment);
    }

    public static boolean checkCollisionPointRec(Vector2 point, Rectangle rec) {
        return raylib_h.CheckCollisionPointRec(point.memorySegment, rec.memorySegment);
    }

    public static boolean checkCollisionPointCircle(Vector2 point, Vector2 center, float radius) {
        return raylib_h.CheckCollisionPointCircle(point.memorySegment, center.memorySegment, radius);
    }

    public static boolean checkCollisionPointTriangle(Vector2 point, Vector2 p1, Vector2 p2, Vector2 p3) {
        return raylib_h.CheckCollisionPointTriangle(point.memorySegment, p1.memorySegment, p2.memorySegment, p3.memorySegment);
    }

    public static boolean checkCollisionPointLine(Vector2 point, Vector2 p1, Vector2 p2, int threshold) {
        return raylib_h.CheckCollisionPointLine(point.memorySegment, p1.memorySegment, p2.memorySegment, threshold);
    }

    public static boolean checkCollisionPointPoly(Vector2 point, MemorySegment points, int pointCount) {
        return raylib_h.CheckCollisionPointPoly(point.memorySegment, points, pointCount);
    }

    public static boolean checkCollisionLines(Vector2 startPos1, Vector2 endPos1, Vector2 startPos2, Vector2 endPos2, Vector2 collisionPoint) {
        return raylib_h.CheckCollisionLines(startPos1.memorySegment, endPos1.memorySegment, startPos2.memorySegment, endPos2.memorySegment, collisionPoint.memorySegment);
    }

    public static Rectangle getCollisionRec(Rectangle rec1, Rectangle rec2) {
        return new Rectangle(raylib_h.GetCollisionRec(Arena.ofAuto(), rec1.memorySegment, rec2.memorySegment));
    }

    public static Rectangle getCollisionRec(Arena arena, Rectangle rec1, Rectangle rec2) {
        return new Rectangle(raylib_h.GetCollisionRec(arena, rec1.memorySegment, rec2.memorySegment));
    }

    public static Image loadImage(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.LoadImage(Arena.ofAuto(), localArena.allocateFrom(fileName)));
            return image;
        }
    }

    public static Image loadImage(Arena arena, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.LoadImage(arena, localArena.allocateFrom(fileName)));
            return image;
        }
    }

    public static Image loadImageRaw(String fileName, int width, int height, int format, int headerSize) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.LoadImageRaw(Arena.ofAuto(), localArena.allocateFrom(fileName), width, height, format, headerSize));
            return image;
        }
    }

    public static Image loadImageRaw(Arena arena, String fileName, int width, int height, int format, int headerSize) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.LoadImageRaw(arena, localArena.allocateFrom(fileName), width, height, format, headerSize));
            return image;
        }
    }

    public static Image loadImageAnim(String fileName, IntBuffer frames) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.LoadImageAnim(Arena.ofAuto(), localArena.allocateFrom(fileName), MemorySegment.ofBuffer(frames)));
            return image;
        }
    }

    public static Image loadImageAnim(Arena arena, String fileName, IntBuffer frames) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.LoadImageAnim(arena, localArena.allocateFrom(fileName), MemorySegment.ofBuffer(frames)));
            return image;
        }
    }

    public static Image loadImageAnimFromMemory(String fileType, ByteBuffer fileData, int dataSize, IntBuffer frames) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.LoadImageAnimFromMemory(Arena.ofAuto(), localArena.allocateFrom(fileType), MemorySegment.ofBuffer(fileData), dataSize, MemorySegment.ofBuffer(frames)));
            return image;
        }
    }

    public static Image loadImageAnimFromMemory(Arena arena, String fileType, ByteBuffer fileData, int dataSize, IntBuffer frames) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.LoadImageAnimFromMemory(arena, localArena.allocateFrom(fileType), MemorySegment.ofBuffer(fileData), dataSize, MemorySegment.ofBuffer(frames)));
            return image;
        }
    }

    public static Image loadImageFromMemory(String fileType, ByteBuffer fileData, int dataSize) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.LoadImageFromMemory(Arena.ofAuto(), localArena.allocateFrom(fileType), MemorySegment.ofBuffer(fileData), dataSize));
            return image;
        }
    }

    public static Image loadImageFromMemory(Arena arena, String fileType, ByteBuffer fileData, int dataSize) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.LoadImageFromMemory(arena, localArena.allocateFrom(fileType), MemorySegment.ofBuffer(fileData), dataSize));
            return image;
        }
    }

    public static Image loadImageFromTexture(Texture texture) {
        return new Image(raylib_h.LoadImageFromTexture(Arena.ofAuto(), texture.memorySegment));
    }

    public static Image loadImageFromTexture(Arena arena, Texture texture) {
        return new Image(raylib_h.LoadImageFromTexture(arena, texture.memorySegment));
    }

    public static Image loadImageFromScreen() {
        return new Image(raylib_h.LoadImageFromScreen(Arena.ofAuto()));
    }

    public static Image loadImageFromScreen(Arena arena) {
        return new Image(raylib_h.LoadImageFromScreen(arena));
    }

    public static boolean isImageValid(Image image) {
        return raylib_h.IsImageValid(image.memorySegment);
    }

    public static void unloadImage(Image image) {
        raylib_h.UnloadImage(image.memorySegment);
    }

    public static boolean exportImage(Image image, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.ExportImage(image.memorySegment, localArena.allocateFrom(fileName));
            return bl;
        }
    }

    public static ByteBuffer exportImageToMemory(Image image, String fileType, IntBuffer fileSize) {
        try (Arena localArena = Arena.ofConfined();){
            ByteBuffer byteBuffer = raylib_h.ExportImageToMemory(image.memorySegment, localArena.allocateFrom(fileType), MemorySegment.ofBuffer(fileSize)).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder());
            return byteBuffer;
        }
    }

    public static boolean exportImageAsCode(Image image, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.ExportImageAsCode(image.memorySegment, localArena.allocateFrom(fileName));
            return bl;
        }
    }

    public static Image genImageColor(int width, int height, Color color) {
        return new Image(raylib_h.GenImageColor(Arena.ofAuto(), width, height, color.memorySegment));
    }

    public static Image genImageColor(Arena arena, int width, int height, Color color) {
        return new Image(raylib_h.GenImageColor(arena, width, height, color.memorySegment));
    }

    public static Image genImageGradientLinear(int width, int height, int direction, Color start, Color end) {
        return new Image(raylib_h.GenImageGradientLinear(Arena.ofAuto(), width, height, direction, start.memorySegment, end.memorySegment));
    }

    public static Image genImageGradientLinear(Arena arena, int width, int height, int direction, Color start, Color end) {
        return new Image(raylib_h.GenImageGradientLinear(arena, width, height, direction, start.memorySegment, end.memorySegment));
    }

    public static Image genImageGradientRadial(int width, int height, float density, Color inner, Color outer) {
        return new Image(raylib_h.GenImageGradientRadial(Arena.ofAuto(), width, height, density, inner.memorySegment, outer.memorySegment));
    }

    public static Image genImageGradientRadial(Arena arena, int width, int height, float density, Color inner, Color outer) {
        return new Image(raylib_h.GenImageGradientRadial(arena, width, height, density, inner.memorySegment, outer.memorySegment));
    }

    public static Image genImageGradientSquare(int width, int height, float density, Color inner, Color outer) {
        return new Image(raylib_h.GenImageGradientSquare(Arena.ofAuto(), width, height, density, inner.memorySegment, outer.memorySegment));
    }

    public static Image genImageGradientSquare(Arena arena, int width, int height, float density, Color inner, Color outer) {
        return new Image(raylib_h.GenImageGradientSquare(arena, width, height, density, inner.memorySegment, outer.memorySegment));
    }

    public static Image genImageChecked(int width, int height, int checksX, int checksY, Color col1, Color col2) {
        return new Image(raylib_h.GenImageChecked(Arena.ofAuto(), width, height, checksX, checksY, col1.memorySegment, col2.memorySegment));
    }

    public static Image genImageChecked(Arena arena, int width, int height, int checksX, int checksY, Color col1, Color col2) {
        return new Image(raylib_h.GenImageChecked(arena, width, height, checksX, checksY, col1.memorySegment, col2.memorySegment));
    }

    public static Image genImageWhiteNoise(int width, int height, float factor) {
        return new Image(raylib_h.GenImageWhiteNoise(Arena.ofAuto(), width, height, factor));
    }

    public static Image genImageWhiteNoise(Arena arena, int width, int height, float factor) {
        return new Image(raylib_h.GenImageWhiteNoise(arena, width, height, factor));
    }

    public static Image genImagePerlinNoise(int width, int height, int offsetX, int offsetY, float scale) {
        return new Image(raylib_h.GenImagePerlinNoise(Arena.ofAuto(), width, height, offsetX, offsetY, scale));
    }

    public static Image genImagePerlinNoise(Arena arena, int width, int height, int offsetX, int offsetY, float scale) {
        return new Image(raylib_h.GenImagePerlinNoise(arena, width, height, offsetX, offsetY, scale));
    }

    public static Image genImageCellular(int width, int height, int tileSize) {
        return new Image(raylib_h.GenImageCellular(Arena.ofAuto(), width, height, tileSize));
    }

    public static Image genImageCellular(Arena arena, int width, int height, int tileSize) {
        return new Image(raylib_h.GenImageCellular(arena, width, height, tileSize));
    }

    public static Image genImageText(int width, int height, String text) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.GenImageText(Arena.ofAuto(), width, height, localArena.allocateFrom(text)));
            return image;
        }
    }

    public static Image genImageText(Arena arena, int width, int height, String text) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.GenImageText(arena, width, height, localArena.allocateFrom(text)));
            return image;
        }
    }

    public static Image imageCopy(Image image) {
        return new Image(raylib_h.ImageCopy(Arena.ofAuto(), image.memorySegment));
    }

    public static Image imageCopy(Arena arena, Image image) {
        return new Image(raylib_h.ImageCopy(arena, image.memorySegment));
    }

    public static Image imageFromImage(Image image, Rectangle rec) {
        return new Image(raylib_h.ImageFromImage(Arena.ofAuto(), image.memorySegment, rec.memorySegment));
    }

    public static Image imageFromImage(Arena arena, Image image, Rectangle rec) {
        return new Image(raylib_h.ImageFromImage(arena, image.memorySegment, rec.memorySegment));
    }

    public static Image imageFromChannel(Image image, int selectedChannel) {
        return new Image(raylib_h.ImageFromChannel(Arena.ofAuto(), image.memorySegment, selectedChannel));
    }

    public static Image imageFromChannel(Arena arena, Image image, int selectedChannel) {
        return new Image(raylib_h.ImageFromChannel(arena, image.memorySegment, selectedChannel));
    }

    public static Image imageText(String text, int fontSize, Color color) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.ImageText(Arena.ofAuto(), localArena.allocateFrom(text), fontSize, color.memorySegment));
            return image;
        }
    }

    public static Image imageText(Arena arena, String text, int fontSize, Color color) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.ImageText(arena, localArena.allocateFrom(text), fontSize, color.memorySegment));
            return image;
        }
    }

    public static Image imageTextEx(Font font, String text, float fontSize, float spacing, Color tint) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.ImageTextEx(Arena.ofAuto(), font.memorySegment, localArena.allocateFrom(text), fontSize, spacing, tint.memorySegment));
            return image;
        }
    }

    public static Image imageTextEx(Arena arena, Font font, String text, float fontSize, float spacing, Color tint) {
        try (Arena localArena = Arena.ofConfined();){
            Image image = new Image(raylib_h.ImageTextEx(arena, font.memorySegment, localArena.allocateFrom(text), fontSize, spacing, tint.memorySegment));
            return image;
        }
    }

    public static void imageFormat(Image image, int newFormat) {
        raylib_h.ImageFormat(image.memorySegment, newFormat);
    }

    public static void imageToPOT(Image image, Color fill) {
        raylib_h.ImageToPOT(image.memorySegment, fill.memorySegment);
    }

    public static void imageCrop(Image image, Rectangle crop) {
        raylib_h.ImageCrop(image.memorySegment, crop.memorySegment);
    }

    public static void imageAlphaCrop(Image image, float threshold) {
        raylib_h.ImageAlphaCrop(image.memorySegment, threshold);
    }

    public static void imageAlphaClear(Image image, Color color, float threshold) {
        raylib_h.ImageAlphaClear(image.memorySegment, color.memorySegment, threshold);
    }

    public static void imageAlphaMask(Image image, Image alphaMask) {
        raylib_h.ImageAlphaMask(image.memorySegment, alphaMask.memorySegment);
    }

    public static void imageAlphaPremultiply(Image image) {
        raylib_h.ImageAlphaPremultiply(image.memorySegment);
    }

    public static void imageBlurGaussian(Image image, int blurSize) {
        raylib_h.ImageBlurGaussian(image.memorySegment, blurSize);
    }

    public static void imageKernelConvolution(Image image, MemorySegment kernel, int kernelSize) {
        raylib_h.ImageKernelConvolution(image.memorySegment, kernel, kernelSize);
    }

    public static void imageResize(Image image, int newWidth, int newHeight) {
        raylib_h.ImageResize(image.memorySegment, newWidth, newHeight);
    }

    public static void imageResizeNN(Image image, int newWidth, int newHeight) {
        raylib_h.ImageResizeNN(image.memorySegment, newWidth, newHeight);
    }

    public static void imageResizeCanvas(Image image, int newWidth, int newHeight, int offsetX, int offsetY, Color fill) {
        raylib_h.ImageResizeCanvas(image.memorySegment, newWidth, newHeight, offsetX, offsetY, fill.memorySegment);
    }

    public static void imageMipmaps(Image image) {
        raylib_h.ImageMipmaps(image.memorySegment);
    }

    public static void imageDither(Image image, int rBpp, int gBpp, int bBpp, int aBpp) {
        raylib_h.ImageDither(image.memorySegment, rBpp, gBpp, bBpp, aBpp);
    }

    public static void imageFlipVertical(Image image) {
        raylib_h.ImageFlipVertical(image.memorySegment);
    }

    public static void imageFlipHorizontal(Image image) {
        raylib_h.ImageFlipHorizontal(image.memorySegment);
    }

    public static void imageRotate(Image image, int degrees) {
        raylib_h.ImageRotate(image.memorySegment, degrees);
    }

    public static void imageRotateCW(Image image) {
        raylib_h.ImageRotateCW(image.memorySegment);
    }

    public static void imageRotateCCW(Image image) {
        raylib_h.ImageRotateCCW(image.memorySegment);
    }

    public static void imageColorTint(Image image, Color color) {
        raylib_h.ImageColorTint(image.memorySegment, color.memorySegment);
    }

    public static void imageColorInvert(Image image) {
        raylib_h.ImageColorInvert(image.memorySegment);
    }

    public static void imageColorGrayscale(Image image) {
        raylib_h.ImageColorGrayscale(image.memorySegment);
    }

    public static void imageColorContrast(Image image, float contrast) {
        raylib_h.ImageColorContrast(image.memorySegment, contrast);
    }

    public static void imageColorBrightness(Image image, int brightness) {
        raylib_h.ImageColorBrightness(image.memorySegment, brightness);
    }

    public static void imageColorReplace(Image image, Color color, Color replace) {
        raylib_h.ImageColorReplace(image.memorySegment, color.memorySegment, replace.memorySegment);
    }

    public static Color loadImageColors(Image image) {
        return new Color(raylib_h.LoadImageColors(image.memorySegment));
    }

    public static Color loadImagePalette(Image image, int maxPaletteSize, IntBuffer colorCount) {
        return new Color(raylib_h.LoadImagePalette(image.memorySegment, maxPaletteSize, MemorySegment.ofBuffer(colorCount)));
    }

    public static void unloadImageColors(Color colors) {
        raylib_h.UnloadImageColors(colors.memorySegment);
    }

    public static void unloadImagePalette(Color colors) {
        raylib_h.UnloadImagePalette(colors.memorySegment);
    }

    public static Rectangle getImageAlphaBorder(Image image, float threshold) {
        return new Rectangle(raylib_h.GetImageAlphaBorder(Arena.ofAuto(), image.memorySegment, threshold));
    }

    public static Rectangle getImageAlphaBorder(Arena arena, Image image, float threshold) {
        return new Rectangle(raylib_h.GetImageAlphaBorder(arena, image.memorySegment, threshold));
    }

    public static Color getImageColor(Image image, int x, int y) {
        return new Color(raylib_h.GetImageColor(Arena.ofAuto(), image.memorySegment, x, y));
    }

    public static Color getImageColor(Arena arena, Image image, int x, int y) {
        return new Color(raylib_h.GetImageColor(arena, image.memorySegment, x, y));
    }

    public static void imageClearBackground(Image dst, Color color) {
        raylib_h.ImageClearBackground(dst.memorySegment, color.memorySegment);
    }

    public static void imageDrawPixel(Image dst, int posX, int posY, Color color) {
        raylib_h.ImageDrawPixel(dst.memorySegment, posX, posY, color.memorySegment);
    }

    public static void imageDrawPixelV(Image dst, Vector2 position, Color color) {
        raylib_h.ImageDrawPixelV(dst.memorySegment, position.memorySegment, color.memorySegment);
    }

    public static void imageDrawLine(Image dst, int startPosX, int startPosY, int endPosX, int endPosY, Color color) {
        raylib_h.ImageDrawLine(dst.memorySegment, startPosX, startPosY, endPosX, endPosY, color.memorySegment);
    }

    public static void imageDrawLineV(Image dst, Vector2 start, Vector2 end, Color color) {
        raylib_h.ImageDrawLineV(dst.memorySegment, start.memorySegment, end.memorySegment, color.memorySegment);
    }

    public static void imageDrawLineEx(Image dst, Vector2 start, Vector2 end, int thick, Color color) {
        raylib_h.ImageDrawLineEx(dst.memorySegment, start.memorySegment, end.memorySegment, thick, color.memorySegment);
    }

    public static void imageDrawCircle(Image dst, int centerX, int centerY, int radius, Color color) {
        raylib_h.ImageDrawCircle(dst.memorySegment, centerX, centerY, radius, color.memorySegment);
    }

    public static void imageDrawCircleV(Image dst, Vector2 center, int radius, Color color) {
        raylib_h.ImageDrawCircleV(dst.memorySegment, center.memorySegment, radius, color.memorySegment);
    }

    public static void imageDrawCircleLines(Image dst, int centerX, int centerY, int radius, Color color) {
        raylib_h.ImageDrawCircleLines(dst.memorySegment, centerX, centerY, radius, color.memorySegment);
    }

    public static void imageDrawCircleLinesV(Image dst, Vector2 center, int radius, Color color) {
        raylib_h.ImageDrawCircleLinesV(dst.memorySegment, center.memorySegment, radius, color.memorySegment);
    }

    public static void imageDrawRectangle(Image dst, int posX, int posY, int width, int height, Color color) {
        raylib_h.ImageDrawRectangle(dst.memorySegment, posX, posY, width, height, color.memorySegment);
    }

    public static void imageDrawRectangleV(Image dst, Vector2 position, Vector2 size, Color color) {
        raylib_h.ImageDrawRectangleV(dst.memorySegment, position.memorySegment, size.memorySegment, color.memorySegment);
    }

    public static void imageDrawRectangleRec(Image dst, Rectangle rec, Color color) {
        raylib_h.ImageDrawRectangleRec(dst.memorySegment, rec.memorySegment, color.memorySegment);
    }

    public static void imageDrawRectangleLines(Image dst, Rectangle rec, int thick, Color color) {
        raylib_h.ImageDrawRectangleLines(dst.memorySegment, rec.memorySegment, thick, color.memorySegment);
    }

    public static void imageDrawTriangle(Image dst, Vector2 v1, Vector2 v2, Vector2 v3, Color color) {
        raylib_h.ImageDrawTriangle(dst.memorySegment, v1.memorySegment, v2.memorySegment, v3.memorySegment, color.memorySegment);
    }

    public static void imageDrawTriangleEx(Image dst, Vector2 v1, Vector2 v2, Vector2 v3, Color c1, Color c2, Color c3) {
        raylib_h.ImageDrawTriangleEx(dst.memorySegment, v1.memorySegment, v2.memorySegment, v3.memorySegment, c1.memorySegment, c2.memorySegment, c3.memorySegment);
    }

    public static void imageDrawTriangleLines(Image dst, Vector2 v1, Vector2 v2, Vector2 v3, Color color) {
        raylib_h.ImageDrawTriangleLines(dst.memorySegment, v1.memorySegment, v2.memorySegment, v3.memorySegment, color.memorySegment);
    }

    public static void imageDrawTriangleFan(Image dst, Vector2 points, int pointCount, Color color) {
        raylib_h.ImageDrawTriangleFan(dst.memorySegment, points.memorySegment, pointCount, color.memorySegment);
    }

    public static void imageDrawTriangleStrip(Image dst, Vector2 points, int pointCount, Color color) {
        raylib_h.ImageDrawTriangleStrip(dst.memorySegment, points.memorySegment, pointCount, color.memorySegment);
    }

    public static void imageDraw(Image dst, Image src, Rectangle srcRec, Rectangle dstRec, Color tint) {
        raylib_h.ImageDraw(dst.memorySegment, src.memorySegment, srcRec.memorySegment, dstRec.memorySegment, tint.memorySegment);
    }

    public static void imageDrawText(Image dst, String text, int posX, int posY, int fontSize, Color color) {
        try (Arena localArena = Arena.ofConfined();){
            raylib_h.ImageDrawText(dst.memorySegment, localArena.allocateFrom(text), posX, posY, fontSize, color.memorySegment);
        }
    }

    public static void imageDrawTextEx(Image dst, Font font, String text, Vector2 position, float fontSize, float spacing, Color tint) {
        try (Arena localArena = Arena.ofConfined();){
            raylib_h.ImageDrawTextEx(dst.memorySegment, font.memorySegment, localArena.allocateFrom(text), position.memorySegment, fontSize, spacing, tint.memorySegment);
        }
    }

    public static Texture loadTexture(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            Texture texture = new Texture(raylib_h.LoadTexture(Arena.ofAuto(), localArena.allocateFrom(fileName)));
            return texture;
        }
    }

    public static Texture loadTexture(Arena arena, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            Texture texture = new Texture(raylib_h.LoadTexture(arena, localArena.allocateFrom(fileName)));
            return texture;
        }
    }

    public static Texture loadTextureFromImage(Image image) {
        return new Texture(raylib_h.LoadTextureFromImage(Arena.ofAuto(), image.memorySegment));
    }

    public static Texture loadTextureFromImage(Arena arena, Image image) {
        return new Texture(raylib_h.LoadTextureFromImage(arena, image.memorySegment));
    }

    public static Texture loadTextureCubemap(Image image, int layout) {
        return new Texture(raylib_h.LoadTextureCubemap(Arena.ofAuto(), image.memorySegment, layout));
    }

    public static Texture loadTextureCubemap(Arena arena, Image image, int layout) {
        return new Texture(raylib_h.LoadTextureCubemap(arena, image.memorySegment, layout));
    }

    public static RenderTexture loadRenderTexture(int width, int height) {
        return new RenderTexture(raylib_h.LoadRenderTexture(Arena.ofAuto(), width, height));
    }

    public static RenderTexture loadRenderTexture(Arena arena, int width, int height) {
        return new RenderTexture(raylib_h.LoadRenderTexture(arena, width, height));
    }

    public static boolean isTextureValid(Texture texture) {
        return raylib_h.IsTextureValid(texture.memorySegment);
    }

    public static void unloadTexture(Texture texture) {
        raylib_h.UnloadTexture(texture.memorySegment);
    }

    public static boolean isRenderTextureValid(RenderTexture target) {
        return raylib_h.IsRenderTextureValid(target.memorySegment);
    }

    public static void unloadRenderTexture(RenderTexture target) {
        raylib_h.UnloadRenderTexture(target.memorySegment);
    }

    public static void updateTexture(Texture texture, MemorySegment pixels) {
        raylib_h.UpdateTexture(texture.memorySegment, pixels);
    }

    public static void updateTextureRec(Texture texture, Rectangle rec, MemorySegment pixels) {
        raylib_h.UpdateTextureRec(texture.memorySegment, rec.memorySegment, pixels);
    }

    public static void genTextureMipmaps(Texture texture) {
        raylib_h.GenTextureMipmaps(texture.memorySegment);
    }

    public static void setTextureFilter(Texture texture, int filter) {
        raylib_h.SetTextureFilter(texture.memorySegment, filter);
    }

    public static void setTextureWrap(Texture texture, int wrap) {
        raylib_h.SetTextureWrap(texture.memorySegment, wrap);
    }

    public static void drawTexture(Texture texture, int posX, int posY, Color tint) {
        raylib_h.DrawTexture(texture.memorySegment, posX, posY, tint.memorySegment);
    }

    public static void drawTextureV(Texture texture, Vector2 position, Color tint) {
        raylib_h.DrawTextureV(texture.memorySegment, position.memorySegment, tint.memorySegment);
    }

    public static void drawTextureEx(Texture texture, Vector2 position, float rotation, float scale, Color tint) {
        raylib_h.DrawTextureEx(texture.memorySegment, position.memorySegment, rotation, scale, tint.memorySegment);
    }

    public static void drawTextureRec(Texture texture, Rectangle source, Vector2 position, Color tint) {
        raylib_h.DrawTextureRec(texture.memorySegment, source.memorySegment, position.memorySegment, tint.memorySegment);
    }

    public static void drawTexturePro(Texture texture, Rectangle source, Rectangle dest, Vector2 origin, float rotation, Color tint) {
        raylib_h.DrawTexturePro(texture.memorySegment, source.memorySegment, dest.memorySegment, origin.memorySegment, rotation, tint.memorySegment);
    }

    public static void drawTextureNPatch(Texture texture, NPatchInfo nPatchInfo, Rectangle dest, Vector2 origin, float rotation, Color tint) {
        raylib_h.DrawTextureNPatch(texture.memorySegment, nPatchInfo.memorySegment, dest.memorySegment, origin.memorySegment, rotation, tint.memorySegment);
    }

    public static boolean colorIsEqual(Color col1, Color col2) {
        return raylib_h.ColorIsEqual(col1.memorySegment, col2.memorySegment);
    }

    public static Color fade(Color color, float alpha) {
        return new Color(raylib_h.Fade(Arena.ofAuto(), color.memorySegment, alpha));
    }

    public static Color fade(Arena arena, Color color, float alpha) {
        return new Color(raylib_h.Fade(arena, color.memorySegment, alpha));
    }

    public static int colorToInt(Color color) {
        return raylib_h.ColorToInt(color.memorySegment);
    }

    public static Vector4 colorNormalize(Color color) {
        return new Vector4(raylib_h.ColorNormalize(Arena.ofAuto(), color.memorySegment));
    }

    public static Vector4 colorNormalize(Arena arena, Color color) {
        return new Vector4(raylib_h.ColorNormalize(arena, color.memorySegment));
    }

    public static Color colorFromNormalized(Vector4 normalized) {
        return new Color(raylib_h.ColorFromNormalized(Arena.ofAuto(), normalized.memorySegment));
    }

    public static Color colorFromNormalized(Arena arena, Vector4 normalized) {
        return new Color(raylib_h.ColorFromNormalized(arena, normalized.memorySegment));
    }

    public static Vector3 colorToHSV(Color color) {
        return new Vector3(raylib_h.ColorToHSV(Arena.ofAuto(), color.memorySegment));
    }

    public static Vector3 colorToHSV(Arena arena, Color color) {
        return new Vector3(raylib_h.ColorToHSV(arena, color.memorySegment));
    }

    public static Color colorFromHSV(float hue, float saturation, float value) {
        return new Color(raylib_h.ColorFromHSV(Arena.ofAuto(), hue, saturation, value));
    }

    public static Color colorFromHSV(Arena arena, float hue, float saturation, float value) {
        return new Color(raylib_h.ColorFromHSV(arena, hue, saturation, value));
    }

    public static Color colorTint(Color color, Color tint) {
        return new Color(raylib_h.ColorTint(Arena.ofAuto(), color.memorySegment, tint.memorySegment));
    }

    public static Color colorTint(Arena arena, Color color, Color tint) {
        return new Color(raylib_h.ColorTint(arena, color.memorySegment, tint.memorySegment));
    }

    public static Color colorBrightness(Color color, float factor) {
        return new Color(raylib_h.ColorBrightness(Arena.ofAuto(), color.memorySegment, factor));
    }

    public static Color colorBrightness(Arena arena, Color color, float factor) {
        return new Color(raylib_h.ColorBrightness(arena, color.memorySegment, factor));
    }

    public static Color colorContrast(Color color, float contrast) {
        return new Color(raylib_h.ColorContrast(Arena.ofAuto(), color.memorySegment, contrast));
    }

    public static Color colorContrast(Arena arena, Color color, float contrast) {
        return new Color(raylib_h.ColorContrast(arena, color.memorySegment, contrast));
    }

    public static Color colorAlpha(Color color, float alpha) {
        return new Color(raylib_h.ColorAlpha(Arena.ofAuto(), color.memorySegment, alpha));
    }

    public static Color colorAlpha(Arena arena, Color color, float alpha) {
        return new Color(raylib_h.ColorAlpha(arena, color.memorySegment, alpha));
    }

    public static Color colorAlphaBlend(Color dst, Color src, Color tint) {
        return new Color(raylib_h.ColorAlphaBlend(Arena.ofAuto(), dst.memorySegment, src.memorySegment, tint.memorySegment));
    }

    public static Color colorAlphaBlend(Arena arena, Color dst, Color src, Color tint) {
        return new Color(raylib_h.ColorAlphaBlend(arena, dst.memorySegment, src.memorySegment, tint.memorySegment));
    }

    public static Color colorLerp(Color color1, Color color2, float factor) {
        return new Color(raylib_h.ColorLerp(Arena.ofAuto(), color1.memorySegment, color2.memorySegment, factor));
    }

    public static Color colorLerp(Arena arena, Color color1, Color color2, float factor) {
        return new Color(raylib_h.ColorLerp(arena, color1.memorySegment, color2.memorySegment, factor));
    }

    public static Color getColor(int hexValue) {
        return new Color(raylib_h.GetColor(Arena.ofAuto(), hexValue));
    }

    public static Color getColor(Arena arena, int hexValue) {
        return new Color(raylib_h.GetColor(arena, hexValue));
    }

    public static Color getPixelColor(MemorySegment srcPtr, int format) {
        return new Color(raylib_h.GetPixelColor(Arena.ofAuto(), srcPtr, format));
    }

    public static Color getPixelColor(Arena arena, MemorySegment srcPtr, int format) {
        return new Color(raylib_h.GetPixelColor(arena, srcPtr, format));
    }

    public static void setPixelColor(MemorySegment dstPtr, Color color, int format) {
        raylib_h.SetPixelColor(dstPtr, color.memorySegment, format);
    }

    public static int getPixelDataSize(int width, int height, int format) {
        return raylib_h.GetPixelDataSize(width, height, format);
    }

    public static Font getFontDefault() {
        return new Font(raylib_h.GetFontDefault(Arena.ofAuto()));
    }

    public static Font getFontDefault(Arena arena) {
        return new Font(raylib_h.GetFontDefault(arena));
    }

    public static Font loadFont(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            Font font = new Font(raylib_h.LoadFont(Arena.ofAuto(), localArena.allocateFrom(fileName)));
            return font;
        }
    }

    public static Font loadFont(Arena arena, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            Font font = new Font(raylib_h.LoadFont(arena, localArena.allocateFrom(fileName)));
            return font;
        }
    }

    public static Font loadFontEx(String fileName, int fontSize, IntBuffer codepoints, int codepointCount) {
        try (Arena localArena = Arena.ofConfined();){
            Font font = new Font(raylib_h.LoadFontEx(Arena.ofAuto(), localArena.allocateFrom(fileName), fontSize, MemorySegment.ofBuffer(codepoints), codepointCount));
            return font;
        }
    }

    public static Font loadFontEx(Arena arena, String fileName, int fontSize, IntBuffer codepoints, int codepointCount) {
        try (Arena localArena = Arena.ofConfined();){
            Font font = new Font(raylib_h.LoadFontEx(arena, localArena.allocateFrom(fileName), fontSize, MemorySegment.ofBuffer(codepoints), codepointCount));
            return font;
        }
    }

    public static Font loadFontFromImage(Image image, Color key, int firstChar) {
        return new Font(raylib_h.LoadFontFromImage(Arena.ofAuto(), image.memorySegment, key.memorySegment, firstChar));
    }

    public static Font loadFontFromImage(Arena arena, Image image, Color key, int firstChar) {
        return new Font(raylib_h.LoadFontFromImage(arena, image.memorySegment, key.memorySegment, firstChar));
    }

    public static Font loadFontFromMemory(String fileType, ByteBuffer fileData, int dataSize, int fontSize, IntBuffer codepoints, int codepointCount) {
        try (Arena localArena = Arena.ofConfined();){
            Font font = new Font(raylib_h.LoadFontFromMemory(Arena.ofAuto(), localArena.allocateFrom(fileType), MemorySegment.ofBuffer(fileData), dataSize, fontSize, MemorySegment.ofBuffer(codepoints), codepointCount));
            return font;
        }
    }

    public static Font loadFontFromMemory(Arena arena, String fileType, ByteBuffer fileData, int dataSize, int fontSize, IntBuffer codepoints, int codepointCount) {
        try (Arena localArena = Arena.ofConfined();){
            Font font = new Font(raylib_h.LoadFontFromMemory(arena, localArena.allocateFrom(fileType), MemorySegment.ofBuffer(fileData), dataSize, fontSize, MemorySegment.ofBuffer(codepoints), codepointCount));
            return font;
        }
    }

    public static boolean isFontValid(Font font) {
        return raylib_h.IsFontValid(font.memorySegment);
    }

    public static GlyphInfo loadFontData(ByteBuffer fileData, int dataSize, int fontSize, IntBuffer codepoints, int codepointCount, int type) {
        return new GlyphInfo(raylib_h.LoadFontData(MemorySegment.ofBuffer(fileData), dataSize, fontSize, MemorySegment.ofBuffer(codepoints), codepointCount, type));
    }

    public static Image genImageFontAtlas(MemorySegment glyphs, MemorySegment glyphRecs, int glyphCount, int fontSize, int padding, int packMethod) {
        return new Image(raylib_h.GenImageFontAtlas(Arena.ofAuto(), glyphs, glyphRecs, glyphCount, fontSize, padding, packMethod));
    }

    public static Image genImageFontAtlas(Arena arena, MemorySegment glyphs, MemorySegment glyphRecs, int glyphCount, int fontSize, int padding, int packMethod) {
        return new Image(raylib_h.GenImageFontAtlas(arena, glyphs, glyphRecs, glyphCount, fontSize, padding, packMethod));
    }

    public static void unloadFontData(GlyphInfo glyphs, int glyphCount) {
        raylib_h.UnloadFontData(glyphs.memorySegment, glyphCount);
    }

    public static void unloadFont(Font font) {
        raylib_h.UnloadFont(font.memorySegment);
    }

    public static boolean exportFontAsCode(Font font, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.ExportFontAsCode(font.memorySegment, localArena.allocateFrom(fileName));
            return bl;
        }
    }

    public static void drawFPS(int posX, int posY) {
        raylib_h.DrawFPS(posX, posY);
    }

    public static void drawText(String text, int posX, int posY, int fontSize, Color color) {
        try (Arena localArena = Arena.ofConfined();){
            raylib_h.DrawText(localArena.allocateFrom(text), posX, posY, fontSize, color.memorySegment);
        }
    }

    public static void drawTextEx(Font font, String text, Vector2 position, float fontSize, float spacing, Color tint) {
        try (Arena localArena = Arena.ofConfined();){
            raylib_h.DrawTextEx(font.memorySegment, localArena.allocateFrom(text), position.memorySegment, fontSize, spacing, tint.memorySegment);
        }
    }

    public static void drawTextPro(Font font, String text, Vector2 position, Vector2 origin, float rotation, float fontSize, float spacing, Color tint) {
        try (Arena localArena = Arena.ofConfined();){
            raylib_h.DrawTextPro(font.memorySegment, localArena.allocateFrom(text), position.memorySegment, origin.memorySegment, rotation, fontSize, spacing, tint.memorySegment);
        }
    }

    public static void drawTextCodepoint(Font font, int codepoint, Vector2 position, float fontSize, Color tint) {
        raylib_h.DrawTextCodepoint(font.memorySegment, codepoint, position.memorySegment, fontSize, tint.memorySegment);
    }

    public static void drawTextCodepoints(Font font, MemorySegment codepoints, int codepointCount, Vector2 position, float fontSize, float spacing, Color tint) {
        raylib_h.DrawTextCodepoints(font.memorySegment, codepoints, codepointCount, position.memorySegment, fontSize, spacing, tint.memorySegment);
    }

    public static void setTextLineSpacing(int spacing) {
        raylib_h.SetTextLineSpacing(spacing);
    }

    public static int measureText(String text, int fontSize) {
        try (Arena localArena = Arena.ofConfined();){
            int n = raylib_h.MeasureText(localArena.allocateFrom(text), fontSize);
            return n;
        }
    }

    public static Vector2 measureTextEx(Font font, String text, float fontSize, float spacing) {
        try (Arena localArena = Arena.ofConfined();){
            Vector2 vector2 = new Vector2(raylib_h.MeasureTextEx(Arena.ofAuto(), font.memorySegment, localArena.allocateFrom(text), fontSize, spacing));
            return vector2;
        }
    }

    public static Vector2 measureTextEx(Arena arena, Font font, String text, float fontSize, float spacing) {
        try (Arena localArena = Arena.ofConfined();){
            Vector2 vector2 = new Vector2(raylib_h.MeasureTextEx(arena, font.memorySegment, localArena.allocateFrom(text), fontSize, spacing));
            return vector2;
        }
    }

    public static int getGlyphIndex(Font font, int codepoint) {
        return raylib_h.GetGlyphIndex(font.memorySegment, codepoint);
    }

    public static GlyphInfo getGlyphInfo(Font font, int codepoint) {
        return new GlyphInfo(raylib_h.GetGlyphInfo(Arena.ofAuto(), font.memorySegment, codepoint));
    }

    public static GlyphInfo getGlyphInfo(Arena arena, Font font, int codepoint) {
        return new GlyphInfo(raylib_h.GetGlyphInfo(arena, font.memorySegment, codepoint));
    }

    public static Rectangle getGlyphAtlasRec(Font font, int codepoint) {
        return new Rectangle(raylib_h.GetGlyphAtlasRec(Arena.ofAuto(), font.memorySegment, codepoint));
    }

    public static Rectangle getGlyphAtlasRec(Arena arena, Font font, int codepoint) {
        return new Rectangle(raylib_h.GetGlyphAtlasRec(arena, font.memorySegment, codepoint));
    }

    public static ByteBuffer loadUTF8(MemorySegment codepoints, int length) {
        return raylib_h.LoadUTF8(codepoints, length).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder());
    }

    public static void unloadUTF8(ByteBuffer text) {
        raylib_h.UnloadUTF8(MemorySegment.ofBuffer(text));
    }

    public static IntBuffer loadCodepoints(String text, IntBuffer count) {
        try (Arena localArena = Arena.ofConfined();){
            IntBuffer intBuffer = raylib_h.LoadCodepoints(localArena.allocateFrom(text), MemorySegment.ofBuffer(count)).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder()).asIntBuffer();
            return intBuffer;
        }
    }

    public static void unloadCodepoints(IntBuffer codepoints) {
        raylib_h.UnloadCodepoints(MemorySegment.ofBuffer(codepoints));
    }

    public static int getCodepointCount(String text) {
        try (Arena localArena = Arena.ofConfined();){
            int n = raylib_h.GetCodepointCount(localArena.allocateFrom(text));
            return n;
        }
    }

    public static int getCodepoint(String text, IntBuffer codepointSize) {
        try (Arena localArena = Arena.ofConfined();){
            int n = raylib_h.GetCodepoint(localArena.allocateFrom(text), MemorySegment.ofBuffer(codepointSize));
            return n;
        }
    }

    public static int getCodepointNext(String text, IntBuffer codepointSize) {
        try (Arena localArena = Arena.ofConfined();){
            int n = raylib_h.GetCodepointNext(localArena.allocateFrom(text), MemorySegment.ofBuffer(codepointSize));
            return n;
        }
    }

    public static int getCodepointPrevious(String text, IntBuffer codepointSize) {
        try (Arena localArena = Arena.ofConfined();){
            int n = raylib_h.GetCodepointPrevious(localArena.allocateFrom(text), MemorySegment.ofBuffer(codepointSize));
            return n;
        }
    }

    public static String codepointToUTF8(int codepoint, IntBuffer utf8Size) {
        return raylib_h.CodepointToUTF8(codepoint, MemorySegment.ofBuffer(utf8Size)).getString(0L);
    }

    public static int textCopy(ByteBuffer dst, String src) {
        try (Arena localArena = Arena.ofConfined();){
            int n = raylib_h.TextCopy(MemorySegment.ofBuffer(dst), localArena.allocateFrom(src));
            return n;
        }
    }

    public static boolean textIsEqual(String text1, String text2) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.TextIsEqual(localArena.allocateFrom(text1), localArena.allocateFrom(text2));
            return bl;
        }
    }

    public static int textLength(String text) {
        try (Arena localArena = Arena.ofConfined();){
            int n = raylib_h.TextLength(localArena.allocateFrom(text));
            return n;
        }
    }

    public static String textSubtext(String text, int position, int length) {
        try (Arena localArena = Arena.ofConfined();){
            String string = raylib_h.TextSubtext(localArena.allocateFrom(text), position, length).getString(0L);
            return string;
        }
    }

    public static ByteBuffer textReplace(String text, String replace, String by) {
        try (Arena localArena = Arena.ofConfined();){
            ByteBuffer byteBuffer = raylib_h.TextReplace(localArena.allocateFrom(text), localArena.allocateFrom(replace), localArena.allocateFrom(by)).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder());
            return byteBuffer;
        }
    }

    public static ByteBuffer textInsert(String text, String insert, int position) {
        try (Arena localArena = Arena.ofConfined();){
            ByteBuffer byteBuffer = raylib_h.TextInsert(localArena.allocateFrom(text), localArena.allocateFrom(insert), position).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder());
            return byteBuffer;
        }
    }

    public static String textJoin(MemorySegment textList, int count, String delimiter) {
        try (Arena localArena = Arena.ofConfined();){
            String string = raylib_h.TextJoin(textList, count, localArena.allocateFrom(delimiter)).getString(0L);
            return string;
        }
    }

    public static MemorySegment textSplit(String text, byte delimiter, IntBuffer count) {
        try (Arena localArena = Arena.ofConfined();){
            MemorySegment memorySegment = raylib_h.TextSplit(localArena.allocateFrom(text), delimiter, MemorySegment.ofBuffer(count));
            return memorySegment;
        }
    }

    public static void textAppend(ByteBuffer text, String append, IntBuffer position) {
        try (Arena localArena = Arena.ofConfined();){
            raylib_h.TextAppend(MemorySegment.ofBuffer(text), localArena.allocateFrom(append), MemorySegment.ofBuffer(position));
        }
    }

    public static int textFindIndex(String text, String find) {
        try (Arena localArena = Arena.ofConfined();){
            int n = raylib_h.TextFindIndex(localArena.allocateFrom(text), localArena.allocateFrom(find));
            return n;
        }
    }

    public static String textToUpper(String text) {
        try (Arena localArena = Arena.ofConfined();){
            String string = raylib_h.TextToUpper(localArena.allocateFrom(text)).getString(0L);
            return string;
        }
    }

    public static String textToLower(String text) {
        try (Arena localArena = Arena.ofConfined();){
            String string = raylib_h.TextToLower(localArena.allocateFrom(text)).getString(0L);
            return string;
        }
    }

    public static String textToPascal(String text) {
        try (Arena localArena = Arena.ofConfined();){
            String string = raylib_h.TextToPascal(localArena.allocateFrom(text)).getString(0L);
            return string;
        }
    }

    public static String textToSnake(String text) {
        try (Arena localArena = Arena.ofConfined();){
            String string = raylib_h.TextToSnake(localArena.allocateFrom(text)).getString(0L);
            return string;
        }
    }

    public static String textToCamel(String text) {
        try (Arena localArena = Arena.ofConfined();){
            String string = raylib_h.TextToCamel(localArena.allocateFrom(text)).getString(0L);
            return string;
        }
    }

    public static int textToInteger(String text) {
        try (Arena localArena = Arena.ofConfined();){
            int n = raylib_h.TextToInteger(localArena.allocateFrom(text));
            return n;
        }
    }

    public static float textToFloat(String text) {
        try (Arena localArena = Arena.ofConfined();){
            float f = raylib_h.TextToFloat(localArena.allocateFrom(text));
            return f;
        }
    }

    public static void drawLine3D(Vector3 startPos, Vector3 endPos, Color color) {
        raylib_h.DrawLine3D(startPos.memorySegment, endPos.memorySegment, color.memorySegment);
    }

    public static void drawPoint3D(Vector3 position, Color color) {
        raylib_h.DrawPoint3D(position.memorySegment, color.memorySegment);
    }

    public static void drawCircle3D(Vector3 center, float radius, Vector3 rotationAxis, float rotationAngle, Color color) {
        raylib_h.DrawCircle3D(center.memorySegment, radius, rotationAxis.memorySegment, rotationAngle, color.memorySegment);
    }

    public static void drawTriangle3D(Vector3 v1, Vector3 v2, Vector3 v3, Color color) {
        raylib_h.DrawTriangle3D(v1.memorySegment, v2.memorySegment, v3.memorySegment, color.memorySegment);
    }

    public static void drawTriangleStrip3D(MemorySegment points, int pointCount, Color color) {
        raylib_h.DrawTriangleStrip3D(points, pointCount, color.memorySegment);
    }

    public static void drawCube(Vector3 position, float width, float height, float length, Color color) {
        raylib_h.DrawCube(position.memorySegment, width, height, length, color.memorySegment);
    }

    public static void drawCubeV(Vector3 position, Vector3 size, Color color) {
        raylib_h.DrawCubeV(position.memorySegment, size.memorySegment, color.memorySegment);
    }

    public static void drawCubeWires(Vector3 position, float width, float height, float length, Color color) {
        raylib_h.DrawCubeWires(position.memorySegment, width, height, length, color.memorySegment);
    }

    public static void drawCubeWiresV(Vector3 position, Vector3 size, Color color) {
        raylib_h.DrawCubeWiresV(position.memorySegment, size.memorySegment, color.memorySegment);
    }

    public static void drawSphere(Vector3 centerPos, float radius, Color color) {
        raylib_h.DrawSphere(centerPos.memorySegment, radius, color.memorySegment);
    }

    public static void drawSphereEx(Vector3 centerPos, float radius, int rings, int slices, Color color) {
        raylib_h.DrawSphereEx(centerPos.memorySegment, radius, rings, slices, color.memorySegment);
    }

    public static void drawSphereWires(Vector3 centerPos, float radius, int rings, int slices, Color color) {
        raylib_h.DrawSphereWires(centerPos.memorySegment, radius, rings, slices, color.memorySegment);
    }

    public static void drawCylinder(Vector3 position, float radiusTop, float radiusBottom, float height, int slices, Color color) {
        raylib_h.DrawCylinder(position.memorySegment, radiusTop, radiusBottom, height, slices, color.memorySegment);
    }

    public static void drawCylinderEx(Vector3 startPos, Vector3 endPos, float startRadius, float endRadius, int sides, Color color) {
        raylib_h.DrawCylinderEx(startPos.memorySegment, endPos.memorySegment, startRadius, endRadius, sides, color.memorySegment);
    }

    public static void drawCylinderWires(Vector3 position, float radiusTop, float radiusBottom, float height, int slices, Color color) {
        raylib_h.DrawCylinderWires(position.memorySegment, radiusTop, radiusBottom, height, slices, color.memorySegment);
    }

    public static void drawCylinderWiresEx(Vector3 startPos, Vector3 endPos, float startRadius, float endRadius, int sides, Color color) {
        raylib_h.DrawCylinderWiresEx(startPos.memorySegment, endPos.memorySegment, startRadius, endRadius, sides, color.memorySegment);
    }

    public static void drawCapsule(Vector3 startPos, Vector3 endPos, float radius, int slices, int rings, Color color) {
        raylib_h.DrawCapsule(startPos.memorySegment, endPos.memorySegment, radius, slices, rings, color.memorySegment);
    }

    public static void drawCapsuleWires(Vector3 startPos, Vector3 endPos, float radius, int slices, int rings, Color color) {
        raylib_h.DrawCapsuleWires(startPos.memorySegment, endPos.memorySegment, radius, slices, rings, color.memorySegment);
    }

    public static void drawPlane(Vector3 centerPos, Vector2 size, Color color) {
        raylib_h.DrawPlane(centerPos.memorySegment, size.memorySegment, color.memorySegment);
    }

    public static void drawRay(Ray ray, Color color) {
        raylib_h.DrawRay(ray.memorySegment, color.memorySegment);
    }

    public static void drawGrid(int slices, float spacing) {
        raylib_h.DrawGrid(slices, spacing);
    }

    public static Model loadModel(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            Model model = new Model(raylib_h.LoadModel(Arena.ofAuto(), localArena.allocateFrom(fileName)));
            return model;
        }
    }

    public static Model loadModel(Arena arena, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            Model model = new Model(raylib_h.LoadModel(arena, localArena.allocateFrom(fileName)));
            return model;
        }
    }

    public static Model loadModelFromMesh(Mesh mesh) {
        return new Model(raylib_h.LoadModelFromMesh(Arena.ofAuto(), mesh.memorySegment));
    }

    public static Model loadModelFromMesh(Arena arena, Mesh mesh) {
        return new Model(raylib_h.LoadModelFromMesh(arena, mesh.memorySegment));
    }

    public static boolean isModelValid(Model model) {
        return raylib_h.IsModelValid(model.memorySegment);
    }

    public static void unloadModel(Model model) {
        raylib_h.UnloadModel(model.memorySegment);
    }

    public static BoundingBox getModelBoundingBox(Model model) {
        return new BoundingBox(raylib_h.GetModelBoundingBox(Arena.ofAuto(), model.memorySegment));
    }

    public static BoundingBox getModelBoundingBox(Arena arena, Model model) {
        return new BoundingBox(raylib_h.GetModelBoundingBox(arena, model.memorySegment));
    }

    public static void drawModel(Model model, Vector3 position, float scale, Color tint) {
        raylib_h.DrawModel(model.memorySegment, position.memorySegment, scale, tint.memorySegment);
    }

    public static void drawModelEx(Model model, Vector3 position, Vector3 rotationAxis, float rotationAngle, Vector3 scale, Color tint) {
        raylib_h.DrawModelEx(model.memorySegment, position.memorySegment, rotationAxis.memorySegment, rotationAngle, scale.memorySegment, tint.memorySegment);
    }

    public static void drawModelWires(Model model, Vector3 position, float scale, Color tint) {
        raylib_h.DrawModelWires(model.memorySegment, position.memorySegment, scale, tint.memorySegment);
    }

    public static void drawModelWiresEx(Model model, Vector3 position, Vector3 rotationAxis, float rotationAngle, Vector3 scale, Color tint) {
        raylib_h.DrawModelWiresEx(model.memorySegment, position.memorySegment, rotationAxis.memorySegment, rotationAngle, scale.memorySegment, tint.memorySegment);
    }

    public static void drawModelPoints(Model model, Vector3 position, float scale, Color tint) {
        raylib_h.DrawModelPoints(model.memorySegment, position.memorySegment, scale, tint.memorySegment);
    }

    public static void drawModelPointsEx(Model model, Vector3 position, Vector3 rotationAxis, float rotationAngle, Vector3 scale, Color tint) {
        raylib_h.DrawModelPointsEx(model.memorySegment, position.memorySegment, rotationAxis.memorySegment, rotationAngle, scale.memorySegment, tint.memorySegment);
    }

    public static void drawBoundingBox(BoundingBox box, Color color) {
        raylib_h.DrawBoundingBox(box.memorySegment, color.memorySegment);
    }

    public static void drawBillboard(Camera3D camera, Texture texture, Vector3 position, float scale, Color tint) {
        raylib_h.DrawBillboard(camera.memorySegment, texture.memorySegment, position.memorySegment, scale, tint.memorySegment);
    }

    public static void drawBillboardRec(Camera3D camera, Texture texture, Rectangle source, Vector3 position, Vector2 size, Color tint) {
        raylib_h.DrawBillboardRec(camera.memorySegment, texture.memorySegment, source.memorySegment, position.memorySegment, size.memorySegment, tint.memorySegment);
    }

    public static void drawBillboardPro(Camera3D camera, Texture texture, Rectangle source, Vector3 position, Vector3 up, Vector2 size, Vector2 origin, float rotation, Color tint) {
        raylib_h.DrawBillboardPro(camera.memorySegment, texture.memorySegment, source.memorySegment, position.memorySegment, up.memorySegment, size.memorySegment, origin.memorySegment, rotation, tint.memorySegment);
    }

    public static void uploadMesh(Mesh mesh, boolean dynamic) {
        raylib_h.UploadMesh(mesh.memorySegment, dynamic);
    }

    public static void updateMeshBuffer(Mesh mesh, int index, MemorySegment data, int dataSize, int offset) {
        raylib_h.UpdateMeshBuffer(mesh.memorySegment, index, data, dataSize, offset);
    }

    public static void unloadMesh(Mesh mesh) {
        raylib_h.UnloadMesh(mesh.memorySegment);
    }

    public static void drawMesh(Mesh mesh, Material material, Matrix transform) {
        raylib_h.DrawMesh(mesh.memorySegment, material.memorySegment, transform.memorySegment);
    }

    public static void drawMeshInstanced(Mesh mesh, Material material, MemorySegment transforms, int instances) {
        raylib_h.DrawMeshInstanced(mesh.memorySegment, material.memorySegment, transforms, instances);
    }

    public static BoundingBox getMeshBoundingBox(Mesh mesh) {
        return new BoundingBox(raylib_h.GetMeshBoundingBox(Arena.ofAuto(), mesh.memorySegment));
    }

    public static BoundingBox getMeshBoundingBox(Arena arena, Mesh mesh) {
        return new BoundingBox(raylib_h.GetMeshBoundingBox(arena, mesh.memorySegment));
    }

    public static void genMeshTangents(Mesh mesh) {
        raylib_h.GenMeshTangents(mesh.memorySegment);
    }

    public static boolean exportMesh(Mesh mesh, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.ExportMesh(mesh.memorySegment, localArena.allocateFrom(fileName));
            return bl;
        }
    }

    public static boolean exportMeshAsCode(Mesh mesh, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.ExportMeshAsCode(mesh.memorySegment, localArena.allocateFrom(fileName));
            return bl;
        }
    }

    public static Mesh genMeshPoly(int sides, float radius) {
        return new Mesh(raylib_h.GenMeshPoly(Arena.ofAuto(), sides, radius));
    }

    public static Mesh genMeshPoly(Arena arena, int sides, float radius) {
        return new Mesh(raylib_h.GenMeshPoly(arena, sides, radius));
    }

    public static Mesh genMeshPlane(float width, float length, int resX, int resZ) {
        return new Mesh(raylib_h.GenMeshPlane(Arena.ofAuto(), width, length, resX, resZ));
    }

    public static Mesh genMeshPlane(Arena arena, float width, float length, int resX, int resZ) {
        return new Mesh(raylib_h.GenMeshPlane(arena, width, length, resX, resZ));
    }

    public static Mesh genMeshCube(float width, float height, float length) {
        return new Mesh(raylib_h.GenMeshCube(Arena.ofAuto(), width, height, length));
    }

    public static Mesh genMeshCube(Arena arena, float width, float height, float length) {
        return new Mesh(raylib_h.GenMeshCube(arena, width, height, length));
    }

    public static Mesh genMeshSphere(float radius, int rings, int slices) {
        return new Mesh(raylib_h.GenMeshSphere(Arena.ofAuto(), radius, rings, slices));
    }

    public static Mesh genMeshSphere(Arena arena, float radius, int rings, int slices) {
        return new Mesh(raylib_h.GenMeshSphere(arena, radius, rings, slices));
    }

    public static Mesh genMeshHemiSphere(float radius, int rings, int slices) {
        return new Mesh(raylib_h.GenMeshHemiSphere(Arena.ofAuto(), radius, rings, slices));
    }

    public static Mesh genMeshHemiSphere(Arena arena, float radius, int rings, int slices) {
        return new Mesh(raylib_h.GenMeshHemiSphere(arena, radius, rings, slices));
    }

    public static Mesh genMeshCylinder(float radius, float height, int slices) {
        return new Mesh(raylib_h.GenMeshCylinder(Arena.ofAuto(), radius, height, slices));
    }

    public static Mesh genMeshCylinder(Arena arena, float radius, float height, int slices) {
        return new Mesh(raylib_h.GenMeshCylinder(arena, radius, height, slices));
    }

    public static Mesh genMeshCone(float radius, float height, int slices) {
        return new Mesh(raylib_h.GenMeshCone(Arena.ofAuto(), radius, height, slices));
    }

    public static Mesh genMeshCone(Arena arena, float radius, float height, int slices) {
        return new Mesh(raylib_h.GenMeshCone(arena, radius, height, slices));
    }

    public static Mesh genMeshTorus(float radius, float size, int radSeg, int sides) {
        return new Mesh(raylib_h.GenMeshTorus(Arena.ofAuto(), radius, size, radSeg, sides));
    }

    public static Mesh genMeshTorus(Arena arena, float radius, float size, int radSeg, int sides) {
        return new Mesh(raylib_h.GenMeshTorus(arena, radius, size, radSeg, sides));
    }

    public static Mesh genMeshKnot(float radius, float size, int radSeg, int sides) {
        return new Mesh(raylib_h.GenMeshKnot(Arena.ofAuto(), radius, size, radSeg, sides));
    }

    public static Mesh genMeshKnot(Arena arena, float radius, float size, int radSeg, int sides) {
        return new Mesh(raylib_h.GenMeshKnot(arena, radius, size, radSeg, sides));
    }

    public static Mesh genMeshHeightmap(Image heightmap, Vector3 size) {
        return new Mesh(raylib_h.GenMeshHeightmap(Arena.ofAuto(), heightmap.memorySegment, size.memorySegment));
    }

    public static Mesh genMeshHeightmap(Arena arena, Image heightmap, Vector3 size) {
        return new Mesh(raylib_h.GenMeshHeightmap(arena, heightmap.memorySegment, size.memorySegment));
    }

    public static Mesh genMeshCubicmap(Image cubicmap, Vector3 cubeSize) {
        return new Mesh(raylib_h.GenMeshCubicmap(Arena.ofAuto(), cubicmap.memorySegment, cubeSize.memorySegment));
    }

    public static Mesh genMeshCubicmap(Arena arena, Image cubicmap, Vector3 cubeSize) {
        return new Mesh(raylib_h.GenMeshCubicmap(arena, cubicmap.memorySegment, cubeSize.memorySegment));
    }

    public static Material loadMaterials(String fileName, IntBuffer materialCount) {
        try (Arena localArena = Arena.ofConfined();){
            Material material = new Material(raylib_h.LoadMaterials(localArena.allocateFrom(fileName), MemorySegment.ofBuffer(materialCount)));
            return material;
        }
    }

    public static Material loadMaterialDefault() {
        return new Material(raylib_h.LoadMaterialDefault(Arena.ofAuto()));
    }

    public static Material loadMaterialDefault(Arena arena) {
        return new Material(raylib_h.LoadMaterialDefault(arena));
    }

    public static boolean isMaterialValid(Material material) {
        return raylib_h.IsMaterialValid(material.memorySegment);
    }

    public static void unloadMaterial(Material material) {
        raylib_h.UnloadMaterial(material.memorySegment);
    }

    public static void setMaterialTexture(Material material, int mapType, Texture texture) {
        raylib_h.SetMaterialTexture(material.memorySegment, mapType, texture.memorySegment);
    }

    public static void setModelMeshMaterial(Model model, int meshId, int materialId) {
        raylib_h.SetModelMeshMaterial(model.memorySegment, meshId, materialId);
    }

    public static ModelAnimation loadModelAnimations(String fileName, IntBuffer animCount) {
        try (Arena localArena = Arena.ofConfined();){
            ModelAnimation modelAnimation = new ModelAnimation(raylib_h.LoadModelAnimations(localArena.allocateFrom(fileName), MemorySegment.ofBuffer(animCount)));
            return modelAnimation;
        }
    }

    public static void updateModelAnimation(Model model, ModelAnimation anim, int frame) {
        raylib_h.UpdateModelAnimation(model.memorySegment, anim.memorySegment, frame);
    }

    public static void updateModelAnimationBones(Model model, ModelAnimation anim, int frame) {
        raylib_h.UpdateModelAnimationBones(model.memorySegment, anim.memorySegment, frame);
    }

    public static void unloadModelAnimation(ModelAnimation anim) {
        raylib_h.UnloadModelAnimation(anim.memorySegment);
    }

    public static void unloadModelAnimations(ModelAnimation animations, int animCount) {
        raylib_h.UnloadModelAnimations(animations.memorySegment, animCount);
    }

    public static boolean isModelAnimationValid(Model model, ModelAnimation anim) {
        return raylib_h.IsModelAnimationValid(model.memorySegment, anim.memorySegment);
    }

    public static boolean checkCollisionSpheres(Vector3 center1, float radius1, Vector3 center2, float radius2) {
        return raylib_h.CheckCollisionSpheres(center1.memorySegment, radius1, center2.memorySegment, radius2);
    }

    public static boolean checkCollisionBoxes(BoundingBox box1, BoundingBox box2) {
        return raylib_h.CheckCollisionBoxes(box1.memorySegment, box2.memorySegment);
    }

    public static boolean checkCollisionBoxSphere(BoundingBox box, Vector3 center, float radius) {
        return raylib_h.CheckCollisionBoxSphere(box.memorySegment, center.memorySegment, radius);
    }

    public static RayCollision getRayCollisionSphere(Ray ray, Vector3 center, float radius) {
        return new RayCollision(raylib_h.GetRayCollisionSphere(Arena.ofAuto(), ray.memorySegment, center.memorySegment, radius));
    }

    public static RayCollision getRayCollisionSphere(Arena arena, Ray ray, Vector3 center, float radius) {
        return new RayCollision(raylib_h.GetRayCollisionSphere(arena, ray.memorySegment, center.memorySegment, radius));
    }

    public static RayCollision getRayCollisionBox(Ray ray, BoundingBox box) {
        return new RayCollision(raylib_h.GetRayCollisionBox(Arena.ofAuto(), ray.memorySegment, box.memorySegment));
    }

    public static RayCollision getRayCollisionBox(Arena arena, Ray ray, BoundingBox box) {
        return new RayCollision(raylib_h.GetRayCollisionBox(arena, ray.memorySegment, box.memorySegment));
    }

    public static RayCollision getRayCollisionMesh(Ray ray, Mesh mesh, Matrix transform) {
        return new RayCollision(raylib_h.GetRayCollisionMesh(Arena.ofAuto(), ray.memorySegment, mesh.memorySegment, transform.memorySegment));
    }

    public static RayCollision getRayCollisionMesh(Arena arena, Ray ray, Mesh mesh, Matrix transform) {
        return new RayCollision(raylib_h.GetRayCollisionMesh(arena, ray.memorySegment, mesh.memorySegment, transform.memorySegment));
    }

    public static RayCollision getRayCollisionTriangle(Ray ray, Vector3 p1, Vector3 p2, Vector3 p3) {
        return new RayCollision(raylib_h.GetRayCollisionTriangle(Arena.ofAuto(), ray.memorySegment, p1.memorySegment, p2.memorySegment, p3.memorySegment));
    }

    public static RayCollision getRayCollisionTriangle(Arena arena, Ray ray, Vector3 p1, Vector3 p2, Vector3 p3) {
        return new RayCollision(raylib_h.GetRayCollisionTriangle(arena, ray.memorySegment, p1.memorySegment, p2.memorySegment, p3.memorySegment));
    }

    public static RayCollision getRayCollisionQuad(Ray ray, Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4) {
        return new RayCollision(raylib_h.GetRayCollisionQuad(Arena.ofAuto(), ray.memorySegment, p1.memorySegment, p2.memorySegment, p3.memorySegment, p4.memorySegment));
    }

    public static RayCollision getRayCollisionQuad(Arena arena, Ray ray, Vector3 p1, Vector3 p2, Vector3 p3, Vector3 p4) {
        return new RayCollision(raylib_h.GetRayCollisionQuad(arena, ray.memorySegment, p1.memorySegment, p2.memorySegment, p3.memorySegment, p4.memorySegment));
    }

    public static void initAudioDevice() {
        raylib_h.InitAudioDevice();
    }

    public static void closeAudioDevice() {
        raylib_h.CloseAudioDevice();
    }

    public static boolean isAudioDeviceReady() {
        return raylib_h.IsAudioDeviceReady();
    }

    public static void setMasterVolume(float volume) {
        raylib_h.SetMasterVolume(volume);
    }

    public static float getMasterVolume() {
        return raylib_h.GetMasterVolume();
    }

    public static Wave loadWave(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            Wave wave = new Wave(raylib_h.LoadWave(Arena.ofAuto(), localArena.allocateFrom(fileName)));
            return wave;
        }
    }

    public static Wave loadWave(Arena arena, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            Wave wave = new Wave(raylib_h.LoadWave(arena, localArena.allocateFrom(fileName)));
            return wave;
        }
    }

    public static Wave loadWaveFromMemory(String fileType, ByteBuffer fileData, int dataSize) {
        try (Arena localArena = Arena.ofConfined();){
            Wave wave = new Wave(raylib_h.LoadWaveFromMemory(Arena.ofAuto(), localArena.allocateFrom(fileType), MemorySegment.ofBuffer(fileData), dataSize));
            return wave;
        }
    }

    public static Wave loadWaveFromMemory(Arena arena, String fileType, ByteBuffer fileData, int dataSize) {
        try (Arena localArena = Arena.ofConfined();){
            Wave wave = new Wave(raylib_h.LoadWaveFromMemory(arena, localArena.allocateFrom(fileType), MemorySegment.ofBuffer(fileData), dataSize));
            return wave;
        }
    }

    public static boolean isWaveValid(Wave wave) {
        return raylib_h.IsWaveValid(wave.memorySegment);
    }

    public static Sound loadSound(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            Sound sound = new Sound(raylib_h.LoadSound(Arena.ofAuto(), localArena.allocateFrom(fileName)));
            return sound;
        }
    }

    public static Sound loadSound(Arena arena, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            Sound sound = new Sound(raylib_h.LoadSound(arena, localArena.allocateFrom(fileName)));
            return sound;
        }
    }

    public static Sound loadSoundFromWave(Wave wave) {
        return new Sound(raylib_h.LoadSoundFromWave(Arena.ofAuto(), wave.memorySegment));
    }

    public static Sound loadSoundFromWave(Arena arena, Wave wave) {
        return new Sound(raylib_h.LoadSoundFromWave(arena, wave.memorySegment));
    }

    public static Sound loadSoundAlias(Sound source) {
        return new Sound(raylib_h.LoadSoundAlias(Arena.ofAuto(), source.memorySegment));
    }

    public static Sound loadSoundAlias(Arena arena, Sound source) {
        return new Sound(raylib_h.LoadSoundAlias(arena, source.memorySegment));
    }

    public static boolean isSoundValid(Sound sound) {
        return raylib_h.IsSoundValid(sound.memorySegment);
    }

    public static void updateSound(Sound sound, MemorySegment data, int sampleCount) {
        raylib_h.UpdateSound(sound.memorySegment, data, sampleCount);
    }

    public static void unloadWave(Wave wave) {
        raylib_h.UnloadWave(wave.memorySegment);
    }

    public static void unloadSound(Sound sound) {
        raylib_h.UnloadSound(sound.memorySegment);
    }

    public static void unloadSoundAlias(Sound alias) {
        raylib_h.UnloadSoundAlias(alias.memorySegment);
    }

    public static boolean exportWave(Wave wave, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.ExportWave(wave.memorySegment, localArena.allocateFrom(fileName));
            return bl;
        }
    }

    public static boolean exportWaveAsCode(Wave wave, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            boolean bl = raylib_h.ExportWaveAsCode(wave.memorySegment, localArena.allocateFrom(fileName));
            return bl;
        }
    }

    public static void playSound(Sound sound) {
        raylib_h.PlaySound(sound.memorySegment);
    }

    public static void stopSound(Sound sound) {
        raylib_h.StopSound(sound.memorySegment);
    }

    public static void pauseSound(Sound sound) {
        raylib_h.PauseSound(sound.memorySegment);
    }

    public static void resumeSound(Sound sound) {
        raylib_h.ResumeSound(sound.memorySegment);
    }

    public static boolean isSoundPlaying(Sound sound) {
        return raylib_h.IsSoundPlaying(sound.memorySegment);
    }

    public static void setSoundVolume(Sound sound, float volume) {
        raylib_h.SetSoundVolume(sound.memorySegment, volume);
    }

    public static void setSoundPitch(Sound sound, float pitch) {
        raylib_h.SetSoundPitch(sound.memorySegment, pitch);
    }

    public static void setSoundPan(Sound sound, float pan) {
        raylib_h.SetSoundPan(sound.memorySegment, pan);
    }

    public static Wave waveCopy(Wave wave) {
        return new Wave(raylib_h.WaveCopy(Arena.ofAuto(), wave.memorySegment));
    }

    public static Wave waveCopy(Arena arena, Wave wave) {
        return new Wave(raylib_h.WaveCopy(arena, wave.memorySegment));
    }

    public static void waveCrop(Wave wave, int initFrame, int finalFrame) {
        raylib_h.WaveCrop(wave.memorySegment, initFrame, finalFrame);
    }

    public static void waveFormat(Wave wave, int sampleRate, int sampleSize, int channels) {
        raylib_h.WaveFormat(wave.memorySegment, sampleRate, sampleSize, channels);
    }

    public static FloatBuffer loadWaveSamples(Wave wave) {
        return raylib_h.LoadWaveSamples(wave.memorySegment).reinterpret(0x3FFFFFFFL).asByteBuffer().order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    public static void unloadWaveSamples(FloatBuffer samples) {
        raylib_h.UnloadWaveSamples(MemorySegment.ofBuffer(samples));
    }

    public static Music loadMusicStream(String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            Music music = new Music(raylib_h.LoadMusicStream(Arena.ofAuto(), localArena.allocateFrom(fileName)));
            return music;
        }
    }

    public static Music loadMusicStream(Arena arena, String fileName) {
        try (Arena localArena = Arena.ofConfined();){
            Music music = new Music(raylib_h.LoadMusicStream(arena, localArena.allocateFrom(fileName)));
            return music;
        }
    }

    public static Music loadMusicStreamFromMemory(String fileType, ByteBuffer data, int dataSize) {
        try (Arena localArena = Arena.ofConfined();){
            Music music = new Music(raylib_h.LoadMusicStreamFromMemory(Arena.ofAuto(), localArena.allocateFrom(fileType), MemorySegment.ofBuffer(data), dataSize));
            return music;
        }
    }

    public static Music loadMusicStreamFromMemory(Arena arena, String fileType, ByteBuffer data, int dataSize) {
        try (Arena localArena = Arena.ofConfined();){
            Music music = new Music(raylib_h.LoadMusicStreamFromMemory(arena, localArena.allocateFrom(fileType), MemorySegment.ofBuffer(data), dataSize));
            return music;
        }
    }

    public static boolean isMusicValid(Music music) {
        return raylib_h.IsMusicValid(music.memorySegment);
    }

    public static void unloadMusicStream(Music music) {
        raylib_h.UnloadMusicStream(music.memorySegment);
    }

    public static void playMusicStream(Music music) {
        raylib_h.PlayMusicStream(music.memorySegment);
    }

    public static boolean isMusicStreamPlaying(Music music) {
        return raylib_h.IsMusicStreamPlaying(music.memorySegment);
    }

    public static void updateMusicStream(Music music) {
        raylib_h.UpdateMusicStream(music.memorySegment);
    }

    public static void stopMusicStream(Music music) {
        raylib_h.StopMusicStream(music.memorySegment);
    }

    public static void pauseMusicStream(Music music) {
        raylib_h.PauseMusicStream(music.memorySegment);
    }

    public static void resumeMusicStream(Music music) {
        raylib_h.ResumeMusicStream(music.memorySegment);
    }

    public static void seekMusicStream(Music music, float position) {
        raylib_h.SeekMusicStream(music.memorySegment, position);
    }

    public static void setMusicVolume(Music music, float volume) {
        raylib_h.SetMusicVolume(music.memorySegment, volume);
    }

    public static void setMusicPitch(Music music, float pitch) {
        raylib_h.SetMusicPitch(music.memorySegment, pitch);
    }

    public static void setMusicPan(Music music, float pan) {
        raylib_h.SetMusicPan(music.memorySegment, pan);
    }

    public static float getMusicTimeLength(Music music) {
        return raylib_h.GetMusicTimeLength(music.memorySegment);
    }

    public static float getMusicTimePlayed(Music music) {
        return raylib_h.GetMusicTimePlayed(music.memorySegment);
    }

    public static AudioStream loadAudioStream(int sampleRate, int sampleSize, int channels) {
        return new AudioStream(raylib_h.LoadAudioStream(Arena.ofAuto(), sampleRate, sampleSize, channels));
    }

    public static AudioStream loadAudioStream(Arena arena, int sampleRate, int sampleSize, int channels) {
        return new AudioStream(raylib_h.LoadAudioStream(arena, sampleRate, sampleSize, channels));
    }

    public static boolean isAudioStreamValid(AudioStream stream) {
        return raylib_h.IsAudioStreamValid(stream.memorySegment);
    }

    public static void unloadAudioStream(AudioStream stream) {
        raylib_h.UnloadAudioStream(stream.memorySegment);
    }

    public static void updateAudioStream(AudioStream stream, MemorySegment data, int frameCount) {
        raylib_h.UpdateAudioStream(stream.memorySegment, data, frameCount);
    }

    public static boolean isAudioStreamProcessed(AudioStream stream) {
        return raylib_h.IsAudioStreamProcessed(stream.memorySegment);
    }

    public static void playAudioStream(AudioStream stream) {
        raylib_h.PlayAudioStream(stream.memorySegment);
    }

    public static void pauseAudioStream(AudioStream stream) {
        raylib_h.PauseAudioStream(stream.memorySegment);
    }

    public static void resumeAudioStream(AudioStream stream) {
        raylib_h.ResumeAudioStream(stream.memorySegment);
    }

    public static boolean isAudioStreamPlaying(AudioStream stream) {
        return raylib_h.IsAudioStreamPlaying(stream.memorySegment);
    }

    public static void stopAudioStream(AudioStream stream) {
        raylib_h.StopAudioStream(stream.memorySegment);
    }

    public static void setAudioStreamVolume(AudioStream stream, float volume) {
        raylib_h.SetAudioStreamVolume(stream.memorySegment, volume);
    }

    public static void setAudioStreamPitch(AudioStream stream, float pitch) {
        raylib_h.SetAudioStreamPitch(stream.memorySegment, pitch);
    }

    public static void setAudioStreamPan(AudioStream stream, float pan) {
        raylib_h.SetAudioStreamPan(stream.memorySegment, pan);
    }

    public static void setAudioStreamBufferSizeDefault(int size) {
        raylib_h.SetAudioStreamBufferSizeDefault(size);
    }

    public static void setAudioStreamCallback(AudioStream stream, MemorySegment callback) {
        raylib_h.SetAudioStreamCallback(stream.memorySegment, callback);
    }

    public static void attachAudioStreamProcessor(AudioStream stream, MemorySegment processor) {
        raylib_h.AttachAudioStreamProcessor(stream.memorySegment, processor);
    }

    public static void detachAudioStreamProcessor(AudioStream stream, MemorySegment processor) {
        raylib_h.DetachAudioStreamProcessor(stream.memorySegment, processor);
    }

    public static void attachAudioMixedProcessor(MemorySegment processor) {
        raylib_h.AttachAudioMixedProcessor(processor);
    }

    public static void detachAudioMixedProcessor(MemorySegment processor) {
        raylib_h.DetachAudioMixedProcessor(processor);
    }

    private static Color c(int r, int g, int b, int a) {
        return new Color((byte)r, (byte)g, (byte)b, (byte)a);
    }

    public static class NPatchLayout {
        public static final int NPATCH_NINE_PATCH = 0;
        public static final int NPATCH_THREE_PATCH_VERTICAL = 1;
        public static final int NPATCH_THREE_PATCH_HORIZONTAL = 2;
    }

    public static class CameraProjection {
        public static final int CAMERA_PERSPECTIVE = 0;
        public static final int CAMERA_ORTHOGRAPHIC = 1;
    }

    public static class CameraMode {
        public static final int CAMERA_CUSTOM = 0;
        public static final int CAMERA_FREE = 1;
        public static final int CAMERA_ORBITAL = 2;
        public static final int CAMERA_FIRST_PERSON = 3;
        public static final int CAMERA_THIRD_PERSON = 4;
    }

    public static class Gesture {
        public static final int GESTURE_NONE = 0;
        public static final int GESTURE_TAP = 1;
        public static final int GESTURE_DOUBLETAP = 2;
        public static final int GESTURE_HOLD = 4;
        public static final int GESTURE_DRAG = 8;
        public static final int GESTURE_SWIPE_RIGHT = 16;
        public static final int GESTURE_SWIPE_LEFT = 32;
        public static final int GESTURE_SWIPE_UP = 64;
        public static final int GESTURE_SWIPE_DOWN = 128;
        public static final int GESTURE_PINCH_IN = 256;
        public static final int GESTURE_PINCH_OUT = 512;
    }

    public static class BlendMode {
        public static final int BLEND_ALPHA = 0;
        public static final int BLEND_ADDITIVE = 1;
        public static final int BLEND_MULTIPLIED = 2;
        public static final int BLEND_ADD_COLORS = 3;
        public static final int BLEND_SUBTRACT_COLORS = 4;
        public static final int BLEND_ALPHA_PREMULTIPLY = 5;
        public static final int BLEND_CUSTOM = 6;
        public static final int BLEND_CUSTOM_SEPARATE = 7;
    }

    public static class FontType {
        public static final int FONT_DEFAULT = 0;
        public static final int FONT_BITMAP = 1;
        public static final int FONT_SDF = 2;
    }

    public static class CubemapLayout {
        public static final int CUBEMAP_LAYOUT_AUTO_DETECT = 0;
        public static final int CUBEMAP_LAYOUT_LINE_VERTICAL = 1;
        public static final int CUBEMAP_LAYOUT_LINE_HORIZONTAL = 2;
        public static final int CUBEMAP_LAYOUT_CROSS_THREE_BY_FOUR = 3;
        public static final int CUBEMAP_LAYOUT_CROSS_FOUR_BY_THREE = 4;
    }

    public static class TextureWrap {
        public static final int TEXTURE_WRAP_REPEAT = 0;
        public static final int TEXTURE_WRAP_CLAMP = 1;
        public static final int TEXTURE_WRAP_MIRROR_REPEAT = 2;
        public static final int TEXTURE_WRAP_MIRROR_CLAMP = 3;
    }

    public static class TextureFilter {
        public static final int TEXTURE_FILTER_POINT = 0;
        public static final int TEXTURE_FILTER_BILINEAR = 1;
        public static final int TEXTURE_FILTER_TRILINEAR = 2;
        public static final int TEXTURE_FILTER_ANISOTROPIC_4X = 3;
        public static final int TEXTURE_FILTER_ANISOTROPIC_8X = 4;
        public static final int TEXTURE_FILTER_ANISOTROPIC_16X = 5;
    }

    public static class PixelFormat {
        public static final int PIXELFORMAT_UNCOMPRESSED_GRAYSCALE = 1;
        public static final int PIXELFORMAT_UNCOMPRESSED_GRAY_ALPHA = 2;
        public static final int PIXELFORMAT_UNCOMPRESSED_R5G6B5 = 3;
        public static final int PIXELFORMAT_UNCOMPRESSED_R8G8B8 = 4;
        public static final int PIXELFORMAT_UNCOMPRESSED_R5G5B5A1 = 5;
        public static final int PIXELFORMAT_UNCOMPRESSED_R4G4B4A4 = 6;
        public static final int PIXELFORMAT_UNCOMPRESSED_R8G8B8A8 = 7;
        public static final int PIXELFORMAT_UNCOMPRESSED_R32 = 8;
        public static final int PIXELFORMAT_UNCOMPRESSED_R32G32B32 = 9;
        public static final int PIXELFORMAT_UNCOMPRESSED_R32G32B32A32 = 10;
        public static final int PIXELFORMAT_UNCOMPRESSED_R16 = 11;
        public static final int PIXELFORMAT_UNCOMPRESSED_R16G16B16 = 12;
        public static final int PIXELFORMAT_UNCOMPRESSED_R16G16B16A16 = 13;
        public static final int PIXELFORMAT_COMPRESSED_DXT1_RGB = 14;
        public static final int PIXELFORMAT_COMPRESSED_DXT1_RGBA = 15;
        public static final int PIXELFORMAT_COMPRESSED_DXT3_RGBA = 16;
        public static final int PIXELFORMAT_COMPRESSED_DXT5_RGBA = 17;
        public static final int PIXELFORMAT_COMPRESSED_ETC1_RGB = 18;
        public static final int PIXELFORMAT_COMPRESSED_ETC2_RGB = 19;
        public static final int PIXELFORMAT_COMPRESSED_ETC2_EAC_RGBA = 20;
        public static final int PIXELFORMAT_COMPRESSED_PVRT_RGB = 21;
        public static final int PIXELFORMAT_COMPRESSED_PVRT_RGBA = 22;
        public static final int PIXELFORMAT_COMPRESSED_ASTC_4x4_RGBA = 23;
        public static final int PIXELFORMAT_COMPRESSED_ASTC_8x8_RGBA = 24;
    }

    public static class ShaderAttributeDataType {
        public static final int SHADER_ATTRIB_FLOAT = 0;
        public static final int SHADER_ATTRIB_VEC2 = 1;
        public static final int SHADER_ATTRIB_VEC3 = 2;
        public static final int SHADER_ATTRIB_VEC4 = 3;
    }

    public static class ShaderUniformDataType {
        public static final int SHADER_UNIFORM_FLOAT = 0;
        public static final int SHADER_UNIFORM_VEC2 = 1;
        public static final int SHADER_UNIFORM_VEC3 = 2;
        public static final int SHADER_UNIFORM_VEC4 = 3;
        public static final int SHADER_UNIFORM_INT = 4;
        public static final int SHADER_UNIFORM_IVEC2 = 5;
        public static final int SHADER_UNIFORM_IVEC3 = 6;
        public static final int SHADER_UNIFORM_IVEC4 = 7;
        public static final int SHADER_UNIFORM_SAMPLER2D = 8;
    }

    public static class ShaderLocationIndex {
        public static final int SHADER_LOC_VERTEX_POSITION = 0;
        public static final int SHADER_LOC_VERTEX_TEXCOORD01 = 1;
        public static final int SHADER_LOC_VERTEX_TEXCOORD02 = 2;
        public static final int SHADER_LOC_VERTEX_NORMAL = 3;
        public static final int SHADER_LOC_VERTEX_TANGENT = 4;
        public static final int SHADER_LOC_VERTEX_COLOR = 5;
        public static final int SHADER_LOC_MATRIX_MVP = 6;
        public static final int SHADER_LOC_MATRIX_VIEW = 7;
        public static final int SHADER_LOC_MATRIX_PROJECTION = 8;
        public static final int SHADER_LOC_MATRIX_MODEL = 9;
        public static final int SHADER_LOC_MATRIX_NORMAL = 10;
        public static final int SHADER_LOC_VECTOR_VIEW = 11;
        public static final int SHADER_LOC_COLOR_DIFFUSE = 12;
        public static final int SHADER_LOC_COLOR_SPECULAR = 13;
        public static final int SHADER_LOC_COLOR_AMBIENT = 14;
        public static final int SHADER_LOC_MAP_ALBEDO = 15;
        public static final int SHADER_LOC_MAP_METALNESS = 16;
        public static final int SHADER_LOC_MAP_NORMAL = 17;
        public static final int SHADER_LOC_MAP_ROUGHNESS = 18;
        public static final int SHADER_LOC_MAP_OCCLUSION = 19;
        public static final int SHADER_LOC_MAP_EMISSION = 20;
        public static final int SHADER_LOC_MAP_HEIGHT = 21;
        public static final int SHADER_LOC_MAP_CUBEMAP = 22;
        public static final int SHADER_LOC_MAP_IRRADIANCE = 23;
        public static final int SHADER_LOC_MAP_PREFILTER = 24;
        public static final int SHADER_LOC_MAP_BRDF = 25;
        public static final int SHADER_LOC_VERTEX_BONEIDS = 26;
        public static final int SHADER_LOC_VERTEX_BONEWEIGHTS = 27;
        public static final int SHADER_LOC_BONE_MATRICES = 28;
    }

    public static class MaterialMapIndex {
        public static final int MATERIAL_MAP_ALBEDO = 0;
        public static final int MATERIAL_MAP_METALNESS = 1;
        public static final int MATERIAL_MAP_NORMAL = 2;
        public static final int MATERIAL_MAP_ROUGHNESS = 3;
        public static final int MATERIAL_MAP_OCCLUSION = 4;
        public static final int MATERIAL_MAP_EMISSION = 5;
        public static final int MATERIAL_MAP_HEIGHT = 6;
        public static final int MATERIAL_MAP_CUBEMAP = 7;
        public static final int MATERIAL_MAP_IRRADIANCE = 8;
        public static final int MATERIAL_MAP_PREFILTER = 9;
        public static final int MATERIAL_MAP_BRDF = 10;
    }

    public static class GamepadAxis {
        public static final int GAMEPAD_AXIS_LEFT_X = 0;
        public static final int GAMEPAD_AXIS_LEFT_Y = 1;
        public static final int GAMEPAD_AXIS_RIGHT_X = 2;
        public static final int GAMEPAD_AXIS_RIGHT_Y = 3;
        public static final int GAMEPAD_AXIS_LEFT_TRIGGER = 4;
        public static final int GAMEPAD_AXIS_RIGHT_TRIGGER = 5;
    }

    public static class GamepadButton {
        public static final int GAMEPAD_BUTTON_UNKNOWN = 0;
        public static final int GAMEPAD_BUTTON_LEFT_FACE_UP = 1;
        public static final int GAMEPAD_BUTTON_LEFT_FACE_RIGHT = 2;
        public static final int GAMEPAD_BUTTON_LEFT_FACE_DOWN = 3;
        public static final int GAMEPAD_BUTTON_LEFT_FACE_LEFT = 4;
        public static final int GAMEPAD_BUTTON_RIGHT_FACE_UP = 5;
        public static final int GAMEPAD_BUTTON_RIGHT_FACE_RIGHT = 6;
        public static final int GAMEPAD_BUTTON_RIGHT_FACE_DOWN = 7;
        public static final int GAMEPAD_BUTTON_RIGHT_FACE_LEFT = 8;
        public static final int GAMEPAD_BUTTON_LEFT_TRIGGER_1 = 9;
        public static final int GAMEPAD_BUTTON_LEFT_TRIGGER_2 = 10;
        public static final int GAMEPAD_BUTTON_RIGHT_TRIGGER_1 = 11;
        public static final int GAMEPAD_BUTTON_RIGHT_TRIGGER_2 = 12;
        public static final int GAMEPAD_BUTTON_MIDDLE_LEFT = 13;
        public static final int GAMEPAD_BUTTON_MIDDLE = 14;
        public static final int GAMEPAD_BUTTON_MIDDLE_RIGHT = 15;
        public static final int GAMEPAD_BUTTON_LEFT_THUMB = 16;
        public static final int GAMEPAD_BUTTON_RIGHT_THUMB = 17;
    }

    public static class MouseCursor {
        public static final int MOUSE_CURSOR_DEFAULT = 0;
        public static final int MOUSE_CURSOR_ARROW = 1;
        public static final int MOUSE_CURSOR_IBEAM = 2;
        public static final int MOUSE_CURSOR_CROSSHAIR = 3;
        public static final int MOUSE_CURSOR_POINTING_HAND = 4;
        public static final int MOUSE_CURSOR_RESIZE_EW = 5;
        public static final int MOUSE_CURSOR_RESIZE_NS = 6;
        public static final int MOUSE_CURSOR_RESIZE_NWSE = 7;
        public static final int MOUSE_CURSOR_RESIZE_NESW = 8;
        public static final int MOUSE_CURSOR_RESIZE_ALL = 9;
        public static final int MOUSE_CURSOR_NOT_ALLOWED = 10;
    }

    public static class MouseButton {
        public static final int MOUSE_BUTTON_LEFT = 0;
        public static final int MOUSE_BUTTON_RIGHT = 1;
        public static final int MOUSE_BUTTON_MIDDLE = 2;
        public static final int MOUSE_BUTTON_SIDE = 3;
        public static final int MOUSE_BUTTON_EXTRA = 4;
        public static final int MOUSE_BUTTON_FORWARD = 5;
        public static final int MOUSE_BUTTON_BACK = 6;
    }

    public static class KeyboardKey {
        public static final int KEY_NULL = 0;
        public static final int KEY_APOSTROPHE = 39;
        public static final int KEY_COMMA = 44;
        public static final int KEY_MINUS = 45;
        public static final int KEY_PERIOD = 46;
        public static final int KEY_SLASH = 47;
        public static final int KEY_ZERO = 48;
        public static final int KEY_ONE = 49;
        public static final int KEY_TWO = 50;
        public static final int KEY_THREE = 51;
        public static final int KEY_FOUR = 52;
        public static final int KEY_FIVE = 53;
        public static final int KEY_SIX = 54;
        public static final int KEY_SEVEN = 55;
        public static final int KEY_EIGHT = 56;
        public static final int KEY_NINE = 57;
        public static final int KEY_SEMICOLON = 59;
        public static final int KEY_EQUAL = 61;
        public static final int KEY_A = 65;
        public static final int KEY_B = 66;
        public static final int KEY_C = 67;
        public static final int KEY_D = 68;
        public static final int KEY_E = 69;
        public static final int KEY_F = 70;
        public static final int KEY_G = 71;
        public static final int KEY_H = 72;
        public static final int KEY_I = 73;
        public static final int KEY_J = 74;
        public static final int KEY_K = 75;
        public static final int KEY_L = 76;
        public static final int KEY_M = 77;
        public static final int KEY_N = 78;
        public static final int KEY_O = 79;
        public static final int KEY_P = 80;
        public static final int KEY_Q = 81;
        public static final int KEY_R = 82;
        public static final int KEY_S = 83;
        public static final int KEY_T = 84;
        public static final int KEY_U = 85;
        public static final int KEY_V = 86;
        public static final int KEY_W = 87;
        public static final int KEY_X = 88;
        public static final int KEY_Y = 89;
        public static final int KEY_Z = 90;
        public static final int KEY_LEFT_BRACKET = 91;
        public static final int KEY_BACKSLASH = 92;
        public static final int KEY_RIGHT_BRACKET = 93;
        public static final int KEY_GRAVE = 96;
        public static final int KEY_SPACE = 32;
        public static final int KEY_ESCAPE = 256;
        public static final int KEY_ENTER = 257;
        public static final int KEY_TAB = 258;
        public static final int KEY_BACKSPACE = 259;
        public static final int KEY_INSERT = 260;
        public static final int KEY_DELETE = 261;
        public static final int KEY_RIGHT = 262;
        public static final int KEY_LEFT = 263;
        public static final int KEY_DOWN = 264;
        public static final int KEY_UP = 265;
        public static final int KEY_PAGE_UP = 266;
        public static final int KEY_PAGE_DOWN = 267;
        public static final int KEY_HOME = 268;
        public static final int KEY_END = 269;
        public static final int KEY_CAPS_LOCK = 280;
        public static final int KEY_SCROLL_LOCK = 281;
        public static final int KEY_NUM_LOCK = 282;
        public static final int KEY_PRINT_SCREEN = 283;
        public static final int KEY_PAUSE = 284;
        public static final int KEY_F1 = 290;
        public static final int KEY_F2 = 291;
        public static final int KEY_F3 = 292;
        public static final int KEY_F4 = 293;
        public static final int KEY_F5 = 294;
        public static final int KEY_F6 = 295;
        public static final int KEY_F7 = 296;
        public static final int KEY_F8 = 297;
        public static final int KEY_F9 = 298;
        public static final int KEY_F10 = 299;
        public static final int KEY_F11 = 300;
        public static final int KEY_F12 = 301;
        public static final int KEY_LEFT_SHIFT = 340;
        public static final int KEY_LEFT_CONTROL = 341;
        public static final int KEY_LEFT_ALT = 342;
        public static final int KEY_LEFT_SUPER = 343;
        public static final int KEY_RIGHT_SHIFT = 344;
        public static final int KEY_RIGHT_CONTROL = 345;
        public static final int KEY_RIGHT_ALT = 346;
        public static final int KEY_RIGHT_SUPER = 347;
        public static final int KEY_KB_MENU = 348;
        public static final int KEY_KP_0 = 320;
        public static final int KEY_KP_1 = 321;
        public static final int KEY_KP_2 = 322;
        public static final int KEY_KP_3 = 323;
        public static final int KEY_KP_4 = 324;
        public static final int KEY_KP_5 = 325;
        public static final int KEY_KP_6 = 326;
        public static final int KEY_KP_7 = 327;
        public static final int KEY_KP_8 = 328;
        public static final int KEY_KP_9 = 329;
        public static final int KEY_KP_DECIMAL = 330;
        public static final int KEY_KP_DIVIDE = 331;
        public static final int KEY_KP_MULTIPLY = 332;
        public static final int KEY_KP_SUBTRACT = 333;
        public static final int KEY_KP_ADD = 334;
        public static final int KEY_KP_ENTER = 335;
        public static final int KEY_KP_EQUAL = 336;
        public static final int KEY_BACK = 4;
        public static final int KEY_MENU = 5;
        public static final int KEY_VOLUME_UP = 24;
        public static final int KEY_VOLUME_DOWN = 25;
    }

    public static class TraceLogLevel {
        public static final int LOG_ALL = 0;
        public static final int LOG_TRACE = 1;
        public static final int LOG_DEBUG = 2;
        public static final int LOG_INFO = 3;
        public static final int LOG_WARNING = 4;
        public static final int LOG_ERROR = 5;
        public static final int LOG_FATAL = 6;
        public static final int LOG_NONE = 7;
    }

    public static class ConfigFlags {
        public static final int FLAG_VSYNC_HINT = 64;
        public static final int FLAG_FULLSCREEN_MODE = 2;
        public static final int FLAG_WINDOW_RESIZABLE = 4;
        public static final int FLAG_WINDOW_UNDECORATED = 8;
        public static final int FLAG_WINDOW_HIDDEN = 128;
        public static final int FLAG_WINDOW_MINIMIZED = 512;
        public static final int FLAG_WINDOW_MAXIMIZED = 1024;
        public static final int FLAG_WINDOW_UNFOCUSED = 2048;
        public static final int FLAG_WINDOW_TOPMOST = 4096;
        public static final int FLAG_WINDOW_ALWAYS_RUN = 256;
        public static final int FLAG_WINDOW_TRANSPARENT = 16;
        public static final int FLAG_WINDOW_HIGHDPI = 8192;
        public static final int FLAG_WINDOW_MOUSE_PASSTHROUGH = 16384;
        public static final int FLAG_BORDERLESS_WINDOWED_MODE = 32768;
        public static final int FLAG_MSAA_4X_HINT = 32;
        public static final int FLAG_INTERLACED_HINT = 65536;
    }
}

