/*
 * Decompiled with CFR 0.152.
 */
package uk.co.electronstudio.tests;

import com.raylib.Raylib;
import com.raylib.Texture;
import java.lang.foreign.Arena;
import uk.co.electronstudio.Util;

public class Benchmark {
    static int WIDTH = 1000;
    static int HEIGHT = 1000;
    static int ITERATIONS = 100;

    public static void main(String[] args) {
        try (Arena arena = Arena.ofConfined();){
            String a = Util.extractFileFromResources("wabbit_alpha", ".png");
            Raylib.setTraceLogLevel(5);
            Raylib.initWindow(WIDTH, HEIGHT, "raylib");
            Texture texBunny = Raylib.loadTexture(arena, a);
            long start = System.nanoTime();
            for (int i = 0; i < ITERATIONS; ++i) {
                Raylib.beginDrawing();
                Raylib.clearBackground(Raylib.WHITE);
                for (int x = 0; x < WIDTH; ++x) {
                    for (int y = 0; y < HEIGHT; ++y) {
                        Raylib.drawTexture(texBunny, x, y, Raylib.WHITE);
                    }
                }
                Raylib.drawFPS(10, 10);
                Raylib.endDrawing();
            }
            long end = System.nanoTime();
            double elapsed_time = (float)(end - start) * 1.0E-9f;
            double mbunnies_per_second = (double)(WIDTH * HEIGHT * ITERATIONS) / elapsed_time / 1000000.0;
            Raylib.unloadTexture(texBunny);
            Raylib.closeWindow();
            System.out.println("Raylib | Java | Jaylib2 | " + mbunnies_per_second);
        }
    }
}

