/*
 * Decompiled with CFR 0.152.
 */
package uk.co.electronstudio.tests;

import com.raylib.Color;
import com.raylib.Raylib;
import com.raylib.Texture;
import java.lang.foreign.Arena;
import uk.co.electronstudio.Util;

public class Bunnymark {
    static int MAX_BUNNIES = 500000;

    public static void main(String[] args) {
        try (Arena arena = Arena.ofConfined();){
            System.out.println(System.getProperty("java.vm.name"));
            System.out.println(System.getProperty("java.vm.vendor"));
            System.out.println(System.getProperty("java.vm.version"));
            int screenWidth = 1920;
            int screenHeight = 1080;
            Raylib.initWindow(screenWidth, screenHeight, "raylib [textures] example - bunnymark");
            Texture texBunny = Raylib.loadTexture(arena, Util.extractFileFromResources("wabbit_alpha", ".png"));
            Bunny[] bunnies = new Bunny[MAX_BUNNIES];
            for (int i = 0; i < MAX_BUNNIES; ++i) {
                bunnies[i] = new Bunny();
            }
            int bunniesCount = 0;
            Raylib.setTargetFPS(60);
            while (!Raylib.windowShouldClose()) {
                int i;
                if (Raylib.isMouseButtonDown(0)) {
                    for (int i2 = 0; i2 < 100; ++i2) {
                        if (bunniesCount >= MAX_BUNNIES) continue;
                        bunnies[bunniesCount].position.x = Raylib.getMousePosition(arena).getX();
                        bunnies[bunniesCount].position.y = Raylib.getMousePosition(arena).getY();
                        bunnies[bunniesCount].speed.x = (float)Raylib.getRandomValue(-250, 250) / 60.0f;
                        bunnies[bunniesCount].speed.y = (float)Raylib.getRandomValue(-250, 250) / 60.0f;
                        bunnies[bunniesCount].color = new Color((byte)Raylib.getRandomValue(50, 240), (byte)Raylib.getRandomValue(80, 240), (byte)Raylib.getRandomValue(100, 240), -1);
                        ++bunniesCount;
                    }
                }
                float width = texBunny.getWidth();
                float height = texBunny.getHeight();
                for (i = 0; i < bunniesCount; ++i) {
                    bunnies[i].position.x += bunnies[i].speed.x;
                    bunnies[i].position.y += bunnies[i].speed.y;
                    if ((double)bunnies[i].position.x + (double)width / 2.0 > (double)screenWidth || (double)bunnies[i].position.x + (double)width / 2.0 < 0.0) {
                        bunnies[i].speed.x *= -1.0f;
                    }
                    if (!((double)bunnies[i].position.y + (double)height / 2.0 > (double)screenHeight) && !((double)bunnies[i].position.y + (double)height / 2.0 - 40.0 < 0.0)) continue;
                    bunnies[i].speed.y *= -1.0f;
                }
                Raylib.beginDrawing();
                Raylib.clearBackground(Raylib.WHITE);
                for (i = 0; i < bunniesCount; ++i) {
                    Raylib.drawTexture(texBunny, (int)bunnies[i].position.x, (int)bunnies[i].position.y, bunnies[i].color);
                }
                Raylib.drawRectangle(0, 0, screenWidth, 40, Raylib.BLACK);
                Raylib.drawText("bunnies: " + bunniesCount, 120, 10, 20, Raylib.WHITE);
                Raylib.drawFPS(10, 10);
                Raylib.endDrawing();
            }
            Raylib.unloadTexture(texBunny);
            Raylib.closeWindow();
        }
    }

    static class Bunny {
        Vec2 position = new Vec2();
        Vec2 speed = new Vec2();
        Color color = new Color();

        Bunny() {
        }
    }

    static class Vec2 {
        float x;
        float y;

        Vec2() {
        }
    }
}

