/*
 * Decompiled with CFR 0.152.
 */
package uk.co.electronstudio.tests;

import com.raylib.Color;
import com.raylib.Raylib;
import com.raylib.Texture;
import com.raylib.jextract.raylib_h_1;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import uk.co.electronstudio.Util;

public class BunnymarkHybrid {
    static int MAX_BUNNIES = 500000;

    public static void main(String[] args) {
        System.out.println("Hello world!");
        try (Arena arena = Arena.ofConfined();){
            System.out.println(System.getProperty("java.vm.name"));
            System.out.println(System.getProperty("java.vm.vendor"));
            System.out.println(System.getProperty("java.vm.version"));
            int screenWidth = 1920;
            int screenHeight = 1080;
            Raylib.initWindow(screenWidth, screenHeight, "raylib [textures] example - bunnymark");
            Texture texBunny = Raylib.loadTexture(arena, Util.extractFileFromResources("wabbit_alpha", ".png"));
            MemorySegment texBunnySeg = texBunny.memorySegment;
            MemorySegment white = Raylib.WHITE.memorySegment;
            MemorySegment black = Raylib.BLACK.memorySegment;
            Bunny[] bunnies = new Bunny[MAX_BUNNIES];
            for (int i = 0; i < MAX_BUNNIES; ++i) {
                bunnies[i] = new Bunny();
            }
            int bunniesCount = 0;
            MemorySegment bunniesText = arena.allocateFrom("Bunnies: 0");
            Object bunniesTextStr = "";
            Raylib.setTargetFPS(60);
            float width = texBunny.getWidth();
            float height = texBunny.getHeight();
            while (!raylib_h_1.WindowShouldClose()) {
                int i;
                if (raylib_h_1.IsMouseButtonDown(0)) {
                    for (i = 0; i < 200; ++i) {
                        if (bunniesCount >= MAX_BUNNIES) continue;
                        bunnies[bunniesCount].position.x = Raylib.getMousePosition(arena).getX();
                        bunnies[bunniesCount].position.y = Raylib.getMousePosition(arena).getY();
                        bunnies[bunniesCount].speed.x = (float)Raylib.getRandomValue(-250, 250) / 60.0f;
                        bunnies[bunniesCount].speed.y = (float)Raylib.getRandomValue(-250, 250) / 60.0f;
                        bunnies[bunniesCount].color = new Color(arena, (byte)Raylib.getRandomValue(50, 240), (byte)Raylib.getRandomValue(80, 240), (byte)Raylib.getRandomValue(100, 240), -1);
                        bunniesTextStr = "Bunnies: " + ++bunniesCount;
                        bunniesText = arena.allocateFrom((String)bunniesTextStr);
                    }
                }
                for (i = 0; i < bunniesCount; ++i) {
                    bunnies[i].position.x += bunnies[i].speed.x;
                    bunnies[i].position.y += bunnies[i].speed.y;
                    if ((double)bunnies[i].position.x + (double)width / 2.0 > (double)screenWidth || (double)bunnies[i].position.x + (double)width / 2.0 < 0.0) {
                        bunnies[i].speed.x *= -1.0f;
                    }
                    if (!((double)bunnies[i].position.y + (double)height / 2.0 > (double)screenHeight) && !((double)bunnies[i].position.y + (double)height / 2.0 - 40.0 < 0.0)) continue;
                    bunnies[i].speed.y *= -1.0f;
                }
                raylib_h_1.BeginDrawing();
                raylib_h_1.ClearBackground(Raylib.WHITE.memorySegment);
                for (i = 0; i < bunniesCount; ++i) {
                    Raylib.drawTexture(texBunny, (int)bunnies[i].position.x, (int)bunnies[i].position.y, bunnies[i].color);
                }
                raylib_h_1.DrawRectangle(0, 0, screenWidth, 40, Raylib.BLACK.memorySegment);
                Raylib.drawText((String)bunniesTextStr, 120, 10, 20, Raylib.WHITE);
                raylib_h_1.DrawFPS(10, 10);
                raylib_h_1.EndDrawing();
            }
            Raylib.unloadTexture(texBunny);
            Raylib.closeWindow();
        }
    }

    static class Bunny {
        Vec2 position = new Vec2();
        Vec2 speed = new Vec2();
        Color color = null;

        Bunny() {
        }
    }

    static class Vec2 {
        float x;
        float y;

        Vec2() {
        }
    }
}

