/*
 * Decompiled with CFR 0.152.
 */
package uk.co.electronstudio.tests;

import com.raylib.jextract.Color;
import com.raylib.jextract.Texture;
import com.raylib.jextract.Vector2;
import com.raylib.jextract.raylib_h;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;

public class BunnymarkJextract {
    static int MAX_BUNNIES = 500000;
    static int MAX_BATCH_ELEMENTS = 8192;

    public static void main(String[] args) {
        System.out.println("Hello world!");
        try (Arena arena = Arena.ofConfined();){
            System.out.println(System.getProperty("java.vm.name"));
            System.out.println(System.getProperty("java.vm.vendor"));
            System.out.println(System.getProperty("java.vm.version"));
            int screenWidth = 1920;
            int screenHeight = 1080;
            raylib_h.InitWindow(screenWidth, screenHeight, arena.allocateFrom("raylib [textures] example - bunnymark"));
            MemorySegment texBunny = raylib_h.LoadTexture(arena, arena.allocateFrom("src/main/resources/wabbit_alpha.png"));
            Bunny[] bunnies = new Bunny[MAX_BUNNIES];
            for (int i = 0; i < MAX_BUNNIES; ++i) {
                bunnies[i] = new Bunny();
            }
            int bunniesCount = 0;
            MemorySegment bunniesText = arena.allocateFrom("Bunnies: 0");
            float width = Texture.width(texBunny);
            float height = Texture.height(texBunny);
            MemorySegment black = Color.allocate(arena);
            Color.a(black, (byte)-1);
            MemorySegment white = Color.allocate(arena);
            Color.r(white, (byte)-1);
            Color.g(white, (byte)-1);
            Color.b(white, (byte)-1);
            Color.a(white, (byte)-1);
            raylib_h.SetTargetFPS(60);
            while (!raylib_h.WindowShouldClose()) {
                int i;
                if (raylib_h.IsMouseButtonDown(0)) {
                    for (i = 0; i < 200; ++i) {
                        if (bunniesCount >= MAX_BUNNIES) continue;
                        bunnies[bunniesCount].position.x = Vector2.x(raylib_h.GetMousePosition(arena));
                        bunnies[bunniesCount].position.y = Vector2.y(raylib_h.GetMousePosition(arena));
                        bunnies[bunniesCount].speed.x = (float)raylib_h.GetRandomValue(-250, 250) / 60.0f;
                        bunnies[bunniesCount].speed.y = (float)raylib_h.GetRandomValue(-250, 250) / 60.0f;
                        MemorySegment color = Color.allocate(arena);
                        Color.r(color, (byte)raylib_h.GetRandomValue(50, 240));
                        Color.g(color, (byte)raylib_h.GetRandomValue(80, 240));
                        Color.b(color, (byte)raylib_h.GetRandomValue(100, 240));
                        Color.a(color, (byte)-1);
                        bunnies[bunniesCount].color = color;
                        bunniesText = arena.allocateFrom("Bunnies: " + ++bunniesCount);
                    }
                }
                for (i = 0; i < bunniesCount; ++i) {
                    bunnies[i].position.x += bunnies[i].speed.x;
                    bunnies[i].position.y += bunnies[i].speed.y;
                    if ((double)bunnies[i].position.x + (double)width / 2.0 > (double)screenWidth || (double)bunnies[i].position.x + (double)width / 2.0 < 0.0) {
                        bunnies[i].speed.x *= -1.0f;
                    }
                    if (!((double)bunnies[i].position.y + (double)height / 2.0 > (double)screenHeight) && !((double)bunnies[i].position.y + (double)height / 2.0 - 40.0 < 0.0)) continue;
                    bunnies[i].speed.y *= -1.0f;
                }
                raylib_h.BeginDrawing();
                raylib_h.ClearBackground(white);
                for (i = 0; i < bunniesCount; ++i) {
                    raylib_h.DrawTexture(texBunny, (int)bunnies[i].position.x, (int)bunnies[i].position.y, bunnies[i].color);
                }
                raylib_h.DrawRectangle(0, 0, screenWidth, 40, black);
                raylib_h.DrawText(bunniesText, 120, 10, 20, white);
                raylib_h.DrawFPS(10, 10);
                raylib_h.EndDrawing();
            }
            raylib_h.UnloadTexture(texBunny);
            raylib_h.CloseWindow();
        }
    }

    static class Bunny {
        Vec2 position = new Vec2();
        Vec2 speed = new Vec2();
        MemorySegment color = null;

        Bunny() {
        }
    }

    static class Vec2 {
        float x;
        float y;

        Vec2() {
        }
    }

    static class Col {
        int r;
        int g;
        int b;
        int a;

        Col() {
        }
    }
}

