/*
 * Decompiled with CFR 0.152.
 */
package uk.co.electronstudio.tests;

import com.raylib.Camera3D;
import com.raylib.Image;
import com.raylib.MaterialMap;
import com.raylib.Mesh;
import com.raylib.Model;
import com.raylib.Raylib;
import com.raylib.Texture;
import com.raylib.Vector3;
import com.raylib.jextract.raylib_h;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;

public class TestMaterials {
    public static void main(String[] args) {
        Raylib.initWindow(800, 450, "Hello world");
        Raylib.setTargetFPS(60);
        System.out.println("RLGL TEST: " + raylib_h.rlGetVersion());
        System.out.println("" + ValueLayout.JAVA_INT.byteSize());
        FloatBuffer fb = FloatBuffer.allocate(1);
        IntBuffer bb = ByteBuffer.allocateDirect((int)ValueLayout.JAVA_INT.byteSize()).order(ByteOrder.nativeOrder()).asIntBuffer();
        byte[] ba = new byte[4];
        IntBuffer ib = Raylib.createIntBuffer(1);
        System.out.printf("filesize " + ib.get(0), new Object[0]);
        ByteBuffer txt = Raylib.loadFileText("README.md");
        txt.limit(100);
        System.out.println(StandardCharsets.UTF_8.decode(txt).toString());
        Camera3D camera = new Camera3D(new Vector3(18.0f, 16.0f, 18.0f), new Vector3(), new Vector3(0.0f, 1.0f, 0.0f), 45.0f, 0);
        Image image = Raylib.loadImage("heightmap.png");
        Texture texture = Raylib.loadTextureFromImage(image);
        Mesh mesh = Raylib.genMeshHeightmap(image, new Vector3(16.0f, 8.0f, 16.0f));
        Model model = Raylib.loadModelFromMesh(mesh);
        MaterialMap matmap = model.getMaterials().getArrayElement(0).maps().getArrayElement(0);
        matmap.setTexture(texture);
        Raylib.unloadImage(image);
        while (!Raylib.windowShouldClose()) {
            Raylib.updateCamera(camera, 2);
            Raylib.beginDrawing();
            Raylib.clearBackground(Raylib.RAYWHITE);
            Raylib.beginMode3D(camera);
            Raylib.drawModel(model, new Vector3(-8.0f, 0.0f, -8.0f), 1.0f, Raylib.RED);
            Raylib.drawGrid(20, 1.0f);
            Raylib.endMode3D();
            Raylib.drawText("Hello world", 190, 200, 20, Raylib.VIOLET);
            Raylib.drawFPS(20, 20);
            Raylib.endDrawing();
        }
        Raylib.closeWindow();
    }
}

