/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service;

import coco4j.MoreExecutors;
import elf4j.engine.service.LogEvent;
import elf4j.engine.service.LogEventProcessor;
import elf4j.engine.service.LogServiceManager;
import elf4j.engine.service.configuration.LogServiceConfiguration;
import elf4j.engine.service.util.PropertiesUtils;
import elf4j.engine.service.writer.LogWriter;
import elf4j.util.IeLogger;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;

public class BufferedLogEventProcessor
implements LogEventProcessor {
    private static final int DEFAULT_FRONT_BUFFER_CAPACITY = Integer.MAX_VALUE;
    private final LogWriter logWriter;
    private final ExecutorService bufferedExecutor;

    private BufferedLogEventProcessor(LogWriter logWriter, ExecutorService bufferedExecutor) {
        this.logWriter = logWriter;
        this.bufferedExecutor = bufferedExecutor;
        LogServiceManager.INSTANCE.registerStop(this);
    }

    @NonNull
    public static BufferedLogEventProcessor from(@NonNull LogServiceConfiguration logServiceConfiguration) {
        if (logServiceConfiguration == null) {
            throw new NullPointerException("logServiceConfiguration is marked non-null but is null");
        }
        return new BufferedLogEventProcessor(logServiceConfiguration.getLogServiceWriter(), MoreExecutors.newSingleThreadBlockingResubmitExecutor((int)BufferedLogEventProcessor.getWorkQueueCapacity(logServiceConfiguration.getProperties())));
    }

    private static int getWorkQueueCapacity(Properties properties) {
        int bufferCapacity = PropertiesUtils.getIntOrDefault("buffer", properties, Integer.MAX_VALUE);
        IeLogger.INFO.log("Buffer: {}", new Object[]{bufferCapacity});
        if (bufferCapacity < 1) {
            IeLogger.ERROR.log("Unexpected buffer: {}, cannot be less than 1", new Object[]{bufferCapacity});
            throw new IllegalArgumentException("buffer: " + bufferCapacity);
        }
        return bufferCapacity;
    }

    @Override
    public void process(LogEvent logEvent) {
        this.bufferedExecutor.execute(() -> this.logWriter.write(logEvent));
    }

    @Override
    public void stop() {
        IeLogger.INFO.log("Stopping: {}", new Object[]{this});
        this.bufferedExecutor.shutdown();
    }

    @Override
    public boolean isStopped() {
        return this.bufferedExecutor.isTerminated();
    }
}

