/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service;

import elf4j.engine.NativeLogger;
import elf4j.engine.service.LogEvent;
import elf4j.engine.service.LogService;
import elf4j.engine.service.configuration.LogServiceConfiguration;
import elf4j.engine.service.configuration.RefreshableLogServiceConfiguration;
import lombok.NonNull;

public class EventingLogService
implements LogService {
    private final LogServiceConfiguration logServiceConfiguration;

    public EventingLogService() {
        this(new RefreshableLogServiceConfiguration());
    }

    EventingLogService(LogServiceConfiguration logServiceConfiguration) {
        this.logServiceConfiguration = logServiceConfiguration;
    }

    @Override
    public boolean includeCallerDetail() {
        return this.logServiceConfiguration.getLogServiceWriter().includeCallerDetail();
    }

    @Override
    public boolean includeCallerThread() {
        return this.logServiceConfiguration.getLogServiceWriter().includeCallerThread();
    }

    @Override
    public boolean isEnabled(NativeLogger nativeLogger) {
        return this.logServiceConfiguration.isEnabled(nativeLogger);
    }

    @Override
    public void log(@NonNull NativeLogger nativeLogger, @NonNull Class<?> serviceInterfaceClass, Throwable throwable, Object message, Object[] arguments) {
        if (nativeLogger == null) {
            throw new NullPointerException("nativeLogger is marked non-null but is null");
        }
        if (serviceInterfaceClass == null) {
            throw new NullPointerException("serviceInterfaceClass is marked non-null but is null");
        }
        if (!this.logServiceConfiguration.isEnabled(nativeLogger)) {
            return;
        }
        LogEvent.LogEventBuilder logEventBuilder = LogEvent.builder().nativeLogger(nativeLogger).throwable(throwable).message(message).arguments(arguments);
        if (this.includeCallerDetail()) {
            logEventBuilder.callerStack(new Throwable().getStackTrace()).serviceInterfaceClass(serviceInterfaceClass);
        }
        Thread callerThread = Thread.currentThread();
        logEventBuilder.callerThread(new LogEvent.ThreadValue(callerThread.getName(), callerThread.getId()));
        this.logServiceConfiguration.getLogEventProcessor().process(logEventBuilder.build());
    }
}

