/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service;

import elf4j.engine.NativeLogger;
import elf4j.engine.service.util.StackTraceUtils;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class LogEvent {
    private static final int ADDITIONAL_STRING_BUILDER_CAPACITY = 32;
    @NonNull
    private final NativeLogger nativeLogger;
    @NonNull
    private final ThreadValue callerThread;
    @NonNull
    private final Instant timestamp = Instant.now();
    @Nullable
    private final Object message;
    @Nullable
    private final Object[] arguments;
    @Nullable
    private final Throwable throwable;
    @Nullable
    private final Class<?> serviceInterfaceClass;
    @Nullable
    private final StackTraceElement[] callerStack;

    @NonNull
    private static CharSequence resolve(Object message, Object[] arguments) {
        String suppliedMessage = Objects.toString(LogEvent.supply(message), "");
        if (arguments == null || arguments.length == 0) {
            return suppliedMessage;
        }
        int messageLength = suppliedMessage.length();
        StringBuilder resolved = new StringBuilder(messageLength + 32);
        int i = 0;
        int j = 0;
        while (i < messageLength) {
            char character = suppliedMessage.charAt(i);
            if (character == '{' && i + 1 < messageLength && suppliedMessage.charAt(i + 1) == '}' && j < arguments.length) {
                resolved.append(LogEvent.supply(arguments[j++]));
                i += 2;
                continue;
            }
            resolved.append(character);
            ++i;
        }
        return resolved;
    }

    @Nullable
    private static Object supply(@Nullable Object o) {
        return o instanceof Supplier ? ((Supplier)o).get() : o;
    }

    public String getCallerClassName() {
        return this.callerStack != null ? this.getCallerFrame().getClassName() : this.nativeLogger.getOwnerClassName();
    }

    public CharSequence getResolvedMessage() {
        return LogEvent.resolve(this.message, this.arguments);
    }

    public StackFrameValue getCallerDetail() {
        StackTraceElement callerFrame = this.getCallerFrame();
        return StackFrameValue.builder().className(callerFrame.getClassName()).fileName(callerFrame.getFileName()).methodName(callerFrame.getMethodName()).lineNumber(callerFrame.getLineNumber()).build();
    }

    private StackTraceElement getCallerFrame() {
        return StackTraceUtils.getCallerFrame(Objects.requireNonNull(this.serviceInterfaceClass), Objects.requireNonNull(this.callerStack));
    }

    LogEvent(@NonNull NativeLogger nativeLogger, @NonNull ThreadValue callerThread, @Nullable Object message, @Nullable Object[] arguments, @Nullable Throwable throwable, @Nullable Class<?> serviceInterfaceClass, @Nullable StackTraceElement[] callerStack) {
        if (nativeLogger == null) {
            throw new NullPointerException("nativeLogger is marked non-null but is null");
        }
        if (callerThread == null) {
            throw new NullPointerException("callerThread is marked non-null but is null");
        }
        this.nativeLogger = nativeLogger;
        this.callerThread = callerThread;
        this.message = message;
        this.arguments = arguments;
        this.throwable = throwable;
        this.serviceInterfaceClass = serviceInterfaceClass;
        this.callerStack = callerStack;
    }

    public static LogEventBuilder builder() {
        return new LogEventBuilder();
    }

    @NonNull
    public NativeLogger getNativeLogger() {
        return this.nativeLogger;
    }

    @NonNull
    public ThreadValue getCallerThread() {
        return this.callerThread;
    }

    @NonNull
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public Object getMessage() {
        return this.message;
    }

    @Nullable
    public Object[] getArguments() {
        return this.arguments;
    }

    @Nullable
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Nullable
    public Class<?> getServiceInterfaceClass() {
        return this.serviceInterfaceClass;
    }

    @Nullable
    public StackTraceElement[] getCallerStack() {
        return this.callerStack;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogEvent)) {
            return false;
        }
        LogEvent other = (LogEvent)o;
        NativeLogger this$nativeLogger = this.getNativeLogger();
        NativeLogger other$nativeLogger = other.getNativeLogger();
        if (this$nativeLogger == null ? other$nativeLogger != null : !this$nativeLogger.equals(other$nativeLogger)) {
            return false;
        }
        ThreadValue this$callerThread = this.getCallerThread();
        ThreadValue other$callerThread = other.getCallerThread();
        if (this$callerThread == null ? other$callerThread != null : !((Object)this$callerThread).equals(other$callerThread)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Object this$message = this.getMessage();
        Object other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArguments(), other.getArguments())) {
            return false;
        }
        Throwable this$throwable = this.getThrowable();
        Throwable other$throwable = other.getThrowable();
        if (this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable)) {
            return false;
        }
        Class<?> this$serviceInterfaceClass = this.getServiceInterfaceClass();
        Class<?> other$serviceInterfaceClass = other.getServiceInterfaceClass();
        if (this$serviceInterfaceClass == null ? other$serviceInterfaceClass != null : !this$serviceInterfaceClass.equals(other$serviceInterfaceClass)) {
            return false;
        }
        return Arrays.deepEquals(this.getCallerStack(), other.getCallerStack());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NativeLogger $nativeLogger = this.getNativeLogger();
        result = result * 59 + ($nativeLogger == null ? 43 : $nativeLogger.hashCode());
        ThreadValue $callerThread = this.getCallerThread();
        result = result * 59 + ($callerThread == null ? 43 : ((Object)$callerThread).hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Object $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArguments());
        Throwable $throwable = this.getThrowable();
        result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
        Class<?> $serviceInterfaceClass = this.getServiceInterfaceClass();
        result = result * 59 + ($serviceInterfaceClass == null ? 43 : $serviceInterfaceClass.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCallerStack());
        return result;
    }

    public String toString() {
        return "LogEvent(nativeLogger=" + this.getNativeLogger() + ", callerThread=" + this.getCallerThread() + ", timestamp=" + this.getTimestamp() + ", message=" + this.getMessage() + ", arguments=" + Arrays.deepToString(this.getArguments()) + ", throwable=" + this.getThrowable() + ", serviceInterfaceClass=" + this.getServiceInterfaceClass() + ", callerStack=" + Arrays.deepToString(this.getCallerStack()) + ")";
    }

    public static class LogEventBuilder {
        private NativeLogger nativeLogger;
        private ThreadValue callerThread;
        private Object message;
        private Object[] arguments;
        private Throwable throwable;
        private Class<?> serviceInterfaceClass;
        private StackTraceElement[] callerStack;

        LogEventBuilder() {
        }

        public LogEventBuilder nativeLogger(@NonNull NativeLogger nativeLogger) {
            if (nativeLogger == null) {
                throw new NullPointerException("nativeLogger is marked non-null but is null");
            }
            this.nativeLogger = nativeLogger;
            return this;
        }

        public LogEventBuilder callerThread(@NonNull ThreadValue callerThread) {
            if (callerThread == null) {
                throw new NullPointerException("callerThread is marked non-null but is null");
            }
            this.callerThread = callerThread;
            return this;
        }

        public LogEventBuilder message(@Nullable Object message) {
            this.message = message;
            return this;
        }

        public LogEventBuilder arguments(@Nullable Object[] arguments) {
            this.arguments = arguments;
            return this;
        }

        public LogEventBuilder throwable(@Nullable Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        public LogEventBuilder serviceInterfaceClass(@Nullable Class<?> serviceInterfaceClass) {
            this.serviceInterfaceClass = serviceInterfaceClass;
            return this;
        }

        public LogEventBuilder callerStack(@Nullable StackTraceElement[] callerStack) {
            this.callerStack = callerStack;
            return this;
        }

        public LogEvent build() {
            return new LogEvent(this.nativeLogger, this.callerThread, this.message, this.arguments, this.throwable, this.serviceInterfaceClass, this.callerStack);
        }

        public String toString() {
            return "LogEvent.LogEventBuilder(nativeLogger=" + this.nativeLogger + ", callerThread=" + this.callerThread + ", message=" + this.message + ", arguments=" + Arrays.deepToString(this.arguments) + ", throwable=" + this.throwable + ", serviceInterfaceClass=" + this.serviceInterfaceClass + ", callerStack=" + Arrays.deepToString(this.callerStack) + ")";
        }
    }

    public static final class ThreadValue {
        @NonNull
        private final String name;
        private final long id;

        ThreadValue(@NonNull String name, long id) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            this.id = id;
        }

        public static ThreadValueBuilder builder() {
            return new ThreadValueBuilder();
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        public long getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadValue)) {
                return false;
            }
            ThreadValue other = (ThreadValue)o;
            if (this.getId() != other.getId()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "LogEvent.ThreadValue(name=" + this.getName() + ", id=" + this.getId() + ")";
        }

        public static class ThreadValueBuilder {
            private String name;
            private long id;

            ThreadValueBuilder() {
            }

            public ThreadValueBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            public ThreadValueBuilder id(long id) {
                this.id = id;
                return this;
            }

            public ThreadValue build() {
                return new ThreadValue(this.name, this.id);
            }

            public String toString() {
                return "LogEvent.ThreadValue.ThreadValueBuilder(name=" + this.name + ", id=" + this.id + ")";
            }
        }
    }

    public static final class StackFrameValue {
        @NonNull
        private final String className;
        @NonNull
        private final String methodName;
        private final int lineNumber;
        @Nullable
        private final String fileName;

        StackFrameValue(@NonNull String className, @NonNull String methodName, int lineNumber, @Nullable String fileName) {
            if (className == null) {
                throw new NullPointerException("className is marked non-null but is null");
            }
            if (methodName == null) {
                throw new NullPointerException("methodName is marked non-null but is null");
            }
            this.className = className;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
            this.fileName = fileName;
        }

        public static StackFrameValueBuilder builder() {
            return new StackFrameValueBuilder();
        }

        @NonNull
        public String getClassName() {
            return this.className;
        }

        @NonNull
        public String getMethodName() {
            return this.methodName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        @Nullable
        public String getFileName() {
            return this.fileName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StackFrameValue)) {
                return false;
            }
            StackFrameValue other = (StackFrameValue)o;
            if (this.getLineNumber() != other.getLineNumber()) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            return !(this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLineNumber();
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            return result;
        }

        public String toString() {
            return "LogEvent.StackFrameValue(className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ", lineNumber=" + this.getLineNumber() + ", fileName=" + this.getFileName() + ")";
        }

        public static class StackFrameValueBuilder {
            private String className;
            private String methodName;
            private int lineNumber;
            private String fileName;

            StackFrameValueBuilder() {
            }

            public StackFrameValueBuilder className(@NonNull String className) {
                if (className == null) {
                    throw new NullPointerException("className is marked non-null but is null");
                }
                this.className = className;
                return this;
            }

            public StackFrameValueBuilder methodName(@NonNull String methodName) {
                if (methodName == null) {
                    throw new NullPointerException("methodName is marked non-null but is null");
                }
                this.methodName = methodName;
                return this;
            }

            public StackFrameValueBuilder lineNumber(int lineNumber) {
                this.lineNumber = lineNumber;
                return this;
            }

            public StackFrameValueBuilder fileName(@Nullable String fileName) {
                this.fileName = fileName;
                return this;
            }

            public StackFrameValue build() {
                return new StackFrameValue(this.className, this.methodName, this.lineNumber, this.fileName);
            }

            public String toString() {
                return "LogEvent.StackFrameValue.StackFrameValueBuilder(className=" + this.className + ", methodName=" + this.methodName + ", lineNumber=" + this.lineNumber + ", fileName=" + this.fileName + ")";
            }
        }
    }
}

