/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service;

import elf4j.engine.service.Stoppable;
import elf4j.engine.service.configuration.Refreshable;
import elf4j.util.IeLogger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;

public enum LogServiceManager {
    INSTANCE;

    private static final List<Class<? extends Stoppable>> ORDERED_STOPPABLE_TYPES;
    private final Set<Refreshable> refreshables = new HashSet<Refreshable>();
    private final Set<Stoppable> stoppables = new HashSet<Stoppable>();
    private final ConditionFactory await = Awaitility.await().forever();

    private static boolean allStopped(@NonNull Collection<Stoppable> stoppables) {
        if (stoppables == null) {
            throw new NullPointerException("stoppables is marked non-null but is null");
        }
        return stoppables.stream().allMatch(Stoppable::isStopped);
    }

    public void registerRefresh(Refreshable refreshable) {
        this.refreshables.add(refreshable);
    }

    public void registerStop(Stoppable stoppable) {
        this.stoppables.add(stoppable);
    }

    public void refresh() {
        IeLogger.INFO.log((Object)"Refreshing elf4j service by reloading properties...");
        this.refreshables.forEach(Refreshable::refresh);
        IeLogger.INFO.log((Object)"Refreshed elf4j service by reloading properties");
    }

    public void refresh(Properties properties) {
        IeLogger.INFO.log("Refreshing elf4j service with given properties: {}...", new Object[]{properties});
        this.refreshables.forEach(refreshable -> refreshable.refresh(properties));
        IeLogger.INFO.log("Refreshed elf4j service with given properties: {}", new Object[]{properties});
    }

    public void stop() {
        IeLogger.INFO.log((Object)"Stopping elf4j service...");
        ORDERED_STOPPABLE_TYPES.forEach(this::awaitStop);
        IeLogger.INFO.log((Object)"Stopped elf4j service");
    }

    @NonNull
    public Thread getShutdownHookThread() {
        return new Thread(this::stop);
    }

    private void awaitStop(Class<? extends Stoppable> targetType) {
        List stopTargets = this.stoppables.stream().filter(targetType::isInstance).collect(Collectors.toList());
        ((Stream)stopTargets.stream().parallel()).forEach(Stoppable::stop);
        this.await.until(() -> LogServiceManager.allStopped(stopTargets));
    }

    static {
        ORDERED_STOPPABLE_TYPES = Arrays.asList(Stoppable.Intake.class, Stoppable.Process.class, Stoppable.Output.class);
    }
}

