/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.configuration;

import elf4j.Level;
import elf4j.engine.NativeLogger;
import elf4j.util.IeLogger;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.NonNull;

public class CallerLevels {
    private static final Level DEFAULT_CALLER_MINIMUM_OUTPUT_LEVEL = Level.TRACE;
    private static final String ROOT_CLASS_NAME_SPACE = "";
    private final Map<String, Level> configuredLevels;
    private final List<String> sortedCallerClassNameSpaces;

    private CallerLevels(@NonNull Map<String, Level> configuredLevels) {
        if (configuredLevels == null) {
            throw new NullPointerException("configuredLevels is marked non-null but is null");
        }
        this.configuredLevels = new ConcurrentHashMap<String, Level>(configuredLevels);
        this.sortedCallerClassNameSpaces = configuredLevels.keySet().stream().sorted(Comparator.comparingInt(String::length).reversed()).collect(Collectors.toList());
    }

    @NonNull
    static CallerLevels from(@NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        HashMap<String, Level> configuredLevels = new HashMap<String, Level>();
        CallerLevels.getAsLevel("level", properties).ifPresent(level -> configuredLevels.put(ROOT_CLASS_NAME_SPACE, (Level)level));
        configuredLevels.putAll(properties.stringPropertyNames().stream().filter(name -> name.trim().startsWith("level@")).collect(Collectors.toMap(name -> name.split("@", 2)[1].trim(), name -> CallerLevels.getAsLevel(name, properties).orElseThrow(NoSuchElementException::new))));
        IeLogger.INFO.log("{} caller class output level(s): {}", new Object[]{configuredLevels.size(), configuredLevels});
        return new CallerLevels(configuredLevels);
    }

    private static Optional<Level> getAsLevel(String levelKey, @NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        String levelValue = properties.getProperty(levelKey);
        return levelValue == null ? Optional.empty() : Optional.of(Level.valueOf((String)levelValue.trim().toUpperCase()));
    }

    public Level getCallerMinimumOutputLevel(NativeLogger nativeLogger) {
        return this.sortedCallerClassNameSpaces.stream().filter(classNameSpace -> nativeLogger.getOwnerClassName().startsWith((String)classNameSpace)).findFirst().map(this.configuredLevels::get).orElse(DEFAULT_CALLER_MINIMUM_OUTPUT_LEVEL);
    }
}

