/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.configuration;

import elf4j.engine.service.configuration.PropertiesLoader;
import elf4j.util.IeLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nullable;

public class FilePropertiesLoader
implements PropertiesLoader {
    public static final String ELF4J_PROPERTIES_LOCATION = "elf4j.properties.location";
    private static final String[] DEFAULT_PROPERTIES_LOCATIONS = new String[]{"/elf4j-test.properties", "/elf4j.properties"};

    @Override
    @Nullable
    public Properties load() {
        InputStream propertiesInputStream;
        Properties properties = new Properties();
        String customPropertiesLocation = System.getProperty(ELF4J_PROPERTIES_LOCATION);
        if (customPropertiesLocation == null) {
            propertiesInputStream = this.fromDefaultPropertiesLocation();
            if (propertiesInputStream == null) {
                IeLogger.WARN.log((Object)"No configuration file located");
                return null;
            }
        } else {
            propertiesInputStream = this.getClass().getResourceAsStream(customPropertiesLocation);
            if (propertiesInputStream == null) {
                throw new IllegalArgumentException("Null resource stream from specified properties location: " + customPropertiesLocation);
            }
        }
        try {
            properties.load(propertiesInputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error loading properties stream from location: " + (customPropertiesLocation == null ? "default location" : customPropertiesLocation), e);
        }
        return properties;
    }

    private InputStream fromDefaultPropertiesLocation() {
        return Arrays.stream(DEFAULT_PROPERTIES_LOCATIONS).map(location -> this.getClass().getResourceAsStream((String)location)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

