/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.configuration;

import elf4j.Level;
import elf4j.engine.NativeLogger;
import elf4j.engine.service.BufferedLogEventProcessor;
import elf4j.engine.service.LogEventProcessor;
import elf4j.engine.service.LogServiceManager;
import elf4j.engine.service.configuration.CallerLevels;
import elf4j.engine.service.configuration.FilePropertiesLoader;
import elf4j.engine.service.configuration.LogServiceConfiguration;
import elf4j.engine.service.configuration.PropertiesLoader;
import elf4j.engine.service.configuration.Refreshable;
import elf4j.engine.service.writer.ConseqWriterGroup;
import elf4j.engine.service.writer.FileStreamStandardOutput;
import elf4j.engine.service.writer.LogWriter;
import elf4j.engine.service.writer.StandardOutput;
import elf4j.util.IeLogger;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class RefreshableLogServiceConfiguration
implements LogServiceConfiguration,
Refreshable {
    private final PropertiesLoader propertiesLoader;
    private Properties properties;
    private boolean noop;
    private CallerLevels callerLevels;
    private Map<NativeLogger, Boolean> loggerEnablementCache;
    private StandardOutput standardOutput;
    private LogWriter logServiceWriter;
    private LogEventProcessor logEventProcessor;

    public RefreshableLogServiceConfiguration() {
        this(new FilePropertiesLoader());
    }

    RefreshableLogServiceConfiguration(PropertiesLoader propertiesLoader) {
        this.propertiesLoader = propertiesLoader;
        this.properties = this.propertiesLoader.load();
        this.parse(this.properties);
        LogServiceManager.INSTANCE.registerRefresh(this);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public LogWriter getLogServiceWriter() {
        return this.logServiceWriter;
    }

    @Override
    public boolean isEnabled(NativeLogger nativeLogger) {
        if (this.noop) {
            return false;
        }
        return this.loggerEnablementCache.computeIfAbsent(nativeLogger, this::loadLoggerConfigurationCache);
    }

    @Override
    public StandardOutput getStandardOutput() {
        return this.standardOutput;
    }

    @Override
    public LogEventProcessor getLogEventProcessor() {
        return this.logEventProcessor;
    }

    @Override
    public void refresh(@Nullable Properties properties) {
        this.properties = properties == null ? this.propertiesLoader.load() : properties;
        this.parse(this.properties);
    }

    private boolean loadLoggerConfigurationCache(NativeLogger nativeLogger) {
        Level callerMinimumOutputLevel = this.callerLevels.getCallerMinimumOutputLevel(nativeLogger);
        Level writerMinimumOutputLevel = this.logServiceWriter.getMinimumOutputLevel();
        Level loggerLevel = nativeLogger.getLevel();
        return loggerLevel.compareTo((Enum)callerMinimumOutputLevel) >= 0 && loggerLevel.compareTo((Enum)writerMinimumOutputLevel) >= 0;
    }

    private void parse(@Nullable Properties properties) {
        IeLogger.INFO.log("Configuration properties: {}", new Object[]{properties});
        if (properties == null) {
            IeLogger.WARN.log((Object)"No-op as in no configuration");
            this.noop = true;
            return;
        }
        this.noop = Boolean.parseBoolean(properties.getProperty("noop"));
        if (this.noop) {
            IeLogger.WARN.log((Object)"No-op as configured");
            return;
        }
        this.callerLevels = CallerLevels.from(properties);
        this.loggerEnablementCache = new ConcurrentHashMap<NativeLogger, Boolean>();
        this.standardOutput = new FileStreamStandardOutput();
        this.logServiceWriter = ConseqWriterGroup.from(this);
        this.logEventProcessor = BufferedLogEventProcessor.from(this);
    }

    public String toString() {
        return "RefreshableLogServiceConfiguration(propertiesLoader=" + this.propertiesLoader + ", properties=" + this.getProperties() + ", noop=" + this.noop + ", callerLevels=" + this.callerLevels + ", loggerEnablementCache=" + this.loggerEnablementCache + ", standardOutput=" + this.getStandardOutput() + ", logServiceWriter=" + this.getLogServiceWriter() + ", logEventProcessor=" + this.getLogEventProcessor() + ")";
    }
}

