/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.LogPattern;
import elf4j.engine.service.pattern.PatternType;
import elf4j.engine.service.writer.PerformanceSensitive;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class PatternGroup
implements LogPattern {
    private final List<LogPattern> patterns;

    @Nonnull
    public static PatternGroup from(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return new PatternGroup(PatternType.parsePatterns(pattern));
    }

    @Override
    public boolean includeCallerDetail() {
        return this.patterns.stream().anyMatch(PerformanceSensitive::includeCallerDetail);
    }

    @Override
    public boolean includeCallerThread() {
        return this.patterns.stream().anyMatch(PerformanceSensitive::includeCallerThread);
    }

    @Override
    public void render(LogEvent logEvent, StringBuilder target) {
        for (LogPattern pattern : this.patterns) {
            pattern.render(logEvent, target);
        }
    }

    public PatternGroup(List<LogPattern> patterns) {
        this.patterns = patterns;
    }

    public List<LogPattern> getPatterns() {
        return this.patterns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatternGroup)) {
            return false;
        }
        PatternGroup other = (PatternGroup)o;
        List<LogPattern> this$patterns = this.getPatterns();
        List<LogPattern> other$patterns = other.getPatterns();
        return !(this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<LogPattern> $patterns = this.getPatterns();
        result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
        return result;
    }

    public String toString() {
        return "PatternGroup(patterns=" + this.getPatterns() + ")";
    }
}

