/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.LogPattern;
import elf4j.engine.service.pattern.PatternType;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public final class SystemPropertyPattern
implements LogPattern {
    private final String key;

    private SystemPropertyPattern(String key) {
        this.key = key;
    }

    @Nonnull
    public static SystemPropertyPattern from(String patternSegment) {
        if (!PatternType.SYSPROP.isTargetTypeOf(patternSegment)) {
            throw new IllegalArgumentException("patternSegment: " + patternSegment);
        }
        return new SystemPropertyPattern(PatternType.getPatternDisplayOption(patternSegment).orElseThrow(NoSuchElementException::new));
    }

    @Override
    public void render(LogEvent logEvent, StringBuilder target) {
        target.append(System.getProperty(this.key));
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @Override
    public boolean includeCallerThread() {
        return false;
    }

    public String getKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemPropertyPattern)) {
            return false;
        }
        SystemPropertyPattern other = (SystemPropertyPattern)o;
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    public String toString() {
        return "SystemPropertyPattern(key=" + this.getKey() + ")";
    }
}

