/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.LogPattern;
import elf4j.engine.service.pattern.PatternType;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class TimestampPattern
implements LogPattern {
    private static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static final ZoneId DISPLAY_TIME_ZONE = ZoneId.systemDefault();
    private final DateTimeFormatter dateTimeFormatter;

    @Nonnull
    public static TimestampPattern from(@NonNull String patternSegment) {
        if (patternSegment == null) {
            throw new NullPointerException("patternSegment is marked non-null but is null");
        }
        if (!PatternType.TIMESTAMP.isTargetTypeOf(patternSegment)) {
            throw new IllegalArgumentException("patternSegment: " + patternSegment);
        }
        return new TimestampPattern(DateTimeFormatter.ofPattern(PatternType.getPatternDisplayOption(patternSegment).orElse(DEFAULT_DATETIME_PATTERN)).withZone(DISPLAY_TIME_ZONE));
    }

    public String toString() {
        return "TimestampPattern{sample=" + this.dateTimeFormatter.format(Instant.now()) + '}';
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @Override
    public boolean includeCallerThread() {
        return false;
    }

    @Override
    public void render(@NonNull LogEvent logEvent, @NonNull StringBuilder target) {
        if (logEvent == null) {
            throw new NullPointerException("logEvent is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.dateTimeFormatter.formatTo(logEvent.getTimestamp(), target);
    }

    public TimestampPattern(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimestampPattern)) {
            return false;
        }
        TimestampPattern other = (TimestampPattern)o;
        DateTimeFormatter this$dateTimeFormatter = this.getDateTimeFormatter();
        DateTimeFormatter other$dateTimeFormatter = other.getDateTimeFormatter();
        return !(this$dateTimeFormatter == null ? other$dateTimeFormatter != null : !this$dateTimeFormatter.equals(other$dateTimeFormatter));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DateTimeFormatter $dateTimeFormatter = this.getDateTimeFormatter();
        result = result * 59 + ($dateTimeFormatter == null ? 43 : $dateTimeFormatter.hashCode());
        return result;
    }
}

