/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.writer;

import coco4j.MoreRejectedExecutionHandlers;
import conseq4j.execute.ConseqExecutor;
import elf4j.Level;
import elf4j.engine.service.LogEvent;
import elf4j.engine.service.LogServiceManager;
import elf4j.engine.service.Stoppable;
import elf4j.engine.service.configuration.LogServiceConfiguration;
import elf4j.engine.service.util.PropertiesUtils;
import elf4j.engine.service.writer.LogWriter;
import elf4j.engine.service.writer.PerformanceSensitive;
import elf4j.engine.service.writer.StandardStreamsWriter;
import elf4j.util.IeLogger;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.NonNull;

public class ConseqWriterGroup
implements LogWriter,
Stoppable.Process {
    private static final int DEFAULT_CONSEQ_CONCURRENCY = Runtime.getRuntime().availableProcessors();
    private final List<LogWriter> writers;
    private final ConseqExecutor conseqExecutor;
    private Level minimumLevel;
    private Boolean includeCallerDetail;
    private Boolean includeCallerThread;

    private ConseqWriterGroup(List<LogWriter> writers, ConseqExecutor conseqExecutor) {
        this.writers = writers;
        this.conseqExecutor = conseqExecutor;
        LogServiceManager.INSTANCE.registerStop(this);
    }

    @NonNull
    public static ConseqWriterGroup from(LogServiceConfiguration logServiceConfiguration) {
        ArrayList<LogWriter.TypedLogWriterFactory> typedLogWriterFactories = new ArrayList<LogWriter.TypedLogWriterFactory>(ConseqWriterGroup.getTypedLogWriterFactories(logServiceConfiguration));
        if (typedLogWriterFactories.isEmpty()) {
            typedLogWriterFactories.add(new StandardStreamsWriter.StandardStreamsWriterFactory());
        }
        List<LogWriter> logWriters = typedLogWriterFactories.stream().flatMap(t -> t.getLogWriters(logServiceConfiguration).stream()).collect(Collectors.toList());
        IeLogger.INFO.log("{} service writer(s): {}", new Object[]{logWriters.size(), logWriters});
        Properties properties = logServiceConfiguration.getProperties();
        return new ConseqWriterGroup(logWriters, new ConseqExecutor.Builder().concurrency(ConseqWriterGroup.getConcurrency(properties)).rejectedExecutionHandler(MoreRejectedExecutionHandlers.blockingResubmitPolicy()).build());
    }

    private static int getConcurrency(Properties properties) {
        int concurrency = PropertiesUtils.getIntOrDefault("concurrency", properties, DEFAULT_CONSEQ_CONCURRENCY);
        IeLogger.INFO.log("Concurrency: {}", new Object[]{concurrency});
        if (concurrency < 1) {
            IeLogger.ERROR.log("Unexpected concurrency: {}, cannot be less than 1", new Object[]{concurrency});
            throw new IllegalArgumentException("concurrency: " + concurrency);
        }
        return concurrency;
    }

    private static List<LogWriter.TypedLogWriterFactory> getTypedLogWriterFactories(@NonNull LogServiceConfiguration logServiceConfiguration) {
        if (logServiceConfiguration == null) {
            throw new NullPointerException("logServiceConfiguration is marked non-null but is null");
        }
        String writerTypes = logServiceConfiguration.getProperties().getProperty("writer.types");
        if (writerTypes == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(writerTypes.split(",")).map(String::trim).map(fqcn -> {
            try {
                return (LogWriter.TypedLogWriterFactory)Class.forName(fqcn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException((String)fqcn, e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public Level getMinimumOutputLevel() {
        if (this.minimumLevel == null) {
            this.minimumLevel = Level.values()[this.writers.stream().mapToInt(writer -> writer.getMinimumOutputLevel().ordinal()).min().orElseThrow(NoSuchElementException::new)];
        }
        return this.minimumLevel;
    }

    @Override
    public void write(LogEvent logEvent) {
        this.conseqExecutor.execute(() -> this.writers.parallelStream().forEach(writer -> writer.write(logEvent)), (Object)logEvent.getCallerThread().getId());
    }

    @Override
    public boolean includeCallerDetail() {
        if (this.includeCallerDetail == null) {
            this.includeCallerDetail = this.writers.stream().anyMatch(PerformanceSensitive::includeCallerDetail);
        }
        return this.includeCallerDetail;
    }

    @Override
    public boolean includeCallerThread() {
        if (this.includeCallerThread == null) {
            this.includeCallerThread = this.writers.stream().anyMatch(PerformanceSensitive::includeCallerThread);
        }
        return this.includeCallerThread;
    }

    @Override
    public void stop() {
        IeLogger.INFO.log("Stopping: {}", new Object[]{this});
        this.conseqExecutor.shutdown();
    }

    @Override
    public boolean isStopped() {
        return this.conseqExecutor.isTerminated();
    }

    public String toString() {
        return "ConseqWriterGroup(writers=" + this.writers + ", conseqExecutor=" + this.conseqExecutor + ", minimumLevel=" + this.minimumLevel + ")";
    }
}

