/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.writer;

import elf4j.engine.service.writer.StandardOutput;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;

public class FileStreamStandardOutput
implements StandardOutput {
    private final OutputStream stdout = new FileOutputStream(FileDescriptor.out);
    private final OutputStream stderr = new FileOutputStream(FileDescriptor.err);
    private final Lock lock = new ReentrantLock();

    private static void write(byte[] bytes, @NonNull OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        try {
            outputStream.write(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void out(byte[] bytes) {
        this.lock.lock();
        try {
            FileStreamStandardOutput.write(bytes, this.stdout);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void err(byte[] bytes) {
        this.lock.lock();
        try {
            FileStreamStandardOutput.write(bytes, this.stderr);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "FileStreamStandardOutput(stdout=" + this.stdout + ", stderr=" + this.stderr + ", lock=" + this.lock + ")";
    }
}

