/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service;

import elf4j.util.IeLogger;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import lombok.NonNull;

public enum NativeLogServiceManager {
    INSTANCE;

    private final Set<Refreshable> refreshables = new HashSet<Refreshable>();
    private final Set<Stoppable> stoppables = new HashSet<Stoppable>();
    private final Lock lock = new ReentrantLock();

    public void register(Refreshable refreshable) {
        this.lockAndRun(() -> this.refreshables.add(refreshable));
        IeLogger.INFO.log("Registered Refreshable {} in {}", new Object[]{refreshable, this});
    }

    public void register(Stoppable stoppable) {
        this.lockAndRun(() -> this.stoppables.add(stoppable));
        IeLogger.INFO.log("Registered Stoppable {} in {}", new Object[]{stoppable, this});
    }

    public void refresh() {
        IeLogger.INFO.log("Refreshing elf4j service by {} via reloading properties", new Object[]{this});
        this.lockAndRun(() -> {
            this.shutdown();
            this.refreshables.forEach(Refreshable::refresh);
        });
        IeLogger.INFO.log("Refreshed elf4j service by {} via reloading properties", new Object[]{this});
    }

    public void refresh(Properties properties) {
        IeLogger.INFO.log("Refreshing elf4j service by {} with properties {}", new Object[]{this, properties});
        this.lockAndRun(() -> {
            this.shutdown();
            this.refreshables.forEach(refreshable -> refreshable.refresh(properties));
        });
        IeLogger.INFO.log("Refreshed elf4j service by {} with properties {}", new Object[]{this, properties});
    }

    public void shutdown() {
        IeLogger.INFO.log("Start shutting down elf4j service by {}", new Object[]{this});
        this.lockAndRun(() -> {
            this.stoppables.forEach(Stoppable::stop);
            this.stoppables.clear();
        });
        IeLogger.INFO.log("End shutting down elf4j service by {}", new Object[]{this});
    }

    @NonNull
    public Thread getShutdownHookThread() {
        return new Thread(this::shutdown);
    }

    public void deregister(Refreshable refreshable) {
        this.lockAndRun(() -> this.refreshables.remove(refreshable));
        IeLogger.INFO.log("De-registered Refreshable {}", new Object[]{refreshable});
    }

    private void lockAndRun(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        this.lock.lock();
        try {
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "NativeLogServiceManager." + this.name() + "(refreshables=" + this.refreshables + ", stoppables=" + this.stoppables + ")";
    }

    public static interface Refreshable {
        public void refresh(@Nullable Properties var1);

        public void refresh();
    }

    public static interface Stoppable {
        public void stop();
    }
}

