/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.configuration;

import elf4j.util.IeLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public class LogServiceConfiguration {
    @Nullable
    private final Properties properties;

    private LogServiceConfiguration(@Nullable Properties properties) {
        this.properties = properties;
    }

    @NonNull
    public static LogServiceConfiguration byLoading() {
        IeLogger.INFO.log((Object)"Configuring by loading properties");
        return new LogServiceConfiguration(new PropertiesFileLoader().load());
    }

    @NonNull
    public static LogServiceConfiguration bySetting(Properties properties) {
        IeLogger.INFO.log("Configuring by setting properties: {}", new Object[]{properties});
        return new LogServiceConfiguration(properties);
    }

    public boolean isAbsent() {
        return this.properties == null;
    }

    @Nullable
    public Integer getAsInteger(String name) {
        String value = this.getProperties().getProperty(name);
        if (value == null) {
            return null;
        }
        String digits = value.replaceAll("\\D", "");
        if (digits.isEmpty()) {
            return null;
        }
        int i = Integer.parseInt(digits);
        return value.startsWith("-") ? -i : i;
    }

    public int getIntOrDefault(String name, int defaultValue) {
        Integer value = this.getAsInteger(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map<String, String> getChildProperties(String prefix) {
        if (this.isAbsent()) {
            return Collections.emptyMap();
        }
        String start = prefix + '.';
        return this.getProperties().stringPropertyNames().stream().filter(name -> name.trim().startsWith(start)).collect(Collectors.toMap(name -> name.substring(start.length()).trim(), name -> this.getProperties().getProperty((String)name).trim()));
    }

    public List<Map<String, String>> getPropertiesGroupOfType(String type) {
        if (this.isAbsent()) {
            return Collections.emptyList();
        }
        return this.getProperties().stringPropertyNames().stream().filter(name -> this.getProperties().getProperty((String)name).trim().equals(type)).map(this::getChildProperties).collect(Collectors.toList());
    }

    @Nonnull
    public Properties getProperties() {
        if (this.isAbsent()) {
            throw new IllegalStateException("No elf4j configuration present");
        }
        return Objects.requireNonNull(this.properties);
    }

    public boolean isTrue(String name) {
        return Boolean.parseBoolean(this.getProperties().getProperty(name));
    }

    public String toString() {
        return "LogServiceConfiguration(properties=" + this.properties + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogServiceConfiguration)) {
            return false;
        }
        LogServiceConfiguration other = (LogServiceConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogServiceConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    static class PropertiesFileLoader {
        static final String ELF4J_PROPERTIES_LOCATION = "elf4j.properties.location";
        private static final String[] DEFAULT_PROPERTIES_LOCATIONS = new String[]{"/elf4j-test.properties", "/elf4j.properties"};

        PropertiesFileLoader() {
        }

        @Nullable
        public Properties load() {
            InputStream propertiesInputStream;
            Properties properties = new Properties();
            String customPropertiesLocation = System.getProperty(ELF4J_PROPERTIES_LOCATION);
            if (customPropertiesLocation == null) {
                propertiesInputStream = this.fromDefaultPropertiesLocation();
                if (propertiesInputStream == null) {
                    IeLogger.WARN.log((Object)"No configuration file located!");
                    return null;
                }
            } else {
                propertiesInputStream = this.getClass().getResourceAsStream(customPropertiesLocation);
                if (propertiesInputStream == null) {
                    throw new IllegalArgumentException("Null resource stream from specified properties location: " + customPropertiesLocation);
                }
            }
            try {
                properties.load(propertiesInputStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error loading properties stream from location: " + (customPropertiesLocation == null ? "default location" : customPropertiesLocation), e);
            }
            IeLogger.INFO.log("Loaded properties: {}", new Object[]{properties});
            return properties;
        }

        private InputStream fromDefaultPropertiesLocation() {
            return Arrays.stream(DEFAULT_PROPERTIES_LOCATIONS).map(location -> this.getClass().getResourceAsStream((String)location)).filter(Objects::nonNull).findFirst().orElse(null);
        }
    }
}

