/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.configuration;

import elf4j.Level;
import elf4j.engine.NativeLogger;
import elf4j.engine.service.configuration.LogServiceConfiguration;
import elf4j.util.IeLogger;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.NonNull;

public class LoggerOutputLevelThreshold {
    private static final String CONFIGURED_ROOT_LOGGER_NAME_SPACE = "";
    private static final Level DEFAULT_THRESHOLD_OUTPUT_LEVEL = Level.TRACE;
    private final Map<String, Level> configuredLevels;
    private final List<String> sortedCallerClassNameSpaces;

    private LoggerOutputLevelThreshold(@NonNull Map<String, Level> configuredLevels) {
        if (configuredLevels == null) {
            throw new NullPointerException("configuredLevels is marked non-null but is null");
        }
        this.configuredLevels = new ConcurrentHashMap<String, Level>(configuredLevels);
        this.sortedCallerClassNameSpaces = configuredLevels.keySet().stream().sorted(new ByClassNameSpace()).collect(Collectors.toList());
        IeLogger.INFO.log("{} overriding caller level(s) in {}", new Object[]{configuredLevels.size(), this});
    }

    @NonNull
    public static LoggerOutputLevelThreshold from(@NonNull LogServiceConfiguration logServiceConfiguration) {
        if (logServiceConfiguration == null) {
            throw new NullPointerException("logServiceConfiguration is marked non-null but is null");
        }
        HashMap<String, Level> configuredLevels = new HashMap<String, Level>();
        Properties properties = logServiceConfiguration.getProperties();
        LoggerOutputLevelThreshold.getAsLevel("level", properties).ifPresent(level -> configuredLevels.put(CONFIGURED_ROOT_LOGGER_NAME_SPACE, (Level)level));
        configuredLevels.putAll(properties.stringPropertyNames().stream().filter(name -> name.trim().startsWith("level@")).collect(Collectors.toMap(name -> name.split("@", 2)[1].trim(), name -> LoggerOutputLevelThreshold.getAsLevel(name, properties).orElseThrow(NoSuchElementException::new))));
        return new LoggerOutputLevelThreshold(configuredLevels);
    }

    private static Optional<Level> getAsLevel(String levelKey, @NonNull Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        String levelValue = properties.getProperty(levelKey);
        return levelValue == null ? Optional.empty() : Optional.of(Level.valueOf((String)levelValue.trim().toUpperCase()));
    }

    public Level getThresholdOutputLevel(@NonNull NativeLogger nativeLogger) {
        if (nativeLogger == null) {
            throw new NullPointerException("nativeLogger is marked non-null but is null");
        }
        return this.sortedCallerClassNameSpaces.stream().filter(sortedNameSpace -> nativeLogger.getDeclaringClassName().startsWith((String)sortedNameSpace)).findFirst().map(this.configuredLevels::get).orElse(DEFAULT_THRESHOLD_OUTPUT_LEVEL);
    }

    public String toString() {
        return "LoggerOutputLevelThreshold(configuredLevels=" + this.configuredLevels + ", sortedCallerClassNameSpaces=" + this.sortedCallerClassNameSpaces + ")";
    }

    static class ByClassNameSpace
    implements Comparator<String> {
        ByClassNameSpace() {
        }

        private static int getPackageLevels(@NonNull String classNameSpace) {
            if (classNameSpace == null) {
                throw new NullPointerException("classNameSpace is marked non-null but is null");
            }
            return classNameSpace.split("\\.").length;
        }

        @Override
        public int compare(@NonNull String classNameSpace1, @NonNull String classNameSpace2) {
            if (classNameSpace1 == null) {
                throw new NullPointerException("classNameSpace1 is marked non-null but is null");
            }
            if (classNameSpace2 == null) {
                throw new NullPointerException("classNameSpace2 is marked non-null but is null");
            }
            int packageLevelDifference = ByClassNameSpace.getPackageLevels(classNameSpace2) - ByClassNameSpace.getPackageLevels(classNameSpace1);
            if (packageLevelDifference != 0) {
                return packageLevelDifference;
            }
            return Comparator.comparingInt(String::length).reversed().thenComparing(String::compareTo).compare(classNameSpace1, classNameSpace2);
        }
    }
}

