/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import com.dslplatform.json.CompiledJson;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.PrettifyOutputStream;
import com.dslplatform.json.runtime.Settings;
import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.PatternElement;
import elf4j.engine.service.pattern.PatternElements;
import elf4j.engine.service.util.StackTraces;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.MDC;

final class JsonElement
implements PatternElement {
    private static final String UTF_8 = StandardCharsets.UTF_8.toString();
    private static final int JSON_BYTES_INIT_SIZE = 1024;
    private static final String CALLER_DETAIL = "caller-detail";
    private static final String CALLER_THREAD = "caller-thread";
    private static final String PRETTY = "pretty";
    private static final Set<String> DISPLAY_OPTIONS = Arrays.stream(new String[]{"caller-thread", "caller-detail", "pretty"}).collect(Collectors.toSet());
    private final boolean includeCallerThread;
    private final boolean includeCallerDetail;
    private final boolean prettyPrint;
    private final DslJson<Object> dslJson = new DslJson(Settings.basicSetup().skipDefaultValues(true).includeServiceLoader());

    public static JsonElement from(@NonNull String patternSegment) {
        if (patternSegment == null) {
            throw new NullPointerException("patternSegment is marked non-null but is null");
        }
        Optional<String> displayOption = PatternElements.getPatternElementDisplayOption(patternSegment);
        if (!displayOption.isPresent()) {
            return JsonElement.builder().build();
        }
        Set options = Arrays.stream(displayOption.get().split(",")).map(String::trim).collect(Collectors.toSet());
        if (!DISPLAY_OPTIONS.containsAll(options)) {
            throw new IllegalArgumentException("Invalid JSON display option inside: " + options);
        }
        return JsonElement.builder().includeCallerThread(options.contains(CALLER_THREAD)).includeCallerDetail(options.contains(CALLER_DETAIL)).prettyPrint(options.contains(PRETTY)).build();
    }

    @Override
    public boolean includeCallerDetail() {
        return this.includeCallerDetail;
    }

    @Override
    public void render(LogEvent logEvent, @NonNull StringBuilder target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        try (ByteArrayOutputStream outputStream = this.prettyPrint ? new PrettifyOutputStream((OutputStream)byteArrayOutputStream) : byteArrayOutputStream;){
            this.dslJson.serialize((Object)JsonLogEntry.from(logEvent, this), (OutputStream)outputStream);
            target.append(byteArrayOutputStream.toString(UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    JsonElement(boolean includeCallerThread, boolean includeCallerDetail, boolean prettyPrint) {
        this.includeCallerThread = includeCallerThread;
        this.includeCallerDetail = includeCallerDetail;
        this.prettyPrint = prettyPrint;
    }

    public static JsonElementBuilder builder() {
        return new JsonElementBuilder();
    }

    public boolean isIncludeCallerThread() {
        return this.includeCallerThread;
    }

    public boolean isIncludeCallerDetail() {
        return this.includeCallerDetail;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public DslJson<Object> getDslJson() {
        return this.dslJson;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonElement)) {
            return false;
        }
        JsonElement other = (JsonElement)o;
        if (this.isIncludeCallerThread() != other.isIncludeCallerThread()) {
            return false;
        }
        if (this.isIncludeCallerDetail() != other.isIncludeCallerDetail()) {
            return false;
        }
        if (this.isPrettyPrint() != other.isPrettyPrint()) {
            return false;
        }
        DslJson<Object> this$dslJson = this.getDslJson();
        DslJson<Object> other$dslJson = other.getDslJson();
        return !(this$dslJson == null ? other$dslJson != null : !this$dslJson.equals(other$dslJson));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeCallerThread() ? 79 : 97);
        result = result * 59 + (this.isIncludeCallerDetail() ? 79 : 97);
        result = result * 59 + (this.isPrettyPrint() ? 79 : 97);
        DslJson<Object> $dslJson = this.getDslJson();
        result = result * 59 + ($dslJson == null ? 43 : $dslJson.hashCode());
        return result;
    }

    public String toString() {
        return "JsonElement(includeCallerThread=" + this.isIncludeCallerThread() + ", includeCallerDetail=" + this.isIncludeCallerDetail() + ", prettyPrint=" + this.isPrettyPrint() + ")";
    }

    public static class JsonElementBuilder {
        private boolean includeCallerThread;
        private boolean includeCallerDetail;
        private boolean prettyPrint;

        JsonElementBuilder() {
        }

        public JsonElementBuilder includeCallerThread(boolean includeCallerThread) {
            this.includeCallerThread = includeCallerThread;
            return this;
        }

        public JsonElementBuilder includeCallerDetail(boolean includeCallerDetail) {
            this.includeCallerDetail = includeCallerDetail;
            return this;
        }

        public JsonElementBuilder prettyPrint(boolean prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public JsonElement build() {
            return new JsonElement(this.includeCallerThread, this.includeCallerDetail, this.prettyPrint);
        }

        public String toString() {
            return "JsonElement.JsonElementBuilder(includeCallerThread=" + this.includeCallerThread + ", includeCallerDetail=" + this.includeCallerDetail + ", prettyPrint=" + this.prettyPrint + ")";
        }
    }

    @CompiledJson
    static final class JsonLogEntry {
        private final OffsetDateTime timestamp;
        private final String level;
        private final LogEvent.ThreadValue callerThread;
        private final String callerClass;
        private final LogEvent.StackFrameValue callerDetail;
        private final Map<String, String> context;
        private final String message;
        private final String exception;

        static JsonLogEntry from(@NonNull LogEvent logEvent, @NonNull JsonElement jsonPattern) {
            if (logEvent == null) {
                throw new NullPointerException("logEvent is marked non-null but is null");
            }
            if (jsonPattern == null) {
                throw new NullPointerException("jsonPattern is marked non-null but is null");
            }
            return JsonLogEntry.builder().timestamp(OffsetDateTime.ofInstant(logEvent.getTimestamp(), ZoneId.systemDefault())).callerClass(jsonPattern.includeCallerDetail ? null : logEvent.getCallerClassName()).level(logEvent.getNativeLogger().getLevel().name()).callerThread(jsonPattern.includeCallerThread ? logEvent.getCallerThread() : null).callerDetail(jsonPattern.includeCallerDetail ? Objects.requireNonNull(logEvent.getCallerFrame()) : null).message(logEvent.getResolvedMessage().toString()).context(MDC.getCopyOfContextMap()).exception(logEvent.getThrowable() == null ? null : StackTraces.getTraceAsBuffer(logEvent.getThrowable()).toString()).build();
        }

        JsonLogEntry(OffsetDateTime timestamp, String level, LogEvent.ThreadValue callerThread, String callerClass, LogEvent.StackFrameValue callerDetail, Map<String, String> context, String message, String exception) {
            this.timestamp = timestamp;
            this.level = level;
            this.callerThread = callerThread;
            this.callerClass = callerClass;
            this.callerDetail = callerDetail;
            this.context = context;
            this.message = message;
            this.exception = exception;
        }

        public static JsonLogEntryBuilder builder() {
            return new JsonLogEntryBuilder();
        }

        public OffsetDateTime getTimestamp() {
            return this.timestamp;
        }

        public String getLevel() {
            return this.level;
        }

        public LogEvent.ThreadValue getCallerThread() {
            return this.callerThread;
        }

        public String getCallerClass() {
            return this.callerClass;
        }

        public LogEvent.StackFrameValue getCallerDetail() {
            return this.callerDetail;
        }

        public Map<String, String> getContext() {
            return this.context;
        }

        public String getMessage() {
            return this.message;
        }

        public String getException() {
            return this.exception;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JsonLogEntry)) {
                return false;
            }
            JsonLogEntry other = (JsonLogEntry)o;
            OffsetDateTime this$timestamp = this.getTimestamp();
            OffsetDateTime other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            String this$level = this.getLevel();
            String other$level = other.getLevel();
            if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
                return false;
            }
            LogEvent.ThreadValue this$callerThread = this.getCallerThread();
            LogEvent.ThreadValue other$callerThread = other.getCallerThread();
            if (this$callerThread == null ? other$callerThread != null : !((Object)this$callerThread).equals(other$callerThread)) {
                return false;
            }
            String this$callerClass = this.getCallerClass();
            String other$callerClass = other.getCallerClass();
            if (this$callerClass == null ? other$callerClass != null : !this$callerClass.equals(other$callerClass)) {
                return false;
            }
            LogEvent.StackFrameValue this$callerDetail = this.getCallerDetail();
            LogEvent.StackFrameValue other$callerDetail = other.getCallerDetail();
            if (this$callerDetail == null ? other$callerDetail != null : !((Object)this$callerDetail).equals(other$callerDetail)) {
                return false;
            }
            Map<String, String> this$context = this.getContext();
            Map<String, String> other$context = other.getContext();
            if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$exception = this.getException();
            String other$exception = other.getException();
            return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            OffsetDateTime $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            String $level = this.getLevel();
            result = result * 59 + ($level == null ? 43 : $level.hashCode());
            LogEvent.ThreadValue $callerThread = this.getCallerThread();
            result = result * 59 + ($callerThread == null ? 43 : ((Object)$callerThread).hashCode());
            String $callerClass = this.getCallerClass();
            result = result * 59 + ($callerClass == null ? 43 : $callerClass.hashCode());
            LogEvent.StackFrameValue $callerDetail = this.getCallerDetail();
            result = result * 59 + ($callerDetail == null ? 43 : ((Object)$callerDetail).hashCode());
            Map<String, String> $context = this.getContext();
            result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $exception = this.getException();
            result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
            return result;
        }

        public String toString() {
            return "JsonElement.JsonLogEntry(timestamp=" + this.getTimestamp() + ", level=" + this.getLevel() + ", callerThread=" + this.getCallerThread() + ", callerClass=" + this.getCallerClass() + ", callerDetail=" + this.getCallerDetail() + ", context=" + this.getContext() + ", message=" + this.getMessage() + ", exception=" + this.getException() + ")";
        }

        public static class JsonLogEntryBuilder {
            private OffsetDateTime timestamp;
            private String level;
            private LogEvent.ThreadValue callerThread;
            private String callerClass;
            private LogEvent.StackFrameValue callerDetail;
            private Map<String, String> context;
            private String message;
            private String exception;

            JsonLogEntryBuilder() {
            }

            public JsonLogEntryBuilder timestamp(OffsetDateTime timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public JsonLogEntryBuilder level(String level) {
                this.level = level;
                return this;
            }

            public JsonLogEntryBuilder callerThread(LogEvent.ThreadValue callerThread) {
                this.callerThread = callerThread;
                return this;
            }

            public JsonLogEntryBuilder callerClass(String callerClass) {
                this.callerClass = callerClass;
                return this;
            }

            public JsonLogEntryBuilder callerDetail(LogEvent.StackFrameValue callerDetail) {
                this.callerDetail = callerDetail;
                return this;
            }

            public JsonLogEntryBuilder context(Map<String, String> context) {
                this.context = context;
                return this;
            }

            public JsonLogEntryBuilder message(String message) {
                this.message = message;
                return this;
            }

            public JsonLogEntryBuilder exception(String exception) {
                this.exception = exception;
                return this;
            }

            public JsonLogEntry build() {
                return new JsonLogEntry(this.timestamp, this.level, this.callerThread, this.callerClass, this.callerDetail, this.context, this.message, this.exception);
            }

            public String toString() {
                return "JsonElement.JsonLogEntry.JsonLogEntryBuilder(timestamp=" + this.timestamp + ", level=" + this.level + ", callerThread=" + this.callerThread + ", callerClass=" + this.callerClass + ", callerDetail=" + this.callerDetail + ", context=" + this.context + ", message=" + this.message + ", exception=" + this.exception + ")";
            }
        }
    }
}

