/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.PerformanceSensitive;
import elf4j.engine.service.pattern.PatternElement;
import elf4j.engine.service.pattern.PatternElements;
import elf4j.engine.service.pattern.VerbatimElement;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;

public final class LogPattern
implements PatternElement {
    private final List<PatternElement> patternElements;

    @Nonnull
    public static LogPattern from(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (pattern.trim().isEmpty()) {
            throw new IllegalArgumentException("Unexpected blank pattern");
        }
        ArrayList<PatternElement> elements = new ArrayList<PatternElement>();
        int length = pattern.length();
        int i = 0;
        while (i < length) {
            String element;
            int j;
            if (pattern.charAt(i) == '{') {
                j = pattern.indexOf(125, i);
                if (j != -1) {
                    element = pattern.substring(i + 1, j);
                    i = j + 1;
                } else {
                    element = pattern.substring(i);
                    i = length;
                }
                elements.add(PatternElements.parsePredefinedPatternELement(element));
                continue;
            }
            j = pattern.indexOf(123, i);
            if (j != -1) {
                element = pattern.substring(i, j);
                i = j;
            } else {
                element = pattern.substring(i);
                i = length;
            }
            elements.add(VerbatimElement.from(element));
        }
        return new LogPattern(elements);
    }

    @Override
    public boolean includeCallerDetail() {
        return this.patternElements.stream().anyMatch(PerformanceSensitive::includeCallerDetail);
    }

    @Override
    public void render(LogEvent logEvent, StringBuilder target) {
        for (PatternElement pattern : this.patternElements) {
            pattern.render(logEvent, target);
        }
    }

    public LogPattern(List<PatternElement> patternElements) {
        this.patternElements = patternElements;
    }

    public List<PatternElement> getPatternElements() {
        return this.patternElements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogPattern)) {
            return false;
        }
        LogPattern other = (LogPattern)o;
        List<PatternElement> this$patternElements = this.getPatternElements();
        List<PatternElement> other$patternElements = other.getPatternElements();
        return !(this$patternElements == null ? other$patternElements != null : !((Object)this$patternElements).equals(other$patternElements));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PatternElement> $patternElements = this.getPatternElements();
        result = result * 59 + ($patternElements == null ? 43 : ((Object)$patternElements).hashCode());
        return result;
    }

    public String toString() {
        return "LogPattern(patternElements=" + this.getPatternElements() + ")";
    }
}

