/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.PatternElement;
import elf4j.engine.service.pattern.PatternElements;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import lombok.NonNull;

final class SystemEnvironmentElement
implements PatternElement {
    private final String key;
    private final String value;

    private SystemEnvironmentElement(String key) {
        this.key = key;
        this.value = System.getenv(key);
    }

    @Nonnull
    public static SystemEnvironmentElement from(String patternSegment) {
        return new SystemEnvironmentElement(PatternElements.getPatternElementDisplayOption(patternSegment).orElseThrow(NoSuchElementException::new));
    }

    @Override
    public void render(LogEvent logEvent, @NonNull StringBuilder target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        target.append(this.value);
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemEnvironmentElement)) {
            return false;
        }
        SystemEnvironmentElement other = (SystemEnvironmentElement)o;
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "SystemEnvironmentElement(key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }
}

