/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.PatternElement;
import elf4j.engine.service.pattern.PatternElements;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.NonNull;

final class ThreadElement
implements PatternElement {
    @NonNull
    private final DisplayOption threadDisplayOption;

    @Nonnull
    public static ThreadElement from(@NonNull String patternSegment) {
        if (patternSegment == null) {
            throw new NullPointerException("patternSegment is marked non-null but is null");
        }
        return new ThreadElement(PatternElements.getPatternElementDisplayOption(patternSegment).map(displayOption -> DisplayOption.valueOf(displayOption.toUpperCase())).orElse(DisplayOption.NAME));
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @Override
    public void render(@NonNull LogEvent logEvent, @NonNull StringBuilder target) {
        if (logEvent == null) {
            throw new NullPointerException("logEvent is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        LogEvent.ThreadValue callerThread = Objects.requireNonNull(logEvent.getCallerThread());
        target.append(this.threadDisplayOption == DisplayOption.ID ? Long.valueOf(callerThread.getId()) : callerThread.getName());
    }

    public ThreadElement(@NonNull DisplayOption threadDisplayOption) {
        if (threadDisplayOption == null) {
            throw new NullPointerException("threadDisplayOption is marked non-null but is null");
        }
        this.threadDisplayOption = threadDisplayOption;
    }

    @NonNull
    public DisplayOption getThreadDisplayOption() {
        return this.threadDisplayOption;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadElement)) {
            return false;
        }
        ThreadElement other = (ThreadElement)o;
        DisplayOption this$threadDisplayOption = this.getThreadDisplayOption();
        DisplayOption other$threadDisplayOption = other.getThreadDisplayOption();
        return !(this$threadDisplayOption == null ? other$threadDisplayOption != null : !((Object)((Object)this$threadDisplayOption)).equals((Object)other$threadDisplayOption));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DisplayOption $threadDisplayOption = this.getThreadDisplayOption();
        result = result * 59 + ($threadDisplayOption == null ? 43 : ((Object)((Object)$threadDisplayOption)).hashCode());
        return result;
    }

    public String toString() {
        return "ThreadElement(threadDisplayOption=" + (Object)((Object)this.getThreadDisplayOption()) + ")";
    }

    static enum DisplayOption {
        ID,
        NAME;

    }
}

