/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.writer;

import elf4j.Level;
import elf4j.engine.service.LogEvent;
import elf4j.engine.service.configuration.LogServiceConfiguration;
import elf4j.engine.service.pattern.LogPattern;
import elf4j.engine.service.pattern.PatternElement;
import elf4j.engine.service.writer.LogWriter;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;

public class StandardStreamWriter
implements LogWriter {
    private static final String DEFAULT_THRESHOLD_OUTPUT_LEVEL = "trace";
    private static final String DEFAULT_PATTERN = "{timestamp} {level} {class} - {message}";
    private static final OutStreamType DEFAULT_OUT_STREAM_TYPE = OutStreamType.STDOUT;
    private static final String LINE_FEED = System.lineSeparator();
    private final StandardOutput standardOutput = new FileStreamStandardOutput();
    private final Level thresholdOutputLevel;
    private final PatternElement logPattern;
    private final OutStreamType outStreamType;

    @Override
    public Level getThresholdOutputLevel() {
        return this.thresholdOutputLevel;
    }

    @Override
    public void write(@NonNull LogEvent logEvent) {
        if (logEvent == null) {
            throw new NullPointerException("logEvent is marked non-null but is null");
        }
        if (logEvent.getNativeLogger().getLevel().compareTo((Enum)this.thresholdOutputLevel) < 0) {
            return;
        }
        StringBuilder target = new StringBuilder();
        this.logPattern.render(logEvent, target);
        byte[] bytes = target.append(LINE_FEED).toString().getBytes(StandardCharsets.UTF_8);
        if (this.outStreamType == OutStreamType.STDERR) {
            this.standardOutput.err(bytes);
        } else {
            this.standardOutput.out(bytes);
        }
    }

    @Override
    public boolean includeCallerDetail() {
        return this.logPattern.includeCallerDetail();
    }

    StandardStreamWriter(Level thresholdOutputLevel, PatternElement logPattern, OutStreamType outStreamType) {
        this.thresholdOutputLevel = thresholdOutputLevel;
        this.logPattern = logPattern;
        this.outStreamType = outStreamType;
    }

    public static StandardStreamWriterBuilder builder() {
        return new StandardStreamWriterBuilder();
    }

    public String toString() {
        return "StandardStreamWriter(standardOutput=" + this.standardOutput + ", thresholdOutputLevel=" + this.getThresholdOutputLevel() + ", logPattern=" + this.logPattern + ", outStreamType=" + (Object)((Object)this.outStreamType) + ")";
    }

    static enum OutStreamType {
        STDOUT,
        STDERR;

    }

    @ThreadSafe
    public static interface StandardOutput {
        public void out(byte[] var1);

        public void err(byte[] var1);
    }

    public static class FileStreamStandardOutput
    implements StandardOutput {
        private final OutputStream stdout = new FileOutputStream(FileDescriptor.out);
        private final OutputStream stderr = new FileOutputStream(FileDescriptor.err);
        private final Lock lock = new ReentrantLock();

        @Override
        public void out(byte[] bytes) {
            this.write(bytes, this.stdout);
        }

        @Override
        public void err(byte[] bytes) {
            this.write(bytes, this.stderr);
        }

        private void write(byte[] bytes, @NonNull OutputStream outputStream) {
            if (outputStream == null) {
                throw new NullPointerException("outputStream is marked non-null but is null");
            }
            this.lock.lock();
            try {
                outputStream.write(bytes);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.lock.unlock();
            }
        }

        public String toString() {
            return "StandardStreamWriter.FileStreamStandardOutput(stdout=" + this.stdout + ", stderr=" + this.stderr + ", lock=" + this.lock + ")";
        }
    }

    public static class StandardStreamWriterBuilder {
        private Level thresholdOutputLevel;
        private PatternElement logPattern;
        private OutStreamType outStreamType;

        StandardStreamWriterBuilder() {
        }

        public StandardStreamWriterBuilder thresholdOutputLevel(Level thresholdOutputLevel) {
            this.thresholdOutputLevel = thresholdOutputLevel;
            return this;
        }

        public StandardStreamWriterBuilder logPattern(PatternElement logPattern) {
            this.logPattern = logPattern;
            return this;
        }

        public StandardStreamWriterBuilder outStreamType(OutStreamType outStreamType) {
            this.outStreamType = outStreamType;
            return this;
        }

        public StandardStreamWriter build() {
            return new StandardStreamWriter(this.thresholdOutputLevel, this.logPattern, this.outStreamType);
        }

        public String toString() {
            return "StandardStreamWriter.StandardStreamWriterBuilder(thresholdOutputLevel=" + this.thresholdOutputLevel + ", logPattern=" + this.logPattern + ", outStreamType=" + (Object)((Object)this.outStreamType) + ")";
        }
    }

    static class Type
    implements LogWriter.LogWriterType {
        Type() {
        }

        private static StandardStreamWriter getDefaultWriter(@NonNull LogServiceConfiguration logServiceConfiguration) {
            if (logServiceConfiguration == null) {
                throw new NullPointerException("logServiceConfiguration is marked non-null but is null");
            }
            Properties properties = logServiceConfiguration.getProperties();
            return StandardStreamWriter.builder().thresholdOutputLevel(Level.valueOf((String)properties.getProperty("level", StandardStreamWriter.DEFAULT_THRESHOLD_OUTPUT_LEVEL).trim().toUpperCase())).logPattern(LogPattern.from(properties.getProperty("pattern", StandardStreamWriter.DEFAULT_PATTERN))).outStreamType(OutStreamType.valueOf(properties.getProperty("stream", DEFAULT_OUT_STREAM_TYPE.name()).trim().toUpperCase())).build();
        }

        @Override
        public List<LogWriter> getLogWriters(@NonNull LogServiceConfiguration logServiceConfiguration) {
            if (logServiceConfiguration == null) {
                throw new NullPointerException("logServiceConfiguration is marked non-null but is null");
            }
            return Collections.singletonList(Type.getDefaultWriter(logServiceConfiguration));
        }
    }
}

