/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.PatternElement;
import elf4j.engine.service.pattern.PatternElements;
import javax.annotation.Nonnull;
import lombok.Generated;
import lombok.NonNull;

record ClassElement(@NonNull DisplayOption classDisplayOption) implements PatternElement
{
    private static final DisplayOption DEFAULT_DISPLAY_OPTION = DisplayOption.SIMPLE;

    @Generated
    public ClassElement(@NonNull DisplayOption classDisplayOption) {
        if (classDisplayOption == null) {
            throw new NullPointerException("classDisplayOption is marked non-null but is null");
        }
    }

    @Nonnull
    public static ClassElement from(@NonNull String patternSegment) {
        if (patternSegment == null) {
            throw new NullPointerException("patternSegment is marked non-null but is null");
        }
        return new ClassElement(PatternElements.getPatternElementDisplayOption(patternSegment).map(displayOption -> DisplayOption.valueOf(displayOption.toUpperCase())).orElse(DEFAULT_DISPLAY_OPTION));
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @Override
    public void render(@NonNull LogEvent logEvent, StringBuilder target) {
        if (logEvent == null) {
            throw new NullPointerException("logEvent is marked non-null but is null");
        }
        String fullName = logEvent.getCallerClassName();
        switch (this.classDisplayOption.ordinal()) {
            case 0: {
                target.append(fullName);
                return;
            }
            case 1: {
                target.append(fullName.substring(fullName.lastIndexOf(46) + 1));
                return;
            }
            case 2: {
                String[] tokens = fullName.split("\\.");
                String simpleName = tokens[tokens.length - 1];
                for (int i = 0; i < tokens.length - 1; ++i) {
                    target.append(tokens[i].charAt(0)).append('.');
                }
                target.append(simpleName);
                return;
            }
        }
        throw new IllegalArgumentException("class display option: " + String.valueOf((Object)this.classDisplayOption));
    }

    static enum DisplayOption {
        FULL,
        SIMPLE,
        COMPRESSED;

    }
}

