/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.PatternElement;
import elf4j.engine.service.pattern.PatternElements;
import lombok.Generated;
import lombok.NonNull;

final class LevelElement
implements PatternElement {
    private static final int UNSPECIFIED = -1;
    private final int displayLength;

    private LevelElement(int displayLength) {
        this.displayLength = displayLength;
    }

    @NonNull
    public static LevelElement from(@NonNull String patternSegment) {
        if (patternSegment == null) {
            throw new NullPointerException("patternSegment is marked non-null but is null");
        }
        return new LevelElement(PatternElements.getPatternElementDisplayOption(patternSegment).map(Integer::parseInt).orElse(-1));
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @Override
    public void render(@NonNull LogEvent logEvent, StringBuilder target) {
        if (logEvent == null) {
            throw new NullPointerException("logEvent is marked non-null but is null");
        }
        String level = logEvent.getNativeLogger().getLevel().name();
        if (this.displayLength == -1) {
            target.append(level);
            return;
        }
        char[] levelChars = level.toCharArray();
        for (int i = 0; i < this.displayLength; ++i) {
            target.append(i < levelChars.length ? levelChars[i] : (char)' ');
        }
    }

    @Generated
    public int getDisplayLength() {
        return this.displayLength;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LevelElement)) {
            return false;
        }
        LevelElement other = (LevelElement)o;
        return this.getDisplayLength() == other.getDisplayLength();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDisplayLength();
        return result;
    }

    @Generated
    public String toString() {
        return "LevelElement(displayLength=" + this.getDisplayLength() + ")";
    }
}

