/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.writer;

import conseq4j.execute.ConseqExecutor;
import elf4j.Level;
import elf4j.engine.service.LogEvent;
import elf4j.engine.service.NativeLogServiceManager;
import elf4j.engine.service.PerformanceSensitive;
import elf4j.engine.service.configuration.LogServiceConfiguration;
import elf4j.engine.service.writer.LogWriter;
import elf4j.engine.service.writer.StandardStreamWriter;
import elf4j.util.IeLogger;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.MDC;

public class GroupWriter
implements LogWriter,
NativeLogServiceManager.Stoppable {
    private final List<LogWriter> writers;
    private final ConseqExecutor conseqExecutor;
    private Level thresholdOutputLevel;
    private Boolean includeCallerDetail;

    private GroupWriter(@NonNull List<LogWriter> writers, ConseqExecutor conseqExecutor) {
        if (writers == null) {
            throw new NullPointerException("writers is marked non-null but is null");
        }
        this.writers = writers;
        this.conseqExecutor = conseqExecutor;
        IeLogger.INFO.log("{} service writer(s) in {}", new Object[]{writers.size(), this});
        NativeLogServiceManager.INSTANCE.register(this);
    }

    @NonNull
    public static GroupWriter from(LogServiceConfiguration logServiceConfiguration) {
        ArrayList<LogWriter.LogWriterType> logWriterTypes = new ArrayList<LogWriter.LogWriterType>(GroupWriter.getLogWriterTypes(logServiceConfiguration));
        if (logWriterTypes.isEmpty()) {
            logWriterTypes.add(new StandardStreamWriter.Type());
        }
        List<LogWriter> logWriters = logWriterTypes.stream().flatMap(t -> t.getLogWriters(logServiceConfiguration).stream()).collect(Collectors.toList());
        return new GroupWriter(logWriters, Optional.ofNullable(logServiceConfiguration.getAsInteger("concurrency")).map(ConseqExecutor::instance).orElse(ConseqExecutor.instance()));
    }

    private static List<LogWriter.LogWriterType> getLogWriterTypes(@NonNull LogServiceConfiguration logServiceConfiguration) {
        if (logServiceConfiguration == null) {
            throw new NullPointerException("logServiceConfiguration is marked non-null but is null");
        }
        if (logServiceConfiguration.isAbsent()) {
            return Collections.emptyList();
        }
        Properties properties = logServiceConfiguration.getProperties();
        String writerTypes = properties.getProperty("writer.types");
        if (writerTypes == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(writerTypes.split(",")).map(String::trim).map(fqcn -> {
            try {
                return (LogWriter.LogWriterType)Class.forName(fqcn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Error instantiating: " + fqcn, e);
            }
        }).collect(Collectors.toList());
    }

    @NonNull
    private static Runnable withMdcContext(Runnable task) {
        Map callerContext = MDC.getCopyOfContextMap();
        return () -> {
            Map<String, String> workerContext = GroupWriter.switchContextTo(callerContext);
            MDC.setContextMap((Map)callerContext);
            try {
                task.run();
            }
            finally {
                MDC.setContextMap(workerContext);
            }
        };
    }

    private static Map<String, String> switchContextTo(Map<String, String> targetContext) {
        Map replaced = MDC.getCopyOfContextMap();
        MDC.setContextMap(targetContext);
        return replaced;
    }

    @Override
    public Level getThresholdOutputLevel() {
        if (this.thresholdOutputLevel == null) {
            this.thresholdOutputLevel = Level.values()[this.writers.stream().mapToInt(writer -> writer.getThresholdOutputLevel().ordinal()).min().orElseThrow(NoSuchElementException::new)];
        }
        return this.thresholdOutputLevel;
    }

    @Override
    public void write(@NonNull LogEvent logEvent) {
        if (logEvent == null) {
            throw new NullPointerException("logEvent is marked non-null but is null");
        }
        this.writers.forEach(writer -> this.conseqExecutor.execute(GroupWriter.withMdcContext(() -> writer.write(logEvent)), (Object)logEvent.getCallerThread().id()));
    }

    @Override
    public boolean includeCallerDetail() {
        if (this.includeCallerDetail == null) {
            this.includeCallerDetail = this.writers.stream().anyMatch(PerformanceSensitive::includeCallerDetail);
        }
        return this.includeCallerDetail;
    }

    @Override
    public void stop() {
        if (this.conseqExecutor.isTerminated()) {
            return;
        }
        IeLogger.INFO.log("Stopping {}", new Object[]{this});
        this.conseqExecutor.close();
    }

    @Generated
    public String toString() {
        return "GroupWriter(writers=" + String.valueOf(this.writers) + ", conseqExecutor=" + String.valueOf(this.conseqExecutor) + ", thresholdOutputLevel=" + String.valueOf(this.getThresholdOutputLevel()) + ")";
    }
}

