/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine;

import elf4j.Level;
import elf4j.Logger;
import elf4j.engine.NativeLogger;
import elf4j.engine.service.EventingNativeLoggerService;
import elf4j.engine.service.NativeLogServiceManager;
import elf4j.engine.service.NativeLoggerService;
import elf4j.engine.service.configuration.LogServiceConfiguration;
import elf4j.engine.service.util.StackTraces;
import elf4j.spi.LogServiceProvider;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.MdcAdapterInitializer;

public class NativeLogServiceProvider
implements LogServiceProvider,
NativeLogServiceManager.Refreshable {
    private static final Level DEFAULT_LOGGER_SEVERITY_LEVEL = Level.INFO;
    @NonNull
    private final Level defaultLoggerLevel;
    private final Map<Level, Map<String, NativeLogger>> nativeLoggers = EnumSet.allOf(Level.class).stream().collect(Collectors.toMap(Function.identity(), level -> new ConcurrentHashMap()));
    @NonNull
    private final Class<?> serviceAccessClass;
    @NonNull
    private final NativeLoggerServiceFactory nativeLoggerServiceFactory;

    public NativeLogServiceProvider() {
        this(Logger.class);
    }

    public NativeLogServiceProvider(@NonNull Class<?> serviceAccessClass) {
        this(DEFAULT_LOGGER_SEVERITY_LEVEL, serviceAccessClass, new ConfiguredNativeLoggerServiceFactory());
        if (serviceAccessClass == null) {
            throw new NullPointerException("serviceAccessClass is marked non-null but is null");
        }
    }

    NativeLogServiceProvider(@NonNull Level defaultLoggerLevel, @NonNull Class<?> serviceAccessClass, @NonNull NativeLoggerServiceFactory nativeLoggerServiceFactory) {
        if (defaultLoggerLevel == null) {
            throw new NullPointerException("defaultLoggerLevel is marked non-null but is null");
        }
        if (serviceAccessClass == null) {
            throw new NullPointerException("serviceAccessClass is marked non-null but is null");
        }
        if (nativeLoggerServiceFactory == null) {
            throw new NullPointerException("nativeLoggerServiceFactory is marked non-null but is null");
        }
        MdcAdapterInitializer.initialize();
        this.defaultLoggerLevel = defaultLoggerLevel;
        this.serviceAccessClass = serviceAccessClass;
        this.nativeLoggerServiceFactory = nativeLoggerServiceFactory;
        NativeLogServiceManager.INSTANCE.register(this);
    }

    public NativeLogger logger() {
        return this.getLogger(this.defaultLoggerLevel, StackTraces.callerOf(this.serviceAccessClass).getClassName());
    }

    @Override
    public void refresh(@Nullable Properties properties) {
        this.nativeLoggerServiceFactory.reset(properties);
    }

    @Override
    public void refresh() {
        this.nativeLoggerServiceFactory.reload();
    }

    @NonNull
    NativeLoggerService getLogService() {
        return this.nativeLoggerServiceFactory.getLogService();
    }

    NativeLogger getLogger(Level level, String declaringClassName) {
        return this.nativeLoggers.get(level).computeIfAbsent(declaringClassName, k -> new NativeLogger((String)k, level, this));
    }

    static class ConfiguredNativeLoggerServiceFactory
    implements NativeLoggerServiceFactory {
        private NativeLoggerService nativeLoggerService = new EventingNativeLoggerService(LogServiceConfiguration.byLoading());

        private ConfiguredNativeLoggerServiceFactory() {
        }

        @Override
        public NativeLoggerService getLogService() {
            return this.nativeLoggerService;
        }

        @Override
        public void reload() {
            this.nativeLoggerService = new EventingNativeLoggerService(LogServiceConfiguration.byLoading());
        }

        @Override
        public void reset(Properties properties) {
            this.nativeLoggerService = new EventingNativeLoggerService(LogServiceConfiguration.bySetting(properties));
        }
    }

    static interface NativeLoggerServiceFactory {
        public NativeLoggerService getLogService();

        public void reload();

        public void reset(Properties var1);
    }
}

