/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine;

import elf4j.Level;
import elf4j.Logger;
import elf4j.engine.NativeLogServiceProvider;
import elf4j.engine.service.NativeLoggerService;
import javax.annotation.concurrent.ThreadSafe;
import lombok.NonNull;

@ThreadSafe
public class NativeLogger
implements Logger {
    @NonNull
    private final String declaringClassName;
    @NonNull
    private final Level level;
    @NonNull
    private final NativeLogServiceProvider nativeLogServiceProvider;

    public NativeLogger(@NonNull String declaringClassName, @NonNull Level level, @NonNull NativeLogServiceProvider nativeLogServiceProvider) {
        if (declaringClassName == null) {
            throw new NullPointerException("declaringClassName is marked non-null but is null");
        }
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (nativeLogServiceProvider == null) {
            throw new NullPointerException("nativeLogServiceProvider is marked non-null but is null");
        }
        this.declaringClassName = declaringClassName;
        this.level = level;
        this.nativeLogServiceProvider = nativeLogServiceProvider;
    }

    public NativeLogger atLevel(Level level) {
        return this.level == level ? this : this.nativeLogServiceProvider.getLogger(level, this.declaringClassName);
    }

    @NonNull
    public Level getLevel() {
        return this.level;
    }

    public boolean isEnabled() {
        return this.getLogService().isEnabled(this);
    }

    public void log(Object message) {
        this.service(null, message, null);
    }

    public void log(String message, Object ... arguments) {
        this.service(null, message, arguments);
    }

    public void log(Throwable throwable) {
        this.service(throwable, null, null);
    }

    public void log(Throwable throwable, Object message) {
        this.service(throwable, message, null);
    }

    public void log(Throwable throwable, String message, Object ... arguments) {
        this.service(throwable, message, arguments);
    }

    public NativeLoggerService getLogService() {
        return this.nativeLogServiceProvider.getLogService();
    }

    @NonNull
    public String getDeclaringClassName() {
        return this.declaringClassName;
    }

    private void service(Throwable throwable, Object message, Object[] arguments) {
        this.getLogService().log(this, NativeLogger.class, throwable, message, arguments);
    }
}

