/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service;

import elf4j.Level;
import elf4j.engine.NativeLogger;
import elf4j.engine.service.LogEvent;
import elf4j.engine.service.NativeLoggerService;
import elf4j.engine.service.configuration.LogServiceConfiguration;
import elf4j.engine.service.configuration.LoggerOutputLevelThreshold;
import elf4j.engine.service.util.StackTraces;
import elf4j.engine.service.writer.GroupWriter;
import elf4j.engine.service.writer.LogWriter;
import elf4j.util.IeLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public class EventingNativeLoggerService
implements NativeLoggerService {
    private final boolean noop;
    private final LogWriter logWriter;
    private final LoggerOutputLevelThreshold loggerOutputLevelThreshold;
    private final Map<NativeLogger, Boolean> loggerEnabled = new ConcurrentHashMap<NativeLogger, Boolean>();

    public EventingNativeLoggerService(@NonNull LogServiceConfiguration logServiceConfiguration) {
        if (logServiceConfiguration == null) {
            throw new NullPointerException("logServiceConfiguration is marked non-null but is null");
        }
        if (logServiceConfiguration.isAbsent() || logServiceConfiguration.isTrue("noop")) {
            this.noop = true;
            IeLogger.WARN.log("No-op per configuration {}", new Object[]{logServiceConfiguration});
            this.logWriter = null;
            this.loggerOutputLevelThreshold = null;
            return;
        }
        this.noop = false;
        this.logWriter = GroupWriter.from(logServiceConfiguration);
        this.loggerOutputLevelThreshold = LoggerOutputLevelThreshold.from(logServiceConfiguration);
    }

    @Override
    public boolean includeCallerDetail() {
        return this.logWriter.includeCallerDetail();
    }

    @Override
    public boolean isEnabled(NativeLogger nativeLogger) {
        if (this.noop) {
            return false;
        }
        return this.loggerEnabled.computeIfAbsent(nativeLogger, logger -> {
            Level level = logger.getLevel();
            return level.compareTo((Enum)this.loggerOutputLevelThreshold.getThresholdOutputLevel((NativeLogger)logger)) >= 0 && level.compareTo((Enum)this.logWriter.getThresholdOutputLevel()) >= 0;
        });
    }

    @Override
    public void log(@NonNull NativeLogger nativeLogger, @NonNull Class<?> serviceInterfaceClass, Throwable throwable, Object message, Object[] arguments) {
        if (nativeLogger == null) {
            throw new NullPointerException("nativeLogger is marked non-null but is null");
        }
        if (serviceInterfaceClass == null) {
            throw new NullPointerException("serviceInterfaceClass is marked non-null but is null");
        }
        if (!this.isEnabled(nativeLogger)) {
            return;
        }
        Thread callerThread = Thread.currentThread();
        this.logWriter.write(LogEvent.builder().callerThread(new LogEvent.ThreadValue(callerThread.getName(), callerThread.threadId())).nativeLogger(nativeLogger).throwable(throwable).message(message).arguments(arguments).serviceInterfaceClass(serviceInterfaceClass).callerFrame(this.includeCallerDetail() ? LogEvent.StackFrameValue.from(StackTraces.getCallerFrame(serviceInterfaceClass, new Throwable().getStackTrace())) : null).build());
    }
}

