/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service;

import elf4j.engine.NativeLogger;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

public final class LogEvent {
    private static final int ADDITIONAL_STRING_BUILDER_CAPACITY = 32;
    @NonNull
    private final NativeLogger nativeLogger;
    @NonNull
    private final ThreadValue callerThread;
    @NonNull
    private final Instant timestamp = Instant.now();
    @Nullable
    private final Object message;
    @Nullable
    private final Object[] arguments;
    @Nullable
    private final Throwable throwable;
    @Nullable
    private final Class<?> serviceInterfaceClass;
    @Nullable
    private final StackFrameValue callerFrame;

    @NonNull
    private static CharSequence resolve(Object message, Object[] arguments) {
        String suppliedMessage = Objects.toString(LogEvent.supply(message), "");
        if (arguments == null || arguments.length == 0) {
            return suppliedMessage;
        }
        int messageLength = suppliedMessage.length();
        StringBuilder resolved = new StringBuilder(messageLength + 32);
        int i = 0;
        int j = 0;
        while (i < messageLength) {
            char character = suppliedMessage.charAt(i);
            if (character == '{' && i + 1 < messageLength && suppliedMessage.charAt(i + 1) == '}' && j < arguments.length) {
                resolved.append(LogEvent.supply(arguments[j++]));
                i += 2;
                continue;
            }
            resolved.append(character);
            ++i;
        }
        return resolved;
    }

    @Nullable
    private static Object supply(@Nullable Object o) {
        return o instanceof Supplier ? ((Supplier)o).get() : o;
    }

    public String getCallerClassName() {
        return this.callerFrame != null ? this.callerFrame.getClassName() : this.nativeLogger.getDeclaringClassName();
    }

    public CharSequence getResolvedMessage() {
        return LogEvent.resolve(this.message, this.arguments);
    }

    @Generated
    LogEvent(@NonNull NativeLogger nativeLogger, @NonNull ThreadValue callerThread, @Nullable Object message, @Nullable Object[] arguments, @Nullable Throwable throwable, @Nullable Class<?> serviceInterfaceClass, @Nullable StackFrameValue callerFrame) {
        if (nativeLogger == null) {
            throw new NullPointerException("nativeLogger is marked non-null but is null");
        }
        if (callerThread == null) {
            throw new NullPointerException("callerThread is marked non-null but is null");
        }
        this.nativeLogger = nativeLogger;
        this.callerThread = callerThread;
        this.message = message;
        this.arguments = arguments;
        this.throwable = throwable;
        this.serviceInterfaceClass = serviceInterfaceClass;
        this.callerFrame = callerFrame;
    }

    @Generated
    public static LogEventBuilder builder() {
        return new LogEventBuilder();
    }

    @NonNull
    @Generated
    public NativeLogger getNativeLogger() {
        return this.nativeLogger;
    }

    @NonNull
    @Generated
    public ThreadValue getCallerThread() {
        return this.callerThread;
    }

    @NonNull
    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    @Generated
    public Object getMessage() {
        return this.message;
    }

    @Nullable
    @Generated
    public Object[] getArguments() {
        return this.arguments;
    }

    @Nullable
    @Generated
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Nullable
    @Generated
    public Class<?> getServiceInterfaceClass() {
        return this.serviceInterfaceClass;
    }

    @Nullable
    @Generated
    public StackFrameValue getCallerFrame() {
        return this.callerFrame;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogEvent)) {
            return false;
        }
        LogEvent other = (LogEvent)o;
        NativeLogger this$nativeLogger = this.getNativeLogger();
        NativeLogger other$nativeLogger = other.getNativeLogger();
        if (this$nativeLogger == null ? other$nativeLogger != null : !this$nativeLogger.equals(other$nativeLogger)) {
            return false;
        }
        ThreadValue this$callerThread = this.getCallerThread();
        ThreadValue other$callerThread = other.getCallerThread();
        if (this$callerThread == null ? other$callerThread != null : !((Object)this$callerThread).equals(other$callerThread)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Object this$message = this.getMessage();
        Object other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArguments(), other.getArguments())) {
            return false;
        }
        Throwable this$throwable = this.getThrowable();
        Throwable other$throwable = other.getThrowable();
        if (this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable)) {
            return false;
        }
        Class<?> this$serviceInterfaceClass = this.getServiceInterfaceClass();
        Class<?> other$serviceInterfaceClass = other.getServiceInterfaceClass();
        if (this$serviceInterfaceClass == null ? other$serviceInterfaceClass != null : !this$serviceInterfaceClass.equals(other$serviceInterfaceClass)) {
            return false;
        }
        StackFrameValue this$callerFrame = this.getCallerFrame();
        StackFrameValue other$callerFrame = other.getCallerFrame();
        return !(this$callerFrame == null ? other$callerFrame != null : !((Object)this$callerFrame).equals(other$callerFrame));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NativeLogger $nativeLogger = this.getNativeLogger();
        result = result * 59 + ($nativeLogger == null ? 43 : $nativeLogger.hashCode());
        ThreadValue $callerThread = this.getCallerThread();
        result = result * 59 + ($callerThread == null ? 43 : ((Object)$callerThread).hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Object $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArguments());
        Throwable $throwable = this.getThrowable();
        result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
        Class<?> $serviceInterfaceClass = this.getServiceInterfaceClass();
        result = result * 59 + ($serviceInterfaceClass == null ? 43 : $serviceInterfaceClass.hashCode());
        StackFrameValue $callerFrame = this.getCallerFrame();
        result = result * 59 + ($callerFrame == null ? 43 : ((Object)$callerFrame).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LogEvent(nativeLogger=" + String.valueOf(this.getNativeLogger()) + ", callerThread=" + String.valueOf(this.getCallerThread()) + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", message=" + String.valueOf(this.getMessage()) + ", arguments=" + Arrays.deepToString(this.getArguments()) + ", throwable=" + String.valueOf(this.getThrowable()) + ", serviceInterfaceClass=" + String.valueOf(this.getServiceInterfaceClass()) + ", callerFrame=" + String.valueOf(this.getCallerFrame()) + ")";
    }

    public static final class StackFrameValue {
        @NonNull
        private final String className;
        @NonNull
        private final String methodName;
        private final int lineNumber;
        @Nullable
        private final String fileName;

        public static StackFrameValue from(@NonNull StackTraceElement stackTraceElement) {
            if (stackTraceElement == null) {
                throw new NullPointerException("stackTraceElement is marked non-null but is null");
            }
            return StackFrameValue.builder().fileName(stackTraceElement.getFileName()).className(stackTraceElement.getClassName()).methodName(stackTraceElement.getMethodName()).lineNumber(stackTraceElement.getLineNumber()).build();
        }

        @Generated
        StackFrameValue(@NonNull String className, @NonNull String methodName, int lineNumber, @Nullable String fileName) {
            if (className == null) {
                throw new NullPointerException("className is marked non-null but is null");
            }
            if (methodName == null) {
                throw new NullPointerException("methodName is marked non-null but is null");
            }
            this.className = className;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
            this.fileName = fileName;
        }

        @Generated
        public static StackFrameValueBuilder builder() {
            return new StackFrameValueBuilder();
        }

        @NonNull
        @Generated
        public String getClassName() {
            return this.className;
        }

        @NonNull
        @Generated
        public String getMethodName() {
            return this.methodName;
        }

        @Generated
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Nullable
        @Generated
        public String getFileName() {
            return this.fileName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StackFrameValue)) {
                return false;
            }
            StackFrameValue other = (StackFrameValue)o;
            if (this.getLineNumber() != other.getLineNumber()) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            return !(this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLineNumber();
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LogEvent.StackFrameValue(className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ", lineNumber=" + this.getLineNumber() + ", fileName=" + this.getFileName() + ")";
        }

        @Generated
        public static class StackFrameValueBuilder {
            @Generated
            private String className;
            @Generated
            private String methodName;
            @Generated
            private int lineNumber;
            @Generated
            private String fileName;

            @Generated
            StackFrameValueBuilder() {
            }

            @Generated
            public StackFrameValueBuilder className(@NonNull String className) {
                if (className == null) {
                    throw new NullPointerException("className is marked non-null but is null");
                }
                this.className = className;
                return this;
            }

            @Generated
            public StackFrameValueBuilder methodName(@NonNull String methodName) {
                if (methodName == null) {
                    throw new NullPointerException("methodName is marked non-null but is null");
                }
                this.methodName = methodName;
                return this;
            }

            @Generated
            public StackFrameValueBuilder lineNumber(int lineNumber) {
                this.lineNumber = lineNumber;
                return this;
            }

            @Generated
            public StackFrameValueBuilder fileName(@Nullable String fileName) {
                this.fileName = fileName;
                return this;
            }

            @Generated
            public StackFrameValue build() {
                return new StackFrameValue(this.className, this.methodName, this.lineNumber, this.fileName);
            }

            @Generated
            public String toString() {
                return "LogEvent.StackFrameValue.StackFrameValueBuilder(className=" + this.className + ", methodName=" + this.methodName + ", lineNumber=" + this.lineNumber + ", fileName=" + this.fileName + ")";
            }
        }
    }

    public record ThreadValue(@NonNull String name, long id) {
        @Generated
        public ThreadValue(@NonNull String name, long id) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
        }
    }

    @Generated
    public static class LogEventBuilder {
        @Generated
        private NativeLogger nativeLogger;
        @Generated
        private ThreadValue callerThread;
        @Generated
        private Object message;
        @Generated
        private Object[] arguments;
        @Generated
        private Throwable throwable;
        @Generated
        private Class<?> serviceInterfaceClass;
        @Generated
        private StackFrameValue callerFrame;

        @Generated
        LogEventBuilder() {
        }

        @Generated
        public LogEventBuilder nativeLogger(@NonNull NativeLogger nativeLogger) {
            if (nativeLogger == null) {
                throw new NullPointerException("nativeLogger is marked non-null but is null");
            }
            this.nativeLogger = nativeLogger;
            return this;
        }

        @Generated
        public LogEventBuilder callerThread(@NonNull ThreadValue callerThread) {
            if (callerThread == null) {
                throw new NullPointerException("callerThread is marked non-null but is null");
            }
            this.callerThread = callerThread;
            return this;
        }

        @Generated
        public LogEventBuilder message(@Nullable Object message) {
            this.message = message;
            return this;
        }

        @Generated
        public LogEventBuilder arguments(@Nullable Object[] arguments) {
            this.arguments = arguments;
            return this;
        }

        @Generated
        public LogEventBuilder throwable(@Nullable Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        @Generated
        public LogEventBuilder serviceInterfaceClass(@Nullable Class<?> serviceInterfaceClass) {
            this.serviceInterfaceClass = serviceInterfaceClass;
            return this;
        }

        @Generated
        public LogEventBuilder callerFrame(@Nullable StackFrameValue callerFrame) {
            this.callerFrame = callerFrame;
            return this;
        }

        @Generated
        public LogEvent build() {
            return new LogEvent(this.nativeLogger, this.callerThread, this.message, this.arguments, this.throwable, this.serviceInterfaceClass, this.callerFrame);
        }

        @Generated
        public String toString() {
            return "LogEvent.LogEventBuilder(nativeLogger=" + String.valueOf(this.nativeLogger) + ", callerThread=" + String.valueOf(this.callerThread) + ", message=" + String.valueOf(this.message) + ", arguments=" + Arrays.deepToString(this.arguments) + ", throwable=" + String.valueOf(this.throwable) + ", serviceInterfaceClass=" + String.valueOf(this.serviceInterfaceClass) + ", callerFrame=" + String.valueOf(this.callerFrame) + ")";
        }
    }
}

