/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service;

import elf4j.util.IeLogger;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

public enum NativeLogServiceManager {
    INSTANCE;

    private final Set<Refreshable> refreshables = new HashSet<Refreshable>();
    private final Set<Stoppable> stoppables = new HashSet<Stoppable>();
    private final Lock lock = new ReentrantLock();

    private NativeLogServiceManager() {
        Runtime.getRuntime().addShutdownHook(this.getShutdownHookThread());
    }

    public void register(Refreshable refreshable) {
        this.lockAndRun(() -> this.refreshables.add(refreshable));
        IeLogger.INFO.log("Registered refreshable {} in {}", new Object[]{refreshable, this});
    }

    public void register(Stoppable stoppable) {
        this.lockAndRun(() -> this.stoppables.add(stoppable));
        IeLogger.INFO.log("Registered stoppable {} in {}", new Object[]{stoppable, this});
    }

    public void restart() {
        this.lockAndRun(() -> {
            this.shutdown();
            this.refreshables.forEach(Refreshable::refresh);
        });
        IeLogger.INFO.log("Restarted {} by reloading properties", new Object[]{this});
    }

    public void restart(Properties properties) {
        this.lockAndRun(() -> {
            this.shutdown();
            this.refreshables.forEach(refreshable -> refreshable.refresh(properties));
        });
        IeLogger.INFO.log("Restarted {} with properties {}", new Object[]{this, properties});
    }

    public void shutdown() {
        this.lockAndRun(() -> {
            this.stoppables.forEach(Stoppable::stop);
            this.stoppables.clear();
        });
        IeLogger.INFO.log("Shut down {}", new Object[]{this});
    }

    @NonNull
    public Thread getShutdownHookThread() {
        return new Thread(this::shutdown);
    }

    public void deregister(Refreshable refreshable) {
        this.lockAndRun(() -> this.refreshables.remove(refreshable));
        IeLogger.INFO.log("De-registered Refreshable {}", new Object[]{refreshable});
    }

    private void lockAndRun(@NonNull Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("runnable is marked non-null but is null");
        }
        this.lock.lock();
        try {
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Generated
    public String toString() {
        return "NativeLogServiceManager." + this.name() + "(refreshables=" + String.valueOf(this.refreshables) + ", stoppables=" + String.valueOf(this.stoppables) + ")";
    }

    public static interface Refreshable {
        public void refresh(@Nullable Properties var1);

        public void refresh();
    }

    public static interface Stoppable {
        public void stop();
    }
}

