/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.PatternElement;
import elf4j.engine.service.pattern.PatternElements;
import java.util.NoSuchElementException;
import lombok.NonNull;
import org.slf4j.MDC;

public class ContextElement
implements PatternElement {
    final String key;

    public ContextElement(String key) {
        this.key = key;
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @NonNull
    public static ContextElement from(String patternSegment) {
        return new ContextElement(PatternElements.getPatternElementDisplayOption(patternSegment).orElseThrow(() -> new NoSuchElementException("No key configured in 'context' pattern element")));
    }

    @Override
    public void render(LogEvent logEvent, @NonNull StringBuilder target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        String value = MDC.get((String)this.key);
        target.append(value == null ? "" : value);
    }
}

