/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.PatternElement;
import elf4j.engine.service.util.StackTraces;
import lombok.Generated;
import lombok.NonNull;

final class MessageAndExceptionElement
implements PatternElement {
    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @Override
    public void render(@NonNull LogEvent logEvent, @NonNull StringBuilder target) {
        if (logEvent == null) {
            throw new NullPointerException("logEvent is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        target.append(logEvent.getResolvedMessage());
        Throwable t = logEvent.getThrowable();
        if (t == null) {
            return;
        }
        target.append(System.lineSeparator()).append(StackTraces.getTraceAsBuffer(t));
    }

    @Generated
    public MessageAndExceptionElement() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof MessageAndExceptionElement;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "MessageAndExceptionElement()";
    }
}

