/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.pattern.ClassElement;
import elf4j.engine.service.pattern.ContextElement;
import elf4j.engine.service.pattern.FileNameElement;
import elf4j.engine.service.pattern.JsonElement;
import elf4j.engine.service.pattern.LevelElement;
import elf4j.engine.service.pattern.LineNumberElement;
import elf4j.engine.service.pattern.MessageAndExceptionElement;
import elf4j.engine.service.pattern.MethodElement;
import elf4j.engine.service.pattern.PatternElement;
import elf4j.engine.service.pattern.SystemEnvironmentElement;
import elf4j.engine.service.pattern.SystemPropertyElement;
import elf4j.engine.service.pattern.ThreadElement;
import elf4j.engine.service.pattern.TimestampElement;
import java.util.Arrays;
import java.util.Optional;
import lombok.NonNull;

class PatternElements {
    private PatternElements() {
    }

    static Optional<String> getPatternElementDisplayOption(@NonNull String patternElement) {
        if (patternElement == null) {
            throw new NullPointerException("patternElement is marked non-null but is null");
        }
        String[] elements = patternElement.split(":", 2);
        return elements.length == 1 ? Optional.empty() : Optional.of(elements[1].trim());
    }

    static PatternElement parsePredefinedPatternELement(String predefinedPatternElement) {
        return Arrays.stream(PredefinedPatternElement.values()).filter(type -> type.isTargetTypeOf(predefinedPatternElement)).findFirst().orElseThrow(() -> new IllegalArgumentException("Predefined pattern element: '" + predefinedPatternElement + "'")).parse(predefinedPatternElement);
    }

    @NonNull
    private static String getPatternElementName(@NonNull String patternElement) {
        if (patternElement == null) {
            throw new NullPointerException("patternElement is marked non-null but is null");
        }
        return patternElement.split(":", 2)[0].trim();
    }

    static enum PredefinedPatternElement {
        TIMESTAMP{

            @Override
            PatternElement parse(String patternElement) {
                return TimestampElement.from(patternElement);
            }
        }
        ,
        LEVEL{

            @Override
            PatternElement parse(String patternElement) {
                return LevelElement.from(patternElement);
            }
        }
        ,
        THREAD{

            @Override
            PatternElement parse(String patternElement) {
                return ThreadElement.from(patternElement);
            }
        }
        ,
        CLASS{

            @Override
            PatternElement parse(String patternElement) {
                return ClassElement.from(patternElement);
            }
        }
        ,
        METHOD{

            @Override
            PatternElement parse(String patternElement) {
                return new MethodElement();
            }
        }
        ,
        FILENAME{

            @Override
            PatternElement parse(String patternElement) {
                return new FileNameElement();
            }
        }
        ,
        LINENUMBER{

            @Override
            PatternElement parse(String patternElement) {
                return new LineNumberElement();
            }
        }
        ,
        MESSAGE{

            @Override
            PatternElement parse(String patternElement) {
                return new MessageAndExceptionElement();
            }
        }
        ,
        JSON{

            @Override
            PatternElement parse(String patternElement) {
                return JsonElement.from(patternElement);
            }
        }
        ,
        SYSPROP{

            @Override
            PatternElement parse(String patternElement) {
                return SystemPropertyElement.from(patternElement);
            }
        }
        ,
        SYSENV{

            @Override
            PatternElement parse(String patternElement) {
                return SystemEnvironmentElement.from(patternElement);
            }
        }
        ,
        CONTEXT{

            @Override
            PatternElement parse(String patternElement) {
                return ContextElement.from(patternElement);
            }
        };


        abstract PatternElement parse(String var1);

        private boolean isTargetTypeOf(String patternElement) {
            return this.name().equalsIgnoreCase(PatternElements.getPatternElementName(patternElement));
        }
    }
}

