/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.service.pattern;

import elf4j.engine.service.LogEvent;
import elf4j.engine.service.pattern.PatternElement;
import elf4j.engine.service.pattern.PatternElements;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nonnull;
import lombok.NonNull;

record TimestampElement(DateTimeFormatter dateTimeFormatter) implements PatternElement
{
    private static final String DEFAULT_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static final ZoneId DISPLAY_TIME_ZONE = ZoneId.systemDefault();

    @Nonnull
    public static TimestampElement from(@NonNull String patternSegment) {
        if (patternSegment == null) {
            throw new NullPointerException("patternSegment is marked non-null but is null");
        }
        return new TimestampElement(DateTimeFormatter.ofPattern(PatternElements.getPatternElementDisplayOption(patternSegment).orElse(DEFAULT_DATETIME_PATTERN)).withZone(DISPLAY_TIME_ZONE));
    }

    @Override
    public String toString() {
        return "TimestampElement{sample=" + this.dateTimeFormatter.format(Instant.now()) + "}";
    }

    @Override
    public boolean includeCallerDetail() {
        return false;
    }

    @Override
    public void render(@NonNull LogEvent logEvent, @NonNull StringBuilder target) {
        if (logEvent == null) {
            throw new NullPointerException("logEvent is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.dateTimeFormatter.formatTo(logEvent.getTimestamp(), target);
    }
}

