/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine;

import elf4j.Level;
import elf4j.Logger;
import elf4j.engine.logging.LogHandlerFactory;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public class NativeLogger
implements Logger {
    private static final Set<String> LOG_SERVICE_CLASS_NAMES = Set.of(NativeLogger.class.getName(), Logger.class.getName());
    static final String DEFAULT_THROWABLE_MESSAGE = "";
    private final LoggerId loggerId;
    private final LogHandlerFactory logHandlerFactory;

    NativeLogger(LoggerId loggerId, LogHandlerFactory logHandlerFactory) {
        this.loggerId = loggerId;
        this.logHandlerFactory = logHandlerFactory;
    }

    public NativeLogger atLevel(Level level) {
        return this.loggerId.level == level ? this : new NativeLogger(new LoggerId(this.loggerId.loggerName, level), this.logHandlerFactory);
    }

    public Level getLevel() {
        return this.loggerId.level;
    }

    public boolean isEnabled() {
        return this.logHandlerFactory.getLogHandler().isEnabled(this.loggerId);
    }

    public void log(Object message) {
        this.process(LOG_SERVICE_CLASS_NAMES, null, message, null);
    }

    public void log(String message, Object ... arguments) {
        this.process(LOG_SERVICE_CLASS_NAMES, null, message, arguments);
    }

    public void log(Throwable throwable) {
        this.process(LOG_SERVICE_CLASS_NAMES, throwable, DEFAULT_THROWABLE_MESSAGE, null);
    }

    public void log(Throwable throwable, Object message) {
        this.process(LOG_SERVICE_CLASS_NAMES, throwable, message, null);
    }

    public void log(Throwable throwable, String message, Object ... arguments) {
        this.process(LOG_SERVICE_CLASS_NAMES, throwable, message, arguments);
    }

    public void process(Set<String> logServiceClassNames, @Nullable Throwable throwable, @Nullable Object message, Object @Nullable [] arguments) {
        this.logHandlerFactory.getLogHandler().log(this.loggerId, logServiceClassNames, throwable, message, arguments);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NativeLogger)) {
            return false;
        }
        NativeLogger other = (NativeLogger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LoggerId this$loggerId = this.getLoggerId();
        LoggerId other$loggerId = other.getLoggerId();
        return !(this$loggerId == null ? other$loggerId != null : !((Object)this$loggerId).equals(other$loggerId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NativeLogger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoggerId $loggerId = this.getLoggerId();
        result = result * 59 + ($loggerId == null ? 43 : ((Object)$loggerId).hashCode());
        return result;
    }

    @Generated
    public LoggerId getLoggerId() {
        return this.loggerId;
    }

    public record LoggerId(String loggerName, Level level) {
    }
}

