/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine;

import elf4j.Level;
import elf4j.Logger;
import elf4j.engine.NativeLogger;
import elf4j.engine.logging.ConfiguredLogHandlerFactory;
import elf4j.engine.logging.LogHandlerFactory;
import elf4j.engine.logging.util.StackTraces;
import elf4j.spi.LoggerFactory;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.MdcAdapterInitializer;

public class NativeLoggerFactory
implements LoggerFactory {
    private static final Level DEFAULT_LOGGER_SEVERITY_LEVEL = Level.INFO;
    private static final Set<Class<?>> ELF4J_SERVICE_ACCESS_CLASSES = Set.of(Logger.class);
    private final Level defaultLoggerLevel;
    private final Set<String> logServiceAccessClassNames;
    private final LogHandlerFactory logHandlerFactory;

    public NativeLoggerFactory() {
        this(ELF4J_SERVICE_ACCESS_CLASSES);
    }

    public NativeLoggerFactory(Set<Class<?>> logServiceAccessClasses) {
        this(logServiceAccessClasses, DEFAULT_LOGGER_SEVERITY_LEVEL, new ConfiguredLogHandlerFactory());
    }

    private NativeLoggerFactory(Set<Class<?>> logServiceAccessClasses, Level defaultLoggerLevel, LogHandlerFactory logHandlerFactory) {
        MdcAdapterInitializer.initialize();
        this.logServiceAccessClassNames = logServiceAccessClasses.stream().map(Class::getName).collect(Collectors.toSet());
        this.defaultLoggerLevel = defaultLoggerLevel;
        this.logHandlerFactory = logHandlerFactory;
    }

    public NativeLogger getLogger() {
        return new NativeLogger(new NativeLogger.LoggerId(StackTraces.earliestCallerOfAny(this.logServiceAccessClassNames).getClassName(), this.defaultLoggerLevel), this.logHandlerFactory);
    }
}

