/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.logging;

import elf4j.Logger;
import elf4j.engine.NativeLogger;
import elf4j.engine.logging.LogEvent;
import elf4j.engine.logging.LogHandler;
import elf4j.engine.logging.config.ConfigurationProperties;
import elf4j.engine.logging.config.LoggerOutputMinimumLevelThreshold;
import elf4j.engine.logging.util.StackTraces;
import elf4j.engine.logging.writer.CompositeWriter;
import elf4j.engine.logging.writer.LogWriter;
import elf4j.util.UtilLogger;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class EventingLogHandler
implements LogHandler {
    private static final Logger LOGGER = UtilLogger.WARN;
    private final boolean noop;
    private final @Nullable LogWriter logWriter;
    private final @Nullable LoggerOutputMinimumLevelThreshold loggerOutputMinimumLevelThreshold;
    private final Map<NativeLogger.LoggerId, Boolean> loggerEnablements = new ConcurrentHashMap<NativeLogger.LoggerId, Boolean>();

    public EventingLogHandler(ConfigurationProperties configurationProperties) {
        if (configurationProperties.isAbsent() || configurationProperties.isTrue("noop")) {
            this.noop = true;
            LOGGER.warn((Object)"No-op per configuration %s".formatted(configurationProperties));
            this.logWriter = null;
            this.loggerOutputMinimumLevelThreshold = null;
            return;
        }
        this.noop = false;
        this.logWriter = CompositeWriter.from(configurationProperties);
        this.loggerOutputMinimumLevelThreshold = LoggerOutputMinimumLevelThreshold.from(configurationProperties);
    }

    @Override
    public boolean isEnabled(NativeLogger.LoggerId loggerId) {
        if (this.noop) {
            return false;
        }
        assert (this.loggerOutputMinimumLevelThreshold != null);
        assert (this.logWriter != null);
        return this.loggerEnablements.computeIfAbsent(loggerId, k -> k.level().compareTo((Enum)this.loggerOutputMinimumLevelThreshold.getMinimumThresholdLevel(k.loggerName())) >= 0 && k.level().compareTo((Enum)this.logWriter.getMinimumThresholdLevel()) >= 0);
    }

    @Override
    public void log(NativeLogger.LoggerId loggerId, Set<String> logServiceClassNames, @Nullable Throwable throwable, @Nullable Object message, Object @Nullable [] arguments) {
        if (!this.isEnabled(loggerId)) {
            return;
        }
        assert (this.logWriter != null);
        Thread callerThread = Thread.currentThread();
        this.logWriter.write(LogEvent.builder().callerThread(new LogEvent.ThreadValue(callerThread.getName(), callerThread.threadId())).level(loggerId.level()).throwable(throwable).message(message).arguments(arguments).loggerName(loggerId.loggerName()).callerFrame(this.logWriter.includeCallerDetail() ? LogEvent.StackFrameValue.from(StackTraces.earliestCallerOfAny(logServiceClassNames)) : null).build());
    }

    @Generated
    public boolean isNoop() {
        return this.noop;
    }

    @Generated
    public @Nullable LogWriter getLogWriter() {
        return this.logWriter;
    }

    @Generated
    public @Nullable LoggerOutputMinimumLevelThreshold getLoggerOutputMinimumLevelThreshold() {
        return this.loggerOutputMinimumLevelThreshold;
    }

    @Generated
    public Map<NativeLogger.LoggerId, Boolean> getLoggerEnablements() {
        return this.loggerEnablements;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventingLogHandler)) {
            return false;
        }
        EventingLogHandler other = (EventingLogHandler)o;
        if (this.isNoop() != other.isNoop()) {
            return false;
        }
        LogWriter this$logWriter = this.getLogWriter();
        LogWriter other$logWriter = other.getLogWriter();
        if (this$logWriter == null ? other$logWriter != null : !this$logWriter.equals(other$logWriter)) {
            return false;
        }
        LoggerOutputMinimumLevelThreshold this$loggerOutputMinimumLevelThreshold = this.getLoggerOutputMinimumLevelThreshold();
        LoggerOutputMinimumLevelThreshold other$loggerOutputMinimumLevelThreshold = other.getLoggerOutputMinimumLevelThreshold();
        return !(this$loggerOutputMinimumLevelThreshold == null ? other$loggerOutputMinimumLevelThreshold != null : !((Object)this$loggerOutputMinimumLevelThreshold).equals(other$loggerOutputMinimumLevelThreshold));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNoop() ? 79 : 97);
        LogWriter $logWriter = this.getLogWriter();
        result = result * 59 + ($logWriter == null ? 43 : $logWriter.hashCode());
        LoggerOutputMinimumLevelThreshold $loggerOutputMinimumLevelThreshold = this.getLoggerOutputMinimumLevelThreshold();
        result = result * 59 + ($loggerOutputMinimumLevelThreshold == null ? 43 : ((Object)$loggerOutputMinimumLevelThreshold).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EventingLogHandler(noop=" + this.isNoop() + ", logWriter=" + String.valueOf(this.getLogWriter()) + ", loggerOutputMinimumLevelThreshold=" + String.valueOf(this.getLoggerOutputMinimumLevelThreshold()) + ", loggerEnablements=" + String.valueOf(this.getLoggerEnablements()) + ")";
    }
}

