/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.logging;

import elf4j.Level;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class LogEvent {
    private static final int INIT_ARG_LENGTH = 32;
    private final Level level;
    private final String loggerName;
    private final ThreadValue callerThread;
    private final Instant timestamp = Instant.now();
    private final @Nullable Object message;
    private final Object @Nullable [] arguments;
    private final @Nullable Throwable throwable;
    private final @Nullable StackFrameValue callerFrame;

    private static CharSequence resolve(@Nullable Object message, Object @Nullable [] arguments) {
        String suppliedMessage = Objects.toString(LogEvent.supply(message));
        if (message == null || arguments == null || arguments.length == 0) {
            return suppliedMessage;
        }
        int messageLength = suppliedMessage.length();
        StringBuilder resolvedMessage = new StringBuilder(messageLength + 32);
        int im = 0;
        int ia = 0;
        while (im < messageLength) {
            char character = suppliedMessage.charAt(im);
            if (character == '{' && im + 1 < messageLength && suppliedMessage.charAt(im + 1) == '}' && ia < arguments.length) {
                resolvedMessage.append(LogEvent.supply(arguments[ia++]));
                im += 2;
                continue;
            }
            resolvedMessage.append(character);
            ++im;
        }
        return resolvedMessage;
    }

    private static @Nullable Object supply(@Nullable Object o) {
        return o instanceof Supplier ? ((Supplier)o).get() : o;
    }

    public CharSequence getResolvedMessage() {
        return LogEvent.resolve(this.message, this.arguments);
    }

    @Generated
    LogEvent(Level level, String loggerName, ThreadValue callerThread, @Nullable Object message, Object @Nullable [] arguments, @Nullable Throwable throwable, @Nullable StackFrameValue callerFrame) {
        this.level = level;
        this.loggerName = loggerName;
        this.callerThread = callerThread;
        this.message = message;
        this.arguments = arguments;
        this.throwable = throwable;
        this.callerFrame = callerFrame;
    }

    @Generated
    public static LogEventBuilder builder() {
        return new LogEventBuilder();
    }

    @Generated
    public Level getLevel() {
        return this.level;
    }

    @Generated
    public String getLoggerName() {
        return this.loggerName;
    }

    @Generated
    public ThreadValue getCallerThread() {
        return this.callerThread;
    }

    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public @Nullable Object getMessage() {
        return this.message;
    }

    @Generated
    public Object @Nullable [] getArguments() {
        return this.arguments;
    }

    @Generated
    public @Nullable Throwable getThrowable() {
        return this.throwable;
    }

    @Generated
    public @Nullable StackFrameValue getCallerFrame() {
        return this.callerFrame;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogEvent)) {
            return false;
        }
        LogEvent other = (LogEvent)o;
        Level this$level = this.getLevel();
        Level other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        String this$loggerName = this.getLoggerName();
        String other$loggerName = other.getLoggerName();
        if (this$loggerName == null ? other$loggerName != null : !this$loggerName.equals(other$loggerName)) {
            return false;
        }
        ThreadValue this$callerThread = this.getCallerThread();
        ThreadValue other$callerThread = other.getCallerThread();
        if (this$callerThread == null ? other$callerThread != null : !((Object)this$callerThread).equals(other$callerThread)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Object this$message = this.getMessage();
        Object other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArguments(), other.getArguments())) {
            return false;
        }
        Throwable this$throwable = this.getThrowable();
        Throwable other$throwable = other.getThrowable();
        if (this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable)) {
            return false;
        }
        StackFrameValue this$callerFrame = this.getCallerFrame();
        StackFrameValue other$callerFrame = other.getCallerFrame();
        return !(this$callerFrame == null ? other$callerFrame != null : !((Object)this$callerFrame).equals(other$callerFrame));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Level $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        String $loggerName = this.getLoggerName();
        result = result * 59 + ($loggerName == null ? 43 : $loggerName.hashCode());
        ThreadValue $callerThread = this.getCallerThread();
        result = result * 59 + ($callerThread == null ? 43 : ((Object)$callerThread).hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Object $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArguments());
        Throwable $throwable = this.getThrowable();
        result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
        StackFrameValue $callerFrame = this.getCallerFrame();
        result = result * 59 + ($callerFrame == null ? 43 : ((Object)$callerFrame).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LogEvent(level=" + String.valueOf(this.getLevel()) + ", loggerName=" + this.getLoggerName() + ", callerThread=" + String.valueOf(this.getCallerThread()) + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", message=" + String.valueOf(this.getMessage()) + ", arguments=" + Arrays.deepToString(this.getArguments()) + ", throwable=" + String.valueOf(this.getThrowable()) + ", callerFrame=" + String.valueOf(this.getCallerFrame()) + ")";
    }

    public record ThreadValue(String name, long id) {
    }

    public static final class StackFrameValue {
        private final String className;
        private final String methodName;
        private final int lineNumber;
        private final @Nullable String fileName;

        public static StackFrameValue from(StackWalker.StackFrame stackFrame) {
            return StackFrameValue.builder().fileName(stackFrame.getFileName()).className(stackFrame.getClassName()).methodName(stackFrame.getMethodName()).lineNumber(stackFrame.getLineNumber()).build();
        }

        @Generated
        StackFrameValue(String className, String methodName, int lineNumber, @Nullable String fileName) {
            this.className = className;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
            this.fileName = fileName;
        }

        @Generated
        public static StackFrameValueBuilder builder() {
            return new StackFrameValueBuilder();
        }

        @Generated
        public String getClassName() {
            return this.className;
        }

        @Generated
        public String getMethodName() {
            return this.methodName;
        }

        @Generated
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Generated
        public @Nullable String getFileName() {
            return this.fileName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StackFrameValue)) {
                return false;
            }
            StackFrameValue other = (StackFrameValue)o;
            if (this.getLineNumber() != other.getLineNumber()) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            return !(this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLineNumber();
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LogEvent.StackFrameValue(className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ", lineNumber=" + this.getLineNumber() + ", fileName=" + this.getFileName() + ")";
        }

        @Generated
        public static class StackFrameValueBuilder {
            @Generated
            private String className;
            @Generated
            private String methodName;
            @Generated
            private int lineNumber;
            @Generated
            private String fileName;

            @Generated
            StackFrameValueBuilder() {
            }

            @Generated
            public StackFrameValueBuilder className(String className) {
                this.className = className;
                return this;
            }

            @Generated
            public StackFrameValueBuilder methodName(String methodName) {
                this.methodName = methodName;
                return this;
            }

            @Generated
            public StackFrameValueBuilder lineNumber(int lineNumber) {
                this.lineNumber = lineNumber;
                return this;
            }

            @Generated
            public StackFrameValueBuilder fileName(@Nullable String fileName) {
                this.fileName = fileName;
                return this;
            }

            @Generated
            public StackFrameValue build() {
                return new StackFrameValue(this.className, this.methodName, this.lineNumber, this.fileName);
            }

            @Generated
            public String toString() {
                return "LogEvent.StackFrameValue.StackFrameValueBuilder(className=" + this.className + ", methodName=" + this.methodName + ", lineNumber=" + this.lineNumber + ", fileName=" + this.fileName + ")";
            }
        }
    }

    @Generated
    public static class LogEventBuilder {
        @Generated
        private Level level;
        @Generated
        private String loggerName;
        @Generated
        private ThreadValue callerThread;
        @Generated
        private Object message;
        @Generated
        private Object @Nullable [] arguments;
        @Generated
        private Throwable throwable;
        @Generated
        private StackFrameValue callerFrame;

        @Generated
        LogEventBuilder() {
        }

        @Generated
        public LogEventBuilder level(Level level) {
            this.level = level;
            return this;
        }

        @Generated
        public LogEventBuilder loggerName(String loggerName) {
            this.loggerName = loggerName;
            return this;
        }

        @Generated
        public LogEventBuilder callerThread(ThreadValue callerThread) {
            this.callerThread = callerThread;
            return this;
        }

        @Generated
        public LogEventBuilder message(@Nullable Object message) {
            this.message = message;
            return this;
        }

        @Generated
        public LogEventBuilder arguments(Object @Nullable [] arguments) {
            this.arguments = arguments;
            return this;
        }

        @Generated
        public LogEventBuilder throwable(@Nullable Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        @Generated
        public LogEventBuilder callerFrame(@Nullable StackFrameValue callerFrame) {
            this.callerFrame = callerFrame;
            return this;
        }

        @Generated
        public LogEvent build() {
            return new LogEvent(this.level, this.loggerName, this.callerThread, this.message, this.arguments, this.throwable, this.callerFrame);
        }

        @Generated
        public String toString() {
            return "LogEvent.LogEventBuilder(level=" + String.valueOf(this.level) + ", loggerName=" + this.loggerName + ", callerThread=" + String.valueOf(this.callerThread) + ", message=" + String.valueOf(this.message) + ", arguments=" + Arrays.deepToString(this.arguments) + ", throwable=" + String.valueOf(this.throwable) + ", callerFrame=" + String.valueOf(this.callerFrame) + ")";
        }
    }
}

