/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.logging;

import elf4j.Logger;
import elf4j.util.UtilLogger;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public enum NativeLogServiceManager {
    INSTANCE;

    private static final Logger LOGGER;
    private final Set<Refreshable> refreshables = new HashSet<Refreshable>();
    private final Set<Stoppable> stoppables = new HashSet<Stoppable>();
    private final Lock lock = new ReentrantLock();

    private NativeLogServiceManager() {
        Runtime.getRuntime().addShutdownHook(this.getShutdownHookThread());
    }

    public void register(Refreshable refreshable) {
        this.lockAndRun(() -> this.refreshables.add(refreshable));
        LOGGER.info((Object)"Registered refreshable %s in %s".formatted(new Object[]{refreshable, this}));
    }

    public void register(Stoppable stoppable) {
        this.lockAndRun(() -> this.stoppables.add(stoppable));
        LOGGER.info((Object)"Registered stoppable %s in %s".formatted(new Object[]{stoppable, this}));
    }

    public void restart() {
        this.lockAndRun(() -> {
            this.shutdown();
            this.refreshables.forEach(Refreshable::refresh);
        });
        LOGGER.info((Object)"Restarted %s by reloading properties".formatted(new Object[]{this}));
    }

    public void restart(@Nullable Properties properties) {
        this.lockAndRun(() -> {
            this.shutdown();
            this.refreshables.forEach(refreshable -> refreshable.refresh(properties));
        });
        LOGGER.info((Object)"Restarted %s with properties %s".formatted(new Object[]{this, properties}));
    }

    public void shutdown() {
        this.lockAndRun(() -> {
            LOGGER.info((Object)"Start shutdown %s".formatted(new Object[]{this}));
            this.stoppables.forEach(Stoppable::stop);
            this.stoppables.clear();
            LOGGER.info((Object)"End shutdown %s".formatted(new Object[]{this}));
        });
    }

    public Thread getShutdownHookThread() {
        return new Thread(this::shutdown);
    }

    public void deregister(Refreshable refreshable) {
        this.lockAndRun(() -> this.refreshables.remove(refreshable));
        LOGGER.info((Object)"De-registered Refreshable %s".formatted(refreshable));
    }

    private void lockAndRun(Runnable runnable) {
        this.lock.lock();
        try {
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Generated
    public String toString() {
        return "NativeLogServiceManager." + this.name() + "(refreshables=" + String.valueOf(this.refreshables) + ", stoppables=" + String.valueOf(this.stoppables) + ")";
    }

    static {
        LOGGER = UtilLogger.INFO;
    }

    public static interface Refreshable {
        public void refresh(@Nullable Properties var1);

        public void refresh();
    }

    public static interface Stoppable {
        public void stop();
    }
}

