/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.logging.config;

import elf4j.Logger;
import elf4j.util.UtilLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public final class ConfigurationProperties {
    private static final Logger LOGGER = UtilLogger.INFO;
    private final @Nullable Properties properties;

    private ConfigurationProperties(@Nullable Properties properties) {
        this.properties = properties;
    }

    public static ConfigurationProperties byLoading() {
        LOGGER.info((Object)"Configuring by loading properties");
        return new ConfigurationProperties(new PropertiesFileLoader().load());
    }

    public static ConfigurationProperties bySetting(@Nullable Properties properties) {
        LOGGER.info((Object)"Configuring by setting properties: %s".formatted(properties));
        return new ConfigurationProperties(properties);
    }

    public boolean isAbsent() {
        return this.properties == null;
    }

    public @Nullable Integer getAsInteger(String name) {
        String value = this.getProperties().getProperty(name);
        if (value == null) {
            return null;
        }
        String digits = value.replaceAll("\\D", "");
        if (digits.isEmpty()) {
            return null;
        }
        int i = Integer.parseInt(digits);
        return value.startsWith("-") ? -i : i;
    }

    public Properties getProperties() {
        if (this.isAbsent()) {
            throw new IllegalStateException("No elf4j configuration present");
        }
        return Objects.requireNonNull(this.properties);
    }

    public boolean isTrue(String name) {
        return Boolean.parseBoolean(this.getProperties().getProperty(name));
    }

    @Generated
    public String toString() {
        return "ConfigurationProperties(properties=" + String.valueOf(this.properties) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigurationProperties)) {
            return false;
        }
        ConfigurationProperties other = (ConfigurationProperties)o;
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    static class PropertiesFileLoader {
        static final String ELF4J_PROPERTIES_LOCATION = "elf4j.properties.location";
        private static final String[] DEFAULT_PROPERTIES_LOCATIONS = new String[]{"/elf4j-test.properties", "/elf4j.properties"};

        PropertiesFileLoader() {
        }

        public @Nullable Properties load() {
            InputStream propertiesInputStream;
            Properties properties = new Properties();
            String customPropertiesLocation = System.getProperty(ELF4J_PROPERTIES_LOCATION);
            if (customPropertiesLocation == null) {
                propertiesInputStream = this.fromDefaultPropertiesLocation();
                if (propertiesInputStream == null) {
                    LOGGER.warn((Object)"No configuration file located!");
                    return null;
                }
            } else {
                propertiesInputStream = this.getClass().getResourceAsStream(customPropertiesLocation);
                if (propertiesInputStream == null) {
                    throw new IllegalArgumentException("Null resource stream from specified properties location: " + customPropertiesLocation);
                }
            }
            try {
                properties.load(propertiesInputStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Error loading properties stream from location: " + (customPropertiesLocation == null ? "default location" : customPropertiesLocation), e);
            }
            LOGGER.info((Object)"Loaded properties: %s".formatted(properties));
            return properties;
        }

        private @Nullable InputStream fromDefaultPropertiesLocation() {
            return Arrays.stream(DEFAULT_PROPERTIES_LOCATIONS).map(location -> this.getClass().getResourceAsStream((String)location)).filter(Objects::nonNull).findFirst().orElse(null);
        }
    }
}

