/*
 * Decompiled with CFR 0.152.
 */
package elf4j.engine.logging.config;

import elf4j.Level;
import elf4j.Logger;
import elf4j.engine.logging.config.ConfigurationProperties;
import elf4j.util.UtilLogger;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;

public final class LoggerOutputMinimumLevelThreshold {
    private static final Logger LOGGER = UtilLogger.INFO;
    private static final String ROOT_LOGGER_NAME = "";
    private static final Level DEFAULT_THRESHOLD_OUTPUT_LEVEL = Level.TRACE;
    private final Map<String, Level> loggerMinimumThresholdLevels;
    private final List<String> sortedLoggerNameNameSpaces;

    private LoggerOutputMinimumLevelThreshold(Map<String, Level> loggerMinimumThresholdLevels) {
        this.loggerMinimumThresholdLevels = loggerMinimumThresholdLevels;
        this.sortedLoggerNameNameSpaces = loggerMinimumThresholdLevels.keySet().stream().sorted(new FullyQualifiedClassNameComparator()).collect(Collectors.toList());
        LOGGER.info((Object)"%s overriding caller level(s) in %s".formatted(loggerMinimumThresholdLevels.size(), this));
    }

    public static LoggerOutputMinimumLevelThreshold from(ConfigurationProperties configurationProperties) {
        HashMap<String, Level> configuredLevels = new HashMap<String, Level>();
        Properties properties = configurationProperties.getProperties();
        LoggerOutputMinimumLevelThreshold.getAsLevel("level", properties).ifPresent(level -> configuredLevels.put(ROOT_LOGGER_NAME, (Level)level));
        configuredLevels.putAll(properties.stringPropertyNames().stream().filter(name -> name.trim().startsWith("level@")).filter(name -> !properties.getProperty((String)name).isBlank()).collect(Collectors.toMap(name -> name.split("@", 2)[1].trim(), name -> LoggerOutputMinimumLevelThreshold.getAsLevel(name, properties).orElseThrow(NoSuchElementException::new))));
        return new LoggerOutputMinimumLevelThreshold(configuredLevels);
    }

    private static Optional<Level> getAsLevel(String levelKey, Properties properties) {
        String levelValue = properties.getProperty(levelKey);
        return levelValue == null ? Optional.empty() : Optional.of(Level.valueOf((String)levelValue.trim().toUpperCase()));
    }

    public Level getMinimumThresholdLevel(String loggerName) {
        return this.sortedLoggerNameNameSpaces.stream().filter(loggerName::startsWith).findFirst().map(this.loggerMinimumThresholdLevels::get).orElse(DEFAULT_THRESHOLD_OUTPUT_LEVEL);
    }

    @Generated
    public Map<String, Level> getLoggerMinimumThresholdLevels() {
        return this.loggerMinimumThresholdLevels;
    }

    @Generated
    public List<String> getSortedLoggerNameNameSpaces() {
        return this.sortedLoggerNameNameSpaces;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoggerOutputMinimumLevelThreshold)) {
            return false;
        }
        LoggerOutputMinimumLevelThreshold other = (LoggerOutputMinimumLevelThreshold)o;
        Map<String, Level> this$loggerMinimumThresholdLevels = this.getLoggerMinimumThresholdLevels();
        Map<String, Level> other$loggerMinimumThresholdLevels = other.getLoggerMinimumThresholdLevels();
        return !(this$loggerMinimumThresholdLevels == null ? other$loggerMinimumThresholdLevels != null : !((Object)this$loggerMinimumThresholdLevels).equals(other$loggerMinimumThresholdLevels));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Level> $loggerMinimumThresholdLevels = this.getLoggerMinimumThresholdLevels();
        result = result * 59 + ($loggerMinimumThresholdLevels == null ? 43 : ((Object)$loggerMinimumThresholdLevels).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LoggerOutputMinimumLevelThreshold(loggerMinimumThresholdLevels=" + String.valueOf(this.getLoggerMinimumThresholdLevels()) + ", sortedLoggerNameNameSpaces=" + String.valueOf(this.getSortedLoggerNameNameSpaces()) + ")";
    }

    static class FullyQualifiedClassNameComparator
    implements Comparator<String> {
        static final Comparator<String> BY_LENGTH_REVERSED = Comparator.comparingInt(String::length).reversed();

        FullyQualifiedClassNameComparator() {
        }

        private static int getPackageLevels(String fqcn) {
            return fqcn.split("\\.").length;
        }

        @Override
        public int compare(String fqcn1, String fqcn2) {
            int byPackageLevel = Comparator.comparingInt(FullyQualifiedClassNameComparator::getPackageLevels).reversed().compare(fqcn1, fqcn2);
            if (byPackageLevel != 0) {
                return byPackageLevel;
            }
            int byLength = BY_LENGTH_REVERSED.compare(fqcn1, fqcn2);
            if (byLength != 0) {
                return byLength;
            }
            return fqcn1.compareTo(fqcn2);
        }
    }
}

